/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform;

import com.linkedin.data.message.Message;
import com.linkedin.data.message.MessageList;
import com.linkedin.data.transform.FastFailException;
import com.linkedin.data.transform.ImmutableList;
import com.linkedin.data.transform.Instruction;
import com.linkedin.data.transform.InstructionScheduler;

public class InterpreterContext {
    private final MessageList<Message> _errorMessages = new MessageList();
    private final MessageList<Message> _infoMessages = new MessageList();
    private Instruction _currentInstruction;
    private final boolean _fastFail;
    private Object _currentField;
    private final InstructionScheduler _instructionScheduler;

    public InterpreterContext(boolean fastFail, InstructionScheduler instructionScheduler) {
        this._fastFail = fastFail;
        this._instructionScheduler = instructionScheduler;
    }

    public boolean isFastFail() {
        return this._fastFail;
    }

    public void addErrorMessage(String format, Object ... args) throws FastFailException {
        this._errorMessages.add((Object)new Message(this.getPath().toArray(), format, args));
        if (this.isFastFail()) {
            throw new FastFailException();
        }
    }

    public void addInfoMessage(String format, Object ... args) {
        this._infoMessages.add((Object)new Message(this.getPath().toArray(), false, format, args));
    }

    public boolean failed() {
        return !this._errorMessages.isEmpty();
    }

    public MessageList<Message> getErrorMessages() {
        return this._errorMessages;
    }

    public MessageList<Message> getInfoMessages() {
        return this._infoMessages;
    }

    public Instruction getCurrentInstruction() {
        return this._currentInstruction;
    }

    public void setCurrentInstruction(Instruction currentInstruction) {
        this._currentInstruction = currentInstruction;
    }

    public ImmutableList<Object> getPath() {
        if (this._currentField == null) {
            return this._currentInstruction.getInstructionPath();
        }
        return this._currentInstruction.getInstructionPath().append(this._currentField);
    }

    public Object getCurrentField() {
        return this._currentField;
    }

    public void setCurrentField(Object field) {
        this._currentField = field;
    }

    public void scheduleInstruction(Instruction instruction) {
        this._instructionScheduler.scheduleInstruction(instruction);
    }
}

