/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.schemareg;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.kafka.schemareg.CachingKafkaSchemaRegistry;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSchemaRegistryFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaSchemaRegistryFactory.class);
    public static final String DEFAULT_TRY_CACHING = "true";

    public static KafkaSchemaRegistry getSchemaRegistry(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey("kafka.schemaRegistry.class"), (Object)"Missing required property kafka.schemaRegistry.class");
        boolean tryCache = Boolean.parseBoolean(props.getProperty("kafka.schemaRegistry.cache", DEFAULT_TRY_CACHING));
        try {
            Class<?> clazz = Class.forName(props.getProperty("kafka.schemaRegistry.class"));
            CachingKafkaSchemaRegistry schemaRegistry = (CachingKafkaSchemaRegistry)ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[]{props});
            if (tryCache && !schemaRegistry.hasInternalCache()) {
                schemaRegistry = new CachingKafkaSchemaRegistry(schemaRegistry);
            }
            return schemaRegistry;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to instantiate " + KafkaSchemaRegistry.class, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

