/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.disruptor;

import com.linkedin.r2.disruptor.DisruptContext;
import com.linkedin.r2.disruptor.DisruptContexts;
import com.linkedin.r2.disruptor.DisruptedException;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.util.ArgumentUtil;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptFilter
implements StreamFilter,
RestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(DisruptFilter.class);
    private final ScheduledExecutorService _scheduler;
    private final ExecutorService _executor;
    private final int _requestTimeout;

    public DisruptFilter(ScheduledExecutorService scheduler, ExecutorService executor, int requestTimeout) {
        ArgumentUtil.notNull((Object)scheduler, (String)"scheduler");
        ArgumentUtil.notNull((Object)executor, (String)"executor");
        this._scheduler = scheduler;
        this._executor = executor;
        this._requestTimeout = requestTimeout;
    }

    public void onStreamRequest(StreamRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        this.doDisrupt(req, requestContext, wireAttrs, nextFilter);
    }

    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        this.doDisrupt(req, requestContext, wireAttrs, nextFilter);
    }

    private <REQ extends Request, RES extends Response> void doDisrupt(REQ req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<REQ, RES> nextFilter) {
        DisruptContext context = (DisruptContext)requestContext.getLocalAttr("R2_DISRUPT_CONTEXT");
        if (context == null) {
            nextFilter.onRequest(req, requestContext, wireAttrs);
            return;
        }
        try {
            switch (context.mode()) {
                case DELAY: {
                    DisruptContexts.DelayDisruptContext delayContext = (DisruptContexts.DelayDisruptContext)context;
                    this._scheduler.schedule(() -> {
                        try {
                            this._executor.execute(() -> nextFilter.onRequest(req, requestContext, wireAttrs));
                        }
                        catch (RejectedExecutionException e) {
                            LOG.error("Unable to continue filter chain execution after {} disrupt.", (Object)context.mode(), (Object)e);
                        }
                    }, delayContext.delay(), TimeUnit.MILLISECONDS);
                    break;
                }
                case ERROR: {
                    DisruptContexts.ErrorDisruptContext errorContext = (DisruptContexts.ErrorDisruptContext)context;
                    this._scheduler.schedule(() -> {
                        try {
                            DisruptedException throwable = new DisruptedException("Request is disrupted with an error response");
                            this._executor.execute(() -> nextFilter.onError((Throwable)throwable, requestContext, wireAttrs));
                        }
                        catch (RejectedExecutionException e) {
                            LOG.error("Unable to continue filter chain execution after {} disrupt.", (Object)context.mode(), (Object)e);
                        }
                    }, errorContext.latency(), TimeUnit.MILLISECONDS);
                    break;
                }
                case TIMEOUT: {
                    this._scheduler.schedule(() -> {
                        try {
                            this._executor.execute(() -> nextFilter.onError((Throwable)new TimeoutException("Exceeded request timeout of " + this._requestTimeout + "ms due to disrupt"), requestContext, wireAttrs));
                        }
                        catch (RejectedExecutionException e) {
                            LOG.error("Unable to continue filter chain execution after {} disrupt.", (Object)context.mode(), (Object)e);
                        }
                    }, (long)this._requestTimeout, TimeUnit.MILLISECONDS);
                    break;
                }
                default: {
                    LOG.warn("Unrecognized disrupt mode {}", (Object)context.mode());
                    nextFilter.onRequest(req, requestContext, wireAttrs);
                    break;
                }
            }
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Unable to perform {} disrupt", (Object)context.mode(), (Object)e);
            nextFilter.onRequest(req, requestContext, wireAttrs);
        }
    }
}

