/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.TimerType;
import java.time.Duration;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Timer {
    private static ScheduledThreadPoolExecutor executor = null;
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private static final HashSet<String> references = new HashSet();
    private static final Object syncReferences = new Object();

    private Timer() {
    }

    public static ScheduledFuture<?> schedule(Runnable runnable, Duration runFrequency, TimerType timerType) {
        switch (timerType) {
            case OneTimeRun: {
                return executor.schedule(runnable, runFrequency.toMillis(), TimeUnit.MILLISECONDS);
            }
            case RepeatRun: {
                return executor.scheduleWithFixedDelay(runnable, runFrequency.toMillis(), runFrequency.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        throw new UnsupportedOperationException("Unsupported timer pattern.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(String clientId) {
        Object object = syncReferences;
        synchronized (object) {
            if (references.size() == 0 && (executor == null || executor.isShutdown())) {
                int corePoolSize = Math.max(Runtime.getRuntime().availableProcessors(), 4);
                if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                    TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "Starting ScheduledThreadPoolExecutor with coreThreadPoolSize: %s", corePoolSize));
                }
                executor = new ScheduledThreadPoolExecutor(corePoolSize);
            }
            references.add(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(String clientId) {
        Object object = syncReferences;
        synchronized (object) {
            if (references.remove(clientId) && references.size() == 0 && executor != null) {
                if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                    TRACE_LOGGER.log(Level.FINE, "Shuting down ScheduledThreadPoolExecutor.");
                }
                executor.shutdownNow();
            }
        }
    }
}

