/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.http;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.converter.http.RestEntry;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.http.AbstractHttpWriterBuilder;
import org.apache.gobblin.writer.http.SalesforceRestWriter;

public class SalesForceRestWriterBuilder
extends AbstractHttpWriterBuilder<Void, RestEntry<JsonObject>, SalesForceRestWriterBuilder> {
    static final String SFDC_PREFIX = "salesforce.";
    static final String CLIENT_ID = "salesforce.client_id";
    static final String CLIENT_SECRET = "salesforce.client_secret";
    static final String USER_ID = "salesforce.user_id";
    static final String PASSWORD = "salesforce.password";
    static final String SFDC_ENCRYPT_KEY_LOC = "salesforce.encrypt.key.loc";
    static final String USE_STRONG_ENCRYPTION = "salesforce.strong_encryption";
    static final String SECURITY_TOKEN = "salesforce.security_token";
    static final String OPERATION = "salesforce.operation";
    static final String BATCH_SIZE = "salesforce.batch_size";
    static final String BATCH_RESOURCE_PATH = "salesforce.batch_resource_path";
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"static_svc_endpoint", (Object)"https://login.salesforce.com/services/oauth2/token").put((Object)"salesforce.security_token", (Object)"").put((Object)"salesforce.batch_size", (Object)"1").build());
    private String clientId;
    private String clientSecret;
    private String userId;
    private String password;
    private String securityToken;
    private SalesforceRestWriter.Operation operation;
    private int batchSize;
    private Optional<String> batchResourcePath = Optional.absent();
    private boolean initializedFromConfig = false;

    @Override
    public SalesForceRestWriterBuilder fromConfig(Config config) {
        super.fromConfig(config);
        this.initializedFromConfig = true;
        config = config.withFallback((ConfigMergeable)FALLBACK);
        this.clientId = config.getString(CLIENT_ID);
        this.clientSecret = config.getString(CLIENT_SECRET);
        this.userId = config.getString(USER_ID);
        this.password = config.getString(PASSWORD);
        this.securityToken = config.getString(SECURITY_TOKEN);
        this.operation = SalesforceRestWriter.Operation.valueOf(config.getString(OPERATION).toUpperCase());
        this.batchSize = config.getInt(BATCH_SIZE);
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)("salesforce.batch_size cannot be negative: " + this.batchSize));
        if (this.batchSize > 1) {
            this.batchResourcePath = Optional.of((Object)config.getString(BATCH_RESOURCE_PATH));
        }
        if (config.hasPath(SFDC_ENCRYPT_KEY_LOC)) {
            Properties props = new Properties();
            if (config.hasPath(USE_STRONG_ENCRYPTION)) {
                props.put("encrypt.use.strong.encryptor", config.getString(USE_STRONG_ENCRYPTION));
            }
            props.put("encrypt.key.loc", config.getString(SFDC_ENCRYPT_KEY_LOC));
            this.password = PasswordManager.getInstance((Properties)props).readPassword(this.password);
        }
        return (SalesForceRestWriterBuilder)this.typedSelf();
    }

    public DataWriter<RestEntry<JsonObject>> build() throws IOException {
        this.validate();
        Preconditions.checkArgument((boolean)this.initializedFromConfig, (Object)(((Object)((Object)this)).getClass().getSimpleName() + " must be build via fromConfig method."));
        Preconditions.checkArgument((boolean)this.getSvcEndpoint().isPresent(), (Object)"Service end point is required for Oauth2 end point of Salesforce.com");
        return new SalesforceRestWriter(this);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public SalesforceRestWriter.Operation getOperation() {
        return this.operation;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Optional<String> getBatchResourcePath() {
        return this.batchResourcePath;
    }
}

