/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor;

import com.google.common.io.Closer;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.hadoop.HadoopFsHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJsonExtractor
implements Extractor<String, JsonObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleJsonExtractor.class);
    private final WorkUnitState workUnitState;
    private final FileSystem fs;
    private final BufferedReader bufferedReader;
    private final Closer closer = Closer.create();
    private static final Gson GSON = new Gson();

    public SimpleJsonExtractor(WorkUnitState workUnitState) throws IOException {
        this.workUnitState = workUnitState;
        HadoopFsHelper fsHelper = new HadoopFsHelper((State)workUnitState);
        try {
            fsHelper.connect();
        }
        catch (Exception e) {
            throw new IOException("Exception at SimpleJsonExtractor");
        }
        this.fs = fsHelper.getFileSystem();
        InputStreamReader isr = new InputStreamReader((InputStream)this.fs.open(new Path(workUnitState.getProp("source.filebased.files.to.pull"))), StandardCharsets.UTF_8);
        this.bufferedReader = (BufferedReader)this.closer.register((Closeable)new BufferedReader(isr));
    }

    public String getSchema() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)this.fs.open(new Path(this.workUnitState.getProp("source.schema"))), (OutputStream)outputStream, (int)4096, (boolean)false);
        String schema = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        this.workUnitState.setProp("converter.avroSchema", (Object)schema);
        return schema;
    }

    public JsonObject readRecord(@Deprecated JsonObject reuse) throws DataRecordException, IOException {
        String jsonString = this.bufferedReader.readLine();
        return (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
    }

    public long getExpectedRecordCount() {
        return 0L;
    }

    public long getHighWatermark() {
        return 0L;
    }

    public void close() throws IOException {
        try {
            this.closer.close();
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to close the input stream", (Throwable)ioe);
        }
        try {
            this.fs.close();
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to close the file object", (Throwable)ioe);
        }
    }
}

