/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.publisher;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.metadata.MetadataMerger;
import org.apache.gobblin.metadata.types.StaticStringMetadataMerger;
import org.apache.gobblin.metrics.event.lineage.LineageInfo;
import org.apache.gobblin.publisher.SingleTaskDataPublisher;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.ParallelRunner;
import org.apache.gobblin.util.WriterUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.gobblin.util.retry.RetryerFactory;
import org.apache.gobblin.writer.FsWriterMetrics;
import org.apache.gobblin.writer.PartitionIdentifier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDataPublisher
extends SingleTaskDataPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(BaseDataPublisher.class);
    protected final int numBranches;
    protected final List<FileSystem> writerFileSystemByBranches;
    protected final List<FileSystem> publisherFileSystemByBranches;
    protected final List<FileSystem> metaDataWriterFileSystemByBranches;
    protected final List<Optional<String>> publisherFinalDirOwnerGroupsByBranches;
    protected final List<FsPermission> permissions;
    protected final Closer closer;
    protected final Closer parallelRunnerCloser;
    protected final int parallelRunnerThreads;
    protected final Map<String, ParallelRunner> parallelRunners = Maps.newHashMap();
    protected final Set<Path> publisherOutputDirs = Sets.newHashSet();
    protected final Optional<LineageInfo> lineageInfo;
    protected final Map<PartitionIdentifier, MetadataMerger<String>> metadataMergers;
    protected final boolean shouldRetry;
    static final String DATA_PUBLISHER_RETRY_PREFIX = "data.publisher.retry.";
    static final String PUBLISH_RETRY_ENABLED = "data.publisher.retry.enabled";
    static final Config PUBLISH_RETRY_DEFAULTS;
    protected final Config retrierConfig;

    public BaseDataPublisher(State state) throws IOException {
        super(state);
        this.closer = Closer.create();
        Configuration conf = new Configuration();
        for (String key : this.getState().getPropertyNames()) {
            conf.set(key, this.getState().getProp(key));
        }
        this.lineageInfo = state instanceof SourceState ? LineageInfo.getLineageInfo((SharedResourcesBroker)((SourceState)state).getBroker()) : (state instanceof WorkUnitState ? LineageInfo.getLineageInfo((SharedResourcesBroker)((WorkUnitState)state).getTaskBrokerNullable()) : Optional.absent());
        this.numBranches = this.getState().getPropAsInt("fork.branches", 1);
        this.shouldRetry = this.getState().getPropAsBoolean(PUBLISH_RETRY_ENABLED, false);
        this.writerFileSystemByBranches = Lists.newArrayListWithCapacity((int)this.numBranches);
        this.publisherFileSystemByBranches = Lists.newArrayListWithCapacity((int)this.numBranches);
        this.metaDataWriterFileSystemByBranches = Lists.newArrayListWithCapacity((int)this.numBranches);
        this.publisherFinalDirOwnerGroupsByBranches = Lists.newArrayListWithCapacity((int)this.numBranches);
        this.permissions = Lists.newArrayListWithCapacity((int)this.numBranches);
        this.metadataMergers = new HashMap<PartitionIdentifier, MetadataMerger<String>>();
        for (int i = 0; i < this.numBranches; ++i) {
            URI writerUri = URI.create(this.getState().getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"writer.fs.uri", (int)this.numBranches, (int)i), "file:///"));
            this.writerFileSystemByBranches.add(FileSystem.get((URI)writerUri, (Configuration)conf));
            URI publisherUri = URI.create(this.getState().getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"data.publisher.fs.uri", (int)this.numBranches, (int)i), writerUri.toString()));
            this.publisherFileSystemByBranches.add(FileSystem.get((URI)publisherUri, (Configuration)conf));
            this.metaDataWriterFileSystemByBranches.add(FileSystem.get((URI)publisherUri, (Configuration)conf));
            this.publisherFinalDirOwnerGroupsByBranches.add((Optional<String>)Optional.fromNullable((Object)this.getState().getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"data.publisher.final.dir.group", (int)this.numBranches, (int)i))));
            this.permissions.add(new FsPermission(state.getPropAsShortWithRadix(ForkOperatorUtils.getPropertyNameForBranch((String)"data.publisher.permissions", (int)this.numBranches, (int)i), FsPermission.getDefault().toShort(), 8)));
        }
        if (this.shouldRetry) {
            this.retrierConfig = ConfigBuilder.create().loadProps(this.getState().getProperties(), DATA_PUBLISHER_RETRY_PREFIX).build().withFallback((ConfigMergeable)PUBLISH_RETRY_DEFAULTS);
            LOG.info("Retry enabled for publish with config : " + this.retrierConfig.root().render(ConfigRenderOptions.concise()));
        } else {
            LOG.info("Retry disabled for publish.");
            this.retrierConfig = WriterUtils.NO_RETRY_CONFIG;
        }
        this.parallelRunnerThreads = state.getPropAsInt("parallel.runner.threads", 10);
        this.parallelRunnerCloser = Closer.create();
    }

    private MetadataMerger<String> buildMetadataMergerForBranch(String metadataFromConfig, int branchId, Path existingMetadataPath) {
        if (!this.shouldPublishWriterMetadataForBranch(branchId)) {
            return new StaticStringMetadataMerger(metadataFromConfig);
        }
        String keyName = ForkOperatorUtils.getPropertyNameForBranch((String)"data.publisher.metadata.publish.writer.merger.class", (int)this.numBranches, (int)branchId);
        String className = this.getState().getProp(keyName, "org.apache.gobblin.metadata.types.GlobalMetadataJsonMerger");
        try {
            Class<?> mdClass = Class.forName(className);
            Object merger = GobblinConstructorUtils.invokeFirstConstructor(mdClass, (List[])new List[]{Collections.singletonList(this.getState().getProperties()), Collections.emptyList()});
            try {
                MetadataMerger casted = (MetadataMerger)merger;
                String existingMetadata = this.loadExistingMetadata(existingMetadataPath, branchId);
                if (existingMetadata != null) {
                    casted.update((Object)existingMetadata);
                }
                if (metadataFromConfig != null) {
                    casted.update((Object)metadataFromConfig);
                }
                return casted;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(className + " does not implement the MetadataMerger interface", e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Specified metadata merger class " + className + " not found!", e);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Error building merger class " + className, e);
        }
    }

    private String loadExistingMetadata(Path metadataFilename, int branchId) {
        try {
            FileSystem fsForBranch = this.writerFileSystemByBranches.get(branchId);
            if (!fsForBranch.exists(metadataFilename)) {
                return null;
            }
            FSDataInputStream existingMetadata = this.writerFileSystemByBranches.get(branchId).open(metadataFilename);
            return IOUtils.toString((InputStream)existingMetadata, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.warn("IOException {} while trying to read existing metadata {} - treating as null", (Object)e.getMessage(), (Object)metadataFilename.toString());
            return null;
        }
    }

    public void initialize() throws IOException {
    }

    public void close() throws IOException {
        try {
            for (Path path : this.publisherOutputDirs) {
                this.state.appendToSetProp("data.publisher.output.dirs", path.toString());
            }
        }
        finally {
            this.closer.close();
        }
    }

    private void addLineageInfo(WorkUnitState state, int branchId) {
        DatasetDescriptor destination = this.createDestinationDescriptor(state, branchId);
        if (this.lineageInfo.isPresent()) {
            ((LineageInfo)this.lineageInfo.get()).putDestination(destination, branchId, (State)state);
        }
    }

    protected DatasetDescriptor createDestinationDescriptor(WorkUnitState state, int branchId) {
        Path publisherOutputDir = this.getPublisherOutputDir(state, branchId);
        FileSystem fs = this.publisherFileSystemByBranches.get(branchId);
        DatasetDescriptor destination = new DatasetDescriptor(fs.getScheme(), publisherOutputDir.toString());
        destination.addMetadata("fsUri", fs.getUri().toString());
        destination.addMetadata("branch", String.valueOf(branchId));
        return destination;
    }

    public void publishData(WorkUnitState state) throws IOException {
        for (int branchId = 0; branchId < this.numBranches; ++branchId) {
            this.publishSingleTaskData(state, branchId);
        }
        this.parallelRunnerCloser.close();
    }

    private void publishSingleTaskData(WorkUnitState state, int branchId) throws IOException {
        this.publishData(state, branchId, true, new HashSet<Path>());
        this.addLineageInfo(state, branchId);
    }

    public void publishData(Collection<? extends WorkUnitState> states) throws IOException {
        HashSet writerOutputPathsMoved = Sets.newHashSet();
        for (WorkUnitState workUnitState : states) {
            for (int branchId = 0; branchId < this.numBranches; ++branchId) {
                this.publishMultiTaskData(workUnitState, branchId, writerOutputPathsMoved);
            }
        }
        this.parallelRunnerCloser.close();
        for (WorkUnitState workUnitState : states) {
            workUnitState.setWorkingState(WorkUnitState.WorkingState.COMMITTED);
        }
    }

    private void publishMultiTaskData(WorkUnitState state, int branchId, Set<Path> writerOutputPathsMoved) throws IOException {
        this.publishData(state, branchId, false, writerOutputPathsMoved);
        this.addLineageInfo(state, branchId);
    }

    protected void publishData(WorkUnitState state, int branchId, boolean publishSingleTaskData, Set<Path> writerOutputPathsMoved) throws IOException {
        ParallelRunner parallelRunner = this.getParallelRunner(this.writerFileSystemByBranches.get(branchId));
        Path writerOutputDir = WriterUtils.getWriterOutputDir((State)state, (int)this.numBranches, (int)branchId);
        if (!this.writerFileSystemByBranches.get(branchId).exists(writerOutputDir)) {
            LOG.warn(String.format("Branch %d of WorkUnit %s produced no data", branchId, state.getId()));
            return;
        }
        Path publisherOutputDir = this.getPublisherOutputDir(state, branchId);
        if (publishSingleTaskData) {
            WriterUtils.mkdirsWithRecursivePermissionWithRetry((FileSystem)this.publisherFileSystemByBranches.get(branchId), (Path)publisherOutputDir, (FsPermission)this.permissions.get(branchId), (Config)this.retrierConfig);
            this.addSingleTaskWriterOutputToExistingDir(writerOutputDir, publisherOutputDir, state, branchId, parallelRunner);
        } else {
            if (writerOutputPathsMoved.contains(writerOutputDir)) {
                return;
            }
            if (this.publisherFileSystemByBranches.get(branchId).exists(publisherOutputDir)) {
                boolean replaceFinalOutputDir = this.getState().getPropAsBoolean(ForkOperatorUtils.getPropertyNameForBranch((String)"data.publisher.replace.final.dir", (int)this.numBranches, (int)branchId));
                if (!replaceFinalOutputDir) {
                    this.addWriterOutputToExistingDir(writerOutputDir, publisherOutputDir, state, branchId, parallelRunner);
                    writerOutputPathsMoved.add(writerOutputDir);
                    return;
                }
                LOG.info("Deleting publisher output dir " + publisherOutputDir);
                this.publisherFileSystemByBranches.get(branchId).delete(publisherOutputDir, true);
            } else {
                WriterUtils.mkdirsWithRecursivePermissionWithRetry((FileSystem)this.publisherFileSystemByBranches.get(branchId), (Path)publisherOutputDir.getParent(), (FsPermission)this.permissions.get(branchId), (Config)this.retrierConfig);
            }
            this.movePath(parallelRunner, (State)state, writerOutputDir, publisherOutputDir, branchId);
            writerOutputPathsMoved.add(writerOutputDir);
        }
    }

    protected Path getPublisherOutputDir(WorkUnitState workUnitState, int branchId) {
        return WriterUtils.getDataPublisherFinalDir((State)workUnitState, (int)this.numBranches, (int)branchId);
    }

    protected void addSingleTaskWriterOutputToExistingDir(Path writerOutputDir, Path publisherOutputDir, WorkUnitState workUnitState, int branchId, ParallelRunner parallelRunner) throws IOException {
        String outputFilePropName = ForkOperatorUtils.getPropertyNameForBranch((String)"writer.final.output.file.paths", (int)this.numBranches, (int)branchId);
        if (!workUnitState.contains(outputFilePropName)) {
            LOG.warn("Missing property " + outputFilePropName + ". This task may have pulled no data.");
            return;
        }
        Set taskOutputFiles = workUnitState.getPropAsSet(outputFilePropName);
        for (String taskOutputFile : taskOutputFiles) {
            Path taskOutputPath = new Path(taskOutputFile);
            if (!this.writerFileSystemByBranches.get(branchId).exists(taskOutputPath)) {
                LOG.warn("Task output file " + taskOutputFile + " doesn't exist.");
                continue;
            }
            String pathSuffix = taskOutputFile.substring(taskOutputFile.indexOf(writerOutputDir.toString()) + writerOutputDir.toString().length() + 1);
            Path publisherOutputPath = new Path(publisherOutputDir, pathSuffix);
            WriterUtils.mkdirsWithRecursivePermissionWithRetry((FileSystem)this.publisherFileSystemByBranches.get(branchId), (Path)publisherOutputPath.getParent(), (FsPermission)this.permissions.get(branchId), (Config)this.retrierConfig);
            this.movePath(parallelRunner, (State)workUnitState, taskOutputPath, publisherOutputPath, branchId);
        }
    }

    protected void addWriterOutputToExistingDir(Path writerOutputDir, Path publisherOutputDir, WorkUnitState workUnitState, int branchId, ParallelRunner parallelRunner) throws IOException {
        boolean preserveFileName = workUnitState.getPropAsBoolean(ForkOperatorUtils.getPropertyNameForBranch((String)"source.filebased.preserve.file.name", (int)this.numBranches, (int)branchId), false);
        for (FileStatus status : this.writerFileSystemByBranches.get(branchId).listStatus(writerOutputDir)) {
            Path finalOutputPath = preserveFileName ? new Path(publisherOutputDir, workUnitState.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"data.publisher.final.name", (int)this.numBranches, (int)branchId))) : new Path(publisherOutputDir, status.getPath().getName());
            this.movePath(parallelRunner, (State)workUnitState, status.getPath(), finalOutputPath, branchId);
        }
    }

    protected void movePath(ParallelRunner parallelRunner, State state, Path src, Path dst, int branchId) throws IOException {
        LOG.info(String.format("Moving %s to %s", src, dst));
        boolean overwrite = state.getPropAsBoolean("data.publisher.overwrite.enabled", false);
        this.publisherOutputDirs.addAll(this.recordPublisherOutputDirs(src, dst, branchId));
        parallelRunner.movePath(src, this.publisherFileSystemByBranches.get(branchId), dst, overwrite, this.publisherFinalDirOwnerGroupsByBranches.get(branchId));
    }

    protected Collection<Path> recordPublisherOutputDirs(Path src, Path dst, int branchId) throws IOException {
        if (this.writerFileSystemByBranches.get(branchId).getFileStatus(src).isDirectory()) {
            return ImmutableList.of((Object)dst);
        }
        return ImmutableList.of((Object)dst.getParent());
    }

    private ParallelRunner getParallelRunner(FileSystem fs) {
        String uri = fs.getUri().toString();
        if (!this.parallelRunners.containsKey(uri)) {
            this.parallelRunners.put(uri, (ParallelRunner)this.parallelRunnerCloser.register((Closeable)new ParallelRunner(this.parallelRunnerThreads, fs)));
        }
        return this.parallelRunners.get(uri);
    }

    public void publishMetadata(Collection<? extends WorkUnitState> states) throws IOException {
        HashSet<String> partitions = new HashSet<String>();
        this.mergeMetadataAndCollectPartitionNames(states, partitions);
        partitions.removeIf(Objects::isNull);
        WorkUnitState anyState = states.iterator().next();
        for (int branchId = 0; branchId < this.numBranches; ++branchId) {
            String mdOutputPath = this.getMetadataOutputPathFromState(anyState, branchId);
            String userSpecifiedPath = this.getUserSpecifiedOutputPathFromState(anyState, branchId);
            if (partitions.isEmpty() || userSpecifiedPath != null) {
                this.publishMetadata(this.getMergedMetadataForPartitionAndBranch(null, branchId), branchId, this.getMetadataOutputFileForBranch(anyState, branchId));
                continue;
            }
            String metadataFilename = this.getMetadataFileNameForBranch(anyState, branchId);
            if (mdOutputPath == null || metadataFilename == null) {
                LOG.info("Metadata filename not set for branch " + String.valueOf(branchId) + ": not publishing metadata.");
                continue;
            }
            for (String partition : partitions) {
                this.publishMetadata(this.getMergedMetadataForPartitionAndBranch(partition, branchId), branchId, new Path(new Path(mdOutputPath, partition), metadataFilename));
            }
        }
    }

    private void mergeMetadataAndCollectPartitionNames(Collection<? extends WorkUnitState> states, Set<String> partitionPaths) {
        for (WorkUnitState workUnitState : states) {
            HashMap metricsByPartition = new HashMap();
            boolean partitionFound = false;
            for (Map.Entry<Object, Object> property : workUnitState.getProperties().entrySet()) {
                if (((String)property.getKey()).startsWith("writer._internal.partition.path")) {
                    partitionPaths.add((String)property.getValue());
                    partitionFound = true;
                    continue;
                }
                if (!((String)property.getKey()).startsWith("fs_writer_metrics")) continue;
                try {
                    FsWriterMetrics parsedMetrics = FsWriterMetrics.fromJson((String)((String)property.getValue()));
                    partitionPaths.add(parsedMetrics.getPartitionInfo().getPartitionKey());
                    Set metricsForPartition = metricsByPartition.computeIfAbsent(parsedMetrics.getPartitionInfo(), k -> new HashSet());
                    metricsForPartition.add(parsedMetrics);
                }
                catch (IOException e) {
                    LOG.warn("Error parsing metrics from property {} - ignoring", (Object)((String)property.getValue()));
                }
            }
            if (!partitionFound) {
                partitionPaths.add(null);
            }
            String configBasedMetadata = this.getMetadataFromWorkUnitState(workUnitState);
            for (int branchId = 0; branchId < this.numBranches; ++branchId) {
                for (String partition : partitionPaths) {
                    PartitionIdentifier partitionIdentifier = new PartitionIdentifier(partition, branchId);
                    int branch = branchId;
                    MetadataMerger mdMerger = this.metadataMergers.computeIfAbsent(partitionIdentifier, k -> this.buildMetadataMergerForBranch(configBasedMetadata, branch, this.getMetadataOutputFileForBranch(workUnitState, branch)));
                    if (!this.shouldPublishWriterMetadataForBranch(branchId)) continue;
                    String md = this.getIntermediateMetadataFromState(workUnitState, branchId);
                    mdMerger.update((Object)md);
                    Set metricsForPartition = metricsByPartition.getOrDefault(partitionIdentifier, Collections.emptySet());
                    for (FsWriterMetrics metrics : metricsForPartition) {
                        mdMerger.update(metrics);
                    }
                }
            }
        }
    }

    public void publishMetadata(WorkUnitState state) throws IOException {
        this.publishMetadata(Collections.singleton(state));
    }

    private void publishMetadata(String metadataValue, int branchId, Path metadataOutputPath) throws IOException {
        try {
            if (metadataOutputPath == null) {
                LOG.info("Metadata output path not set for branch " + String.valueOf(branchId) + ", not publishing.");
                return;
            }
            if (metadataValue == null) {
                LOG.info("No metadata collected for branch " + String.valueOf(branchId) + ", not publishing.");
                return;
            }
            FileSystem fs = this.metaDataWriterFileSystemByBranches.get(branchId);
            if (!fs.exists(metadataOutputPath.getParent())) {
                WriterUtils.mkdirsWithRecursivePermissionWithRetry((FileSystem)fs, (Path)metadataOutputPath, (FsPermission)this.permissions.get(branchId), (Config)this.retrierConfig);
            }
            if (fs.exists(metadataOutputPath)) {
                HadoopUtils.deletePath((FileSystem)fs, (Path)metadataOutputPath, (boolean)false);
            }
            LOG.info("Writing metadata for branch " + String.valueOf(branchId) + " to " + metadataOutputPath.toString());
            try (FSDataOutputStream outputStream = fs.create(metadataOutputPath);){
                outputStream.write(metadataValue.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            LOG.error("Metadata file is not generated: " + e, (Throwable)e);
        }
    }

    private String getMetadataFileNameForBranch(WorkUnitState state, int branchId) {
        String filePrefix = state.getProp("data.publisher.metadata.output_file");
        return ForkOperatorUtils.getPropertyNameForBranch((String)filePrefix, (int)this.numBranches, (int)branchId);
    }

    private Path getMetadataOutputFileForBranch(WorkUnitState state, int branchId) {
        String metaDataOutputDirStr = this.getMetadataOutputPathFromState(state, branchId);
        String fileName = this.getMetadataFileNameForBranch(state, branchId);
        if (metaDataOutputDirStr == null || fileName == null) {
            return null;
        }
        return new Path(metaDataOutputDirStr, fileName);
    }

    private String getUserSpecifiedOutputPathFromState(WorkUnitState state, int branchId) {
        String outputDir = state.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"data.publisher.metadata.output.dir", (int)this.numBranches, (int)branchId));
        if (outputDir == null && this.numBranches > 1 && (outputDir = state.getProp("data.publisher.metadata.output.dir")) != null) {
            LOG.warn("Branches are configured for this job but a per branch metadata output directory was not set; is this intended?");
        }
        return outputDir;
    }

    private String getMetadataOutputPathFromState(WorkUnitState state, int branchId) {
        String outputDir = this.getUserSpecifiedOutputPathFromState(state, branchId);
        if (outputDir == null) {
            String publisherOutputDir = this.getPublisherOutputDir(state, branchId).toString();
            LOG.info("Missing metadata output directory path : data.publisher.metadata.output.dir in the config; assuming outputPath " + publisherOutputDir);
            return publisherOutputDir;
        }
        return outputDir;
    }

    private String getIntermediateMetadataFromState(WorkUnitState state, int branchId) {
        return state.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"writer._internal.metadata", (int)this.numBranches, (int)branchId));
    }

    private String getMergedMetadataForPartitionAndBranch(String partitionId, int branchId) {
        String mergedMd = null;
        MetadataMerger<String> mergerForBranch = this.metadataMergers.get(new PartitionIdentifier(partitionId, branchId));
        if (mergerForBranch != null && (mergedMd = (String)mergerForBranch.getMergedMetadata()) == null) {
            LOG.warn("Metadata merger for branch {} returned null - bug in merger?", (Object)branchId);
        }
        return mergedMd;
    }

    private boolean shouldPublishWriterMetadataForBranch(int branchId) {
        String keyName = ForkOperatorUtils.getPropertyNameForBranch((String)"data.publisher.metadata.publish.writer", (int)this.numBranches, (int)branchId);
        return this.getState().getPropAsBoolean(keyName, false);
    }

    private String getMetadataFromWorkUnitState(WorkUnitState workUnitState) {
        return workUnitState.getProp("data.publisher.metadata.string");
    }

    protected boolean shouldPublishMetadataFirst() {
        return false;
    }

    static {
        ImmutableMap configMap = ImmutableMap.builder().put((Object)"time_out_ms", (Object)TimeUnit.MINUTES.toMillis(2L)).put((Object)"interval_ms", (Object)TimeUnit.SECONDS.toMillis(5L)).put((Object)"multiplier", (Object)2L).put((Object)"retry_type", (Object)RetryerFactory.RetryType.EXPONENTIAL.name()).build();
        PUBLISH_RETRY_DEFAULTS = ConfigFactory.parseMap((Map)configMap);
    }
}

