/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;

public class AvroToBytesConverter
extends Converter<Schema, String, GenericRecord, byte[]> {
    private GenericDatumWriter<GenericRecord> writer;
    private ThreadLocal<BinaryEncoder> encoderCache = new ThreadLocal<BinaryEncoder>(){

        @Override
        protected BinaryEncoder initialValue() {
            return null;
        }
    };

    public String convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        this.writer = new GenericDatumWriter(inputSchema);
        return inputSchema.toString();
    }

    public Iterable<byte[]> convertRecord(String outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)bytesOut, this.encoderCache.get());
            this.encoderCache.set(encoder);
            this.writer.write((Object)inputRecord, (Encoder)encoder);
            encoder.flush();
            return Collections.singleton(bytesOut.toByteArray());
        }
        catch (IOException e) {
            throw new DataConversionException("Error serializing record", (Throwable)e);
        }
    }
}

