/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.jersey.api.uri.UriTemplate;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.ResourceProperties;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.internal.client.RestResponseDecoder;
import com.linkedin.restli.internal.common.ResourcePropertiesImpl;
import com.linkedin.restli.internal.common.URIParamUtils;
import java.net.HttpCookie;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Request<T> {
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private final ResourceMethod _method;
    private final RecordTemplate _inputRecord;
    private final RestResponseDecoder<T> _decoder;
    private final Map<String, String> _headers;
    private final List<HttpCookie> _cookies;
    private final ResourceSpec _resourceSpec;
    private final ResourceProperties _resourceProperties;
    private final Map<String, Object> _queryParams;
    private final Map<String, Class<?>> _queryParamClasses;
    private final String _methodName;
    private final String _baseUriTemplate;
    private final Map<String, Object> _pathKeys;
    private final RestliRequestOptions _requestOptions;
    private final List<Object> _streamingAttachments;

    Request(ResourceMethod method, RecordTemplate inputRecord, Map<String, String> headers, List<HttpCookie> cookies, RestResponseDecoder<T> decoder, ResourceSpec resourceSpec, Map<String, Object> queryParams, Map<String, Class<?>> queryParamClasses, String methodName, String baseUriTemplate, Map<String, Object> pathKeys, RestliRequestOptions requestOptions, List<Object> streamingAttachments) {
        this._method = method;
        this._inputRecord = inputRecord;
        this._decoder = decoder;
        this._headers = headers;
        this._cookies = cookies;
        this._resourceSpec = resourceSpec;
        this._resourceProperties = resourceSpec != null ? new ResourcePropertiesImpl(resourceSpec.getSupportedMethods(), resourceSpec.getKeyType(), resourceSpec.getComplexKeyType(), resourceSpec.getValueType(), resourceSpec.getKeyParts()) : null;
        this._queryParams = queryParams;
        this._queryParamClasses = queryParamClasses;
        this._methodName = methodName;
        this._baseUriTemplate = baseUriTemplate;
        this._pathKeys = pathKeys;
        if (this._baseUriTemplate != null && this._pathKeys != null) {
            this.validatePathKeys();
        }
        this._requestOptions = requestOptions == null ? RestliRequestOptions.DEFAULT_OPTIONS : requestOptions;
        this._streamingAttachments = streamingAttachments;
    }

    protected void validateKeyPresence(Object key) {
        if (this.getResourceProperties().isKeylessResource()) {
            if (key != null) {
                throw new IllegalArgumentException("id is not allowed in this key-less resource request");
            }
        } else if (key == null) {
            throw new IllegalArgumentException("id required to build this request");
        }
    }

    private void validatePathKeys() {
        UriTemplate template = new UriTemplate(this.getBaseUriTemplate());
        for (String key : template.getTemplateVariables()) {
            Object value = this.getPathKeys().get(key);
            if (value != null) continue;
            throw new IllegalStateException("Missing path key: " + key);
        }
    }

    public String getMethodName() {
        return this._methodName;
    }

    public ResourceMethod getMethod() {
        return this._method;
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public List<HttpCookie> getCookies() {
        return this._cookies;
    }

    public RecordTemplate getInputRecord() {
        return this._inputRecord;
    }

    public RestResponseDecoder<T> getResponseDecoder() {
        return this._decoder;
    }

    @Deprecated
    public ResourceSpec getResourceSpec() {
        return this._resourceSpec;
    }

    public ResourceProperties getResourceProperties() {
        return this._resourceProperties;
    }

    public String getBaseUriTemplate() {
        return this._baseUriTemplate;
    }

    public Map<String, Object> getPathKeys() {
        return this._pathKeys;
    }

    public boolean isSafe() {
        return this._method.getHttpMethod().isSafe();
    }

    public boolean isIdempotent() {
        return this._method.getHttpMethod().isIdempotent();
    }

    public Map<String, Object> getQueryParamsObjects() {
        return this._queryParams;
    }

    public Map<String, Class<?>> getQueryParamClasses() {
        return this._queryParamClasses;
    }

    public RestliRequestOptions getRequestOptions() {
        return this._requestOptions;
    }

    List<Object> getStreamingAttachments() {
        return this._streamingAttachments;
    }

    protected Set<PathSpec> getFields() {
        List fieldsList = (List)this._queryParams.get("fields");
        if (fieldsList == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet(fieldsList));
    }

    String getServiceName() {
        if (this._baseUriTemplate != null) {
            return URIParamUtils.extractPathComponentsFromUriTemplate((String)this._baseUriTemplate)[0];
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.areNewFieldsEqual((Request)obj);
    }

    private boolean areOldFieldsEqual(Request<?> other) {
        if (this._headers != null ? !this._headers.equals(other._headers) : other._headers != null) {
            return false;
        }
        if (this._inputRecord != null ? !this._inputRecord.equals((Object)other._inputRecord) : other._inputRecord != null) {
            return false;
        }
        return this._method == other._method;
    }

    private boolean areNewFieldsEqual(Request<?> other) {
        if (!this.areOldFieldsEqual(other)) {
            return false;
        }
        if (this._baseUriTemplate != null ? !this._baseUriTemplate.equals(other._baseUriTemplate) : other._baseUriTemplate != null) {
            return false;
        }
        if (this._pathKeys != null ? !this._pathKeys.equals(other._pathKeys) : other._pathKeys != null) {
            return false;
        }
        if (this._resourceSpec != null ? !this._resourceSpec.equals(other._resourceSpec) : other._resourceSpec != null) {
            return false;
        }
        if (this._queryParams != null ? !this._queryParams.equals(other._queryParams) : other._queryParams != null) {
            return false;
        }
        if (this._methodName != null ? !this._methodName.equals(other._methodName) : other._methodName != null) {
            return false;
        }
        if (this._requestOptions != null ? !this._requestOptions.equals(other._requestOptions) : other._requestOptions != null) {
            return false;
        }
        if (this._streamingAttachments != null ? !this._streamingAttachments.equals(other._streamingAttachments) : other._streamingAttachments != null) {
            return false;
        }
        return !(this._cookies != null ? !this._cookies.equals(other._cookies) : other._cookies != null);
    }

    public int hashCode() {
        int hashCode = this._method.hashCode();
        hashCode = 31 * hashCode + (this._inputRecord != null ? this._inputRecord.hashCode() : 0);
        hashCode = 31 * hashCode + (this._headers != null ? this._headers.hashCode() : 0);
        hashCode = 31 * hashCode + (this._baseUriTemplate != null ? this._baseUriTemplate.hashCode() : 0);
        hashCode = 31 * hashCode + (this._pathKeys != null ? this._pathKeys.hashCode() : 0);
        hashCode = 31 * hashCode + (this._resourceSpec != null ? this._resourceSpec.hashCode() : 0);
        hashCode = 31 * hashCode + (this._queryParams != null ? this._queryParams.hashCode() : 0);
        hashCode = 31 * hashCode + (this._methodName != null ? this._methodName.hashCode() : 0);
        hashCode = 31 * hashCode + (this._requestOptions != null ? this._requestOptions.hashCode() : 0);
        hashCode = 31 * hashCode + (this._streamingAttachments != null ? this._streamingAttachments.hashCode() : 0);
        hashCode = 31 * hashCode + (this._cookies != null ? this._cookies.hashCode() : 0);
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{_headers=").append(this._headers);
        sb.append(", _input=").append(this._inputRecord);
        sb.append(", _method=").append(this._method);
        sb.append(", _baseUriTemplate=").append(this._baseUriTemplate);
        sb.append(", _methodName=").append(this._methodName);
        sb.append(", _pathKeys=").append(this._pathKeys);
        sb.append(", _queryParams=").append(this._queryParams);
        sb.append(", _requestOptions=").append(this._requestOptions);
        sb.append(", _cookies=").append(this._cookies);
        if (this._streamingAttachments != null) {
            sb.append(", _streamingDataSources=");
            sb.append("(size=").append(this._streamingAttachments.size()).append(")");
        }
        sb.append('}');
        return sb.toString();
    }

    public String toSecureString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{_method=").append(this._method);
        sb.append(", _baseUriTemplate=").append(this._baseUriTemplate);
        sb.append(", _methodName=").append(this._methodName);
        sb.append(", _requestOptions=").append(this._requestOptions);
        sb.append('}');
        return sb.toString();
    }
}

