/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.request_allocation.BruteForceAllocator;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.RequestAllocator;
import org.apache.gobblin.util.request_allocation.RequestAllocatorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAllocatorUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestAllocatorUtils.class);
    public static final String ALLOCATOR_ALIAS_KEY = "requestAllocatorAlias";

    public static <T extends Request<T>> RequestAllocator<T> inferFromConfig(RequestAllocatorConfig<T> configuration) {
        try {
            String alias = configuration.getLimitedScopeConfig().hasPath(ALLOCATOR_ALIAS_KEY) ? configuration.getLimitedScopeConfig().getString(ALLOCATOR_ALIAS_KEY) : BruteForceAllocator.Factory.class.getName();
            RequestAllocator.Factory allocatorFactory = (RequestAllocator.Factory)new ClassAliasResolver(RequestAllocator.Factory.class).resolveClass(alias).newInstance();
            log.info("Using allocator factory " + allocatorFactory.getClass().getName());
            return allocatorFactory.createRequestAllocator(configuration);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

