/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Splitter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.password.PasswordManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailUtils.class);

    public static void sendEmail(State state, String subject, String message) throws EmailException {
        String hostName;
        SimpleEmail email = new SimpleEmail();
        email.setHostName(state.getProp("email.host", "localhost"));
        if (state.contains("email.smtp.port")) {
            email.setSmtpPort(state.getPropAsInt("email.smtp.port"));
        }
        email.setFrom(state.getProp("email.from"));
        if (state.contains("email.user") && state.contains("email.password")) {
            email.setAuthentication(state.getProp("email.user"), PasswordManager.getInstance((State)state).readPassword(state.getProp("email.password")));
        }
        Iterable tos = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)state.getProp("email.tos"));
        for (String to : tos) {
            email.addTo(to);
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            LOGGER.error("Failed to get the host name", (Throwable)uhe);
            hostName = "unknown";
        }
        email.setSubject(subject);
        String fromHostLine = String.format("This email was sent from host: %s%n%n", hostName);
        email.setMsg(fromHostLine + message);
        email.send();
    }

    public static void sendJobCompletionEmail(String jobId, String message, String state, State jobState) throws EmailException {
        EmailUtils.sendEmail(jobState, String.format("Gobblin notification: job %s has completed with state %s", jobId, state), message);
    }

    public static void sendJobCancellationEmail(String jobId, String message, State jobState) throws EmailException {
        EmailUtils.sendEmail(jobState, String.format("Gobblin notification: job %s has been cancelled", jobId), message);
    }

    public static void sendJobFailureAlertEmail(String jobName, String message, int failures, State jobState) throws EmailException {
        EmailUtils.sendEmail(jobState, String.format("Gobblin alert: job %s has failed %d %s consecutively in the past", jobName, failures, failures > 1 ? "times" : "time"), message);
    }
}

