/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzkabanTags {
    private static final Logger log = LoggerFactory.getLogger(AzkabanTags.class);
    public static final ImmutableMap<String, String> PROPERTIES_TO_TAGS_MAP = new ImmutableMap.Builder().put((Object)"azkaban.flow.projectname", (Object)"azkabanProjectName").put((Object)"azkaban.flow.flowid", (Object)"azkabanFlowId").put((Object)"azkaban.job.id", (Object)"azkabanJobId").put((Object)"azkaban.flow.execid", (Object)"azkabanExecId").put((Object)"azkaban.link.execution.url", (Object)"azkabanURL").put((Object)"azkaban.link.workflow.url", (Object)"azkabanFlowURL").put((Object)"azkaban.link.job.url", (Object)"azkabanJobURL").put((Object)"azkaban.link.jobexec.url", (Object)"azkabanJobExecURL").build();

    public static Map<String, String> getAzkabanTags() {
        return AzkabanTags.getAzkabanTags(new Configuration());
    }

    public static Map<String, String> getAzkabanTags(Configuration conf) {
        HashMap tagMap = Maps.newHashMap();
        for (Map.Entry entry : PROPERTIES_TO_TAGS_MAP.entrySet()) {
            if (StringUtils.isNotBlank((String)conf.get((String)entry.getKey()))) {
                tagMap.put(entry.getValue(), conf.get((String)entry.getKey()));
                continue;
            }
            log.warn(String.format("No config value found for config %s. Metrics will not have tag %s", entry.getKey(), entry.getValue()));
        }
        return tagMap;
    }
}

