/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.restli.common.ErrorResponse;
import com.linkedin.restli.common.HttpStatus;

public class EntityResponse<E extends RecordTemplate>
extends RecordTemplate {
    public static final String ENTITY = "entity";
    public static final String STATUS = "status";
    public static final String ERROR = "error";
    private static final RecordDataSchema.Field _entityField;
    private static final RecordDataSchema.Field _statusField;
    private static final RecordDataSchema.Field _errorField;
    private final Class<E> _entityClass;

    public EntityResponse(Class<E> entityClass) {
        this(new DataMap(), entityClass);
    }

    public EntityResponse(DataMap map, Class<E> entityClass) {
        super(map, null);
        this._entityClass = entityClass;
    }

    public Class<E> getEntityClass() {
        return this._entityClass;
    }

    public boolean hasEntry() {
        return this.contains(_entityField);
    }

    public E getEntity(GetMode mode) {
        return (E)((RecordTemplate)this.obtainWrapped(_entityField, this._entityClass, mode));
    }

    public E getEntity() {
        return this.getEntity(GetMode.STRICT);
    }

    public boolean hasStatus() {
        return this.contains(_statusField);
    }

    public HttpStatus getStatus(GetMode mode) {
        Integer statusNumber = (Integer)this.obtainDirect(_statusField, Integer.class, mode);
        if (statusNumber == null) {
            return null;
        }
        return HttpStatus.fromCode(statusNumber);
    }

    public HttpStatus getStatus() {
        return this.getStatus(GetMode.STRICT);
    }

    @Deprecated
    public boolean hasErorr() {
        return this.hasError();
    }

    public boolean hasError() {
        return this.contains(_errorField);
    }

    public ErrorResponse getError(GetMode mode) {
        return (ErrorResponse)this.obtainWrapped(_errorField, ErrorResponse.class, mode);
    }

    public ErrorResponse getError() {
        return this.getError(GetMode.STRICT);
    }

    public EntityResponse<E> setEntity(E entity, SetMode mode) {
        this.putWrapped(_entityField, this._entityClass, (DataTemplate)entity, mode);
        return this;
    }

    public EntityResponse<E> setEntity(E entity) {
        return this.setEntity(entity, SetMode.DISALLOW_NULL);
    }

    public EntityResponse<E> setStatus(HttpStatus status, SetMode mode) {
        Integer statusCode = status == null ? null : Integer.valueOf(status.getCode());
        this.putDirect(_statusField, Integer.class, statusCode, mode);
        return this;
    }

    public EntityResponse<E> setStatus(HttpStatus status) {
        return this.setStatus(status, SetMode.DISALLOW_NULL);
    }

    public EntityResponse<E> setError(ErrorResponse error, SetMode mode) {
        this.putWrapped(_errorField, ErrorResponse.class, (DataTemplate)error, mode);
        return this;
    }

    public EntityResponse<E> setError(ErrorResponse error) {
        return this.setError(error, SetMode.DISALLOW_NULL);
    }

    static {
        StringBuilder errorBuilder = new StringBuilder();
        _entityField = new RecordDataSchema.Field((DataSchema)new RecordDataSchema(new Name(ENTITY), RecordDataSchema.RecordType.RECORD));
        _entityField.setName(ENTITY, errorBuilder);
        _entityField.setOptional(true);
        _statusField = new RecordDataSchema.Field((DataSchema)new RecordDataSchema(new Name(STATUS), RecordDataSchema.RecordType.RECORD));
        _statusField.setName(STATUS, errorBuilder);
        _statusField.setOptional(true);
        _errorField = new RecordDataSchema.Field((DataSchema)new RecordDataSchema(new Name(ERROR), RecordDataSchema.RecordType.RECORD));
        _errorField.setName(ERROR, errorBuilder);
        _errorField.setOptional(true);
    }
}

