/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.util.io.Streams;

public final class GPGFileDecryptor {
    public static InputStream decryptFile(InputStream inputStream, String passPhrase) throws IOException {
        PGPEncryptedDataList enc = GPGFileDecryptor.getPGPEncryptedDataList(inputStream);
        PGPPBEEncryptedData pbe = (PGPPBEEncryptedData)enc.get(0);
        try {
            InputStream clear = pbe.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(passPhrase.toCharArray()));
            JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(clear);
            Object pgpfObject = pgpFact.nextObject();
            if (pgpfObject instanceof PGPCompressedData) {
                PGPCompressedData cData = (PGPCompressedData)pgpfObject;
                pgpFact = new JcaPGPObjectFactory(cData.getDataStream());
                pgpfObject = pgpFact.nextObject();
            }
            PGPLiteralData ld = (PGPLiteralData)pgpfObject;
            return ld.getInputStream();
        }
        catch (PGPException e) {
            throw new IOException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static InputStream decryptFile(InputStream inputStream, InputStream keyIn, String passPhrase) throws IOException {
        PGPEncryptedDataList enc = GPGFileDecryptor.getPGPEncryptedDataList(inputStream);
        Iterator it = enc.getEncryptedDataObjects();
        PGPPrivateKey sKey = null;
        PGPPublicKeyEncryptedData pbe = null;
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        while (sKey == null && it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            sKey = GPGFileDecryptor.findSecretKey(pgpSec, pbe.getKeyID(), passPhrase);
        }
        if (sKey == null) {
            throw new IllegalArgumentException("secret key for message not found.");
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            try (InputStream clear = pbe.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(sKey));){
                JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(clear);
                Object pgpfObject = pgpFact.nextObject();
                while (pgpfObject != null) {
                    if (pgpfObject instanceof PGPCompressedData) {
                        PGPCompressedData cData = (PGPCompressedData)pgpfObject;
                        pgpFact = new JcaPGPObjectFactory(cData.getDataStream());
                        pgpfObject = pgpFact.nextObject();
                    }
                    if (!(pgpfObject instanceof PGPLiteralData)) {
                        if (pgpfObject instanceof PGPOnePassSignatureList) {
                            throw new PGPException("encrypted message contains PGPOnePassSignatureList message - not literal data.");
                        }
                        if (pgpfObject instanceof PGPSignatureList) {
                            throw new PGPException("encrypted message contains PGPSignatureList message - not literal data.");
                        }
                        throw new PGPException("message is not a simple encrypted file - type unknown.");
                    }
                    Streams.pipeAll((InputStream)((PGPLiteralData)pgpfObject).getInputStream(), (OutputStream)outputStream);
                    pgpfObject = pgpFact.nextObject();
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
                return byteArrayInputStream;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pgpSec, long keyID, String passPhrase) throws PGPException {
        PGPSecretKey pgpSecKey = pgpSec.getSecretKey(keyID);
        if (pgpSecKey == null) {
            return null;
        }
        return pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(passPhrase.toCharArray()));
    }

    private static PGPEncryptedDataList getPGPEncryptedDataList(InputStream inputStream) throws IOException {
        JcaPGPObjectFactory pgpF;
        Object pgpfObject;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        PGPEncryptedDataList enc = (pgpfObject = (pgpF = new JcaPGPObjectFactory(inputStream = PGPUtil.getDecoderStream((InputStream)inputStream))).nextObject()) instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)pgpfObject : (PGPEncryptedDataList)pgpF.nextObject();
        return enc;
    }

    private GPGFileDecryptor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

