/*
 * Decompiled with CFR 0.152.
 */
package azkaban.migration.sla;

import azkaban.migration.scheduler.Schedule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;

@Deprecated
public class SLA {
    private int execId;
    private String jobName;
    private DateTime checkTime;
    private List<String> emails;
    private List<SlaAction> actions;
    private List<SlaSetting> jobSettings;
    private SlaRule rule;

    public SLA(int execId, String jobName, DateTime checkTime, List<String> emails, List<SlaAction> slaActions, List<SlaSetting> jobSettings, SlaRule slaRule) {
        this.execId = execId;
        this.jobName = jobName;
        this.checkTime = checkTime;
        this.emails = emails;
        this.actions = slaActions;
        this.jobSettings = jobSettings;
        this.rule = slaRule;
    }

    public int getExecId() {
        return this.execId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public DateTime getCheckTime() {
        return this.checkTime;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public List<SlaAction> getActions() {
        return this.actions;
    }

    public List<SlaSetting> getJobSettings() {
        return this.jobSettings;
    }

    public SlaRule getRule() {
        return this.rule;
    }

    public String toString() {
        return this.execId + " " + this.jobName + " to be checked at " + this.checkTime.toDateTimeISO();
    }

    public Map<String, Object> optionToObject() {
        HashMap<String, Object> slaObj = new HashMap<String, Object>();
        slaObj.put("emails", this.emails);
        ArrayList<String> actionsObj = new ArrayList<String>();
        for (SlaAction act : this.actions) {
            actionsObj.add(act.toString());
        }
        slaObj.put("actions", actionsObj);
        if (this.jobSettings != null && this.jobSettings.size() > 0) {
            ArrayList<Object> settingsObj = new ArrayList<Object>();
            for (SlaSetting set : this.jobSettings) {
                settingsObj.add(set.toObject());
            }
            slaObj.put("jobSettings", settingsObj);
        }
        return slaObj;
    }

    public static SLA createSlaFromObject(int execId, String jobName, DateTime checkTime, SlaRule rule, Object obj) {
        HashMap slaObj = (HashMap)obj;
        List emails = (List)slaObj.get("emails");
        ArrayList actsObj = (ArrayList)slaObj.get("actions");
        ArrayList<SlaAction> slaActs = new ArrayList<SlaAction>();
        for (String act : actsObj) {
            slaActs.add(SlaAction.valueOf(act));
        }
        ArrayList<SlaSetting> jobSets = null;
        if (slaObj.containsKey("jobSettings") && slaObj.get("jobSettings") != null) {
            jobSets = new ArrayList<SlaSetting>();
            for (Object set : (List)slaObj.get("jobSettings")) {
                SlaSetting jobSet = SlaSetting.fromObject(set);
                jobSets.add(jobSet);
            }
        }
        return new SLA(execId, jobName, checkTime, emails, slaActs, jobSets, rule);
    }

    public void setCheckTime(DateTime time) {
        this.checkTime = time;
    }

    public static class SlaSetting {
        private String id;
        private ReadablePeriod duration;
        private SlaRule rule = SlaRule.SUCCESS;
        private List<SlaAction> actions;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public ReadablePeriod getDuration() {
            return this.duration;
        }

        public void setDuration(ReadablePeriod duration) {
            this.duration = duration;
        }

        public SlaRule getRule() {
            return this.rule;
        }

        public void setRule(SlaRule rule) {
            this.rule = rule;
        }

        public List<SlaAction> getActions() {
            return this.actions;
        }

        public void setActions(List<SlaAction> actions) {
            this.actions = actions;
        }

        public Object toObject() {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("id", this.id);
            obj.put("duration", Schedule.createPeriodString(this.duration));
            obj.put("rule", this.rule.toString());
            ArrayList<String> actionsObj = new ArrayList<String>();
            for (SlaAction act : this.actions) {
                actionsObj.add(act.toString());
            }
            obj.put("actions", actionsObj);
            return obj;
        }

        public static SlaSetting fromObject(Object obj) {
            HashMap slaObj = (HashMap)obj;
            String subId = (String)slaObj.get("id");
            ReadablePeriod dur = Schedule.parsePeriodString((String)slaObj.get("duration"));
            SlaRule slaRule = SlaRule.valueOf((String)slaObj.get("rule"));
            ArrayList actsObj = (ArrayList)slaObj.get("actions");
            ArrayList<SlaAction> slaActs = new ArrayList<SlaAction>();
            for (String act : actsObj) {
                slaActs.add(SlaAction.valueOf(act));
            }
            SlaSetting ret = new SlaSetting();
            ret.setId(subId);
            ret.setDuration(dur);
            ret.setRule(slaRule);
            ret.setActions(slaActs);
            return ret;
        }
    }

    public static enum SlaAction {
        EMAIL(1),
        KILL(2);

        private int numVal;

        private SlaAction(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public static SlaAction fromInteger(int x) {
            switch (x) {
                case 1: {
                    return EMAIL;
                }
                case 2: {
                    return KILL;
                }
            }
            return EMAIL;
        }
    }

    public static enum SlaRule {
        SUCCESS(1),
        FINISH(2),
        WAITANDCHECKJOB(3);

        private int numVal;

        private SlaRule(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public static SlaRule fromInteger(int x) {
            switch (x) {
                case 1: {
                    return SUCCESS;
                }
                case 2: {
                    return FINISH;
                }
                case 3: {
                    return WAITANDCHECKJOB;
                }
            }
            return SUCCESS;
        }
    }
}

