/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_executorInstance;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.Properties;
import org.apache.gobblin.runtime.api.ServiceNode;
import org.apache.gobblin.util.ConfigUtils;

public class BaseServiceNodeImpl
implements ServiceNode {
    public String nodeName;
    public Config nodeProps;
    private boolean isNodeSecure;

    public BaseServiceNodeImpl(String nodeName) {
        this(nodeName, new Properties());
    }

    public BaseServiceNodeImpl(String nodeName, Properties props) {
        Preconditions.checkNotNull((Object)nodeName);
        this.nodeName = nodeName;
        this.isNodeSecure = Boolean.parseBoolean(props.getProperty("node.secured", "true"));
        this.nodeProps = ConfigUtils.propertiesToConfig((Properties)props);
    }

    public boolean isNodeEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseServiceNodeImpl that = (BaseServiceNodeImpl)o;
        return this.nodeName.equals(that.nodeName);
    }

    public int hashCode() {
        return this.nodeName.hashCode();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Config getNodeProps() {
        return this.nodeProps;
    }

    public boolean isNodeSecure() {
        return this.isNodeSecure;
    }

    public void setNodeSecure(boolean isNodeSecure) {
        this.isNodeSecure = isNodeSecure;
    }
}

