/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

class RAPServerCodec
extends ChannelDuplexHandler {
    private final RAPResponseEncoder _encoder = new RAPResponseEncoder();
    private final RAPRequestDecoder _decoder = new RAPRequestDecoder();

    RAPServerCodec() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this._decoder.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this._encoder.write(ctx, msg, promise);
    }

    private class RAPResponseEncoder
    extends MessageToMessageEncoder<RestResponse> {
        private RAPResponseEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, RestResponse response, List<Object> out) throws Exception {
            ByteString entity = response.getEntity();
            ByteBuf content = Unpooled.wrappedBuffer((ByteBuffer)entity.asByteBuffer());
            DefaultFullHttpResponse nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.getStatus()), content);
            for (Map.Entry e : response.getHeaders().entrySet()) {
                nettyResponse.headers().set((String)e.getKey(), e.getValue());
            }
            nettyResponse.headers().set("Set-Cookie", (Iterable)response.getCookies());
            nettyResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)entity.length());
            out.add(nettyResponse);
        }
    }

    private class RAPRequestDecoder
    extends MessageToMessageDecoder<FullHttpRequest> {
        private RAPRequestDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, FullHttpRequest nettyRequest, List<Object> out) throws Exception {
            if (nettyRequest.decoderResult().isFailure()) {
                ctx.fireExceptionCaught(nettyRequest.decoderResult().cause());
                return;
            }
            URI uri = new URI(nettyRequest.uri());
            RestRequestBuilder builder = new RestRequestBuilder(uri);
            builder.setMethod(nettyRequest.method().name());
            for (Map.Entry e : nettyRequest.headers()) {
                if (((String)e.getKey()).equalsIgnoreCase("Cookie")) {
                    builder.addCookie((String)e.getValue());
                    continue;
                }
                builder.unsafeAddHeaderValue((String)e.getKey(), (String)e.getValue());
            }
            ByteBuf buf = nettyRequest.content();
            if (buf != null) {
                ByteString entity = ByteString.read((InputStream)new ByteBufInputStream(buf), (int)buf.readableBytes());
                builder.setEntity(entity);
            }
            out.add(builder.build());
        }
    }
}

