/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.graphite;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.gobblin.metrics.Measurements;
import org.apache.gobblin.metrics.graphite.GraphiteConnectionType;
import org.apache.gobblin.metrics.graphite.GraphitePusher;
import org.apache.gobblin.metrics.reporter.ConfiguredScheduledReporter;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporter
extends ConfiguredScheduledReporter {
    private final GraphitePusher graphitePusher;
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteReporter.class);

    public GraphiteReporter(Builder<?> builder, Config config) throws IOException {
        super(builder, config);
        this.graphitePusher = builder.graphitePusher.isPresent() ? (GraphitePusher)builder.graphitePusher.get() : (GraphitePusher)this.closer.register((Closeable)new GraphitePusher(builder.hostname, builder.port, builder.connectionType));
    }

    protected void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers, Map<String, Object> tags) {
        String prefix = this.getMetricNamePrefix(tags);
        long timestamp = System.currentTimeMillis() / 1000L;
        try {
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(prefix, entry.getKey(), entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(prefix, entry.getKey(), (Counting)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(prefix, entry.getKey(), (Histogram)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMetered(prefix, entry.getKey(), (Metered)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(prefix, entry.getKey(), (Timer)entry.getValue(), timestamp);
            }
            this.graphitePusher.flush();
        }
        catch (IOException ioe) {
            LOGGER.error("Error sending metrics to Graphite", (Throwable)ioe);
            try {
                this.graphitePusher.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Error closing the Graphite sender", (Throwable)iOException);
            }
        }
    }

    private void reportGauge(String prefix, String name, Gauge gauge, long timestamp) throws IOException {
        String metricName = this.getKey(prefix, name);
        this.pushMetric(metricName, gauge.getValue().toString(), timestamp);
    }

    private void reportCounter(String prefix, String name, Counting counter, long timestamp) throws IOException {
        String metricName = this.getKey(prefix, name, Measurements.COUNT.getName());
        this.pushMetric(metricName, counter.getCount(), false, timestamp);
    }

    private void reportHistogram(String prefix, String name, Histogram histogram, long timestamp) throws IOException {
        this.reportCounter(prefix, name, (Counting)histogram, timestamp);
        this.reportSnapshot(prefix, name, histogram.getSnapshot(), timestamp, false);
    }

    private void reportTimer(String prefix, String name, Timer timer, long timestamp) throws IOException {
        this.reportSnapshot(prefix, name, timer.getSnapshot(), timestamp, true);
        this.reportMetered(prefix, name, (Metered)timer, timestamp);
    }

    private void reportSnapshot(String prefix, String name, Snapshot snapshot, long timestamp, boolean convertDuration) throws IOException {
        String baseMetricName = this.getKey(prefix, name);
        this.pushMetric(this.getKey(baseMetricName, Measurements.MIN), snapshot.getMin(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.MAX), snapshot.getMax(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.MEAN), snapshot.getMean(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.STDDEV), snapshot.getStdDev(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.MEDIAN), snapshot.getMedian(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.PERCENTILE_75TH), snapshot.get75thPercentile(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.PERCENTILE_95TH), snapshot.get95thPercentile(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.PERCENTILE_98TH), snapshot.get98thPercentile(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.PERCENTILE_99TH), snapshot.get99thPercentile(), convertDuration, timestamp);
        this.pushMetric(this.getKey(baseMetricName, Measurements.PERCENTILE_999TH), snapshot.get999thPercentile(), convertDuration, timestamp);
    }

    private void reportMetered(String prefix, String name, Metered metered, long timestamp) throws IOException {
        this.reportCounter(prefix, name, (Counting)metered, timestamp);
        String baseMetricName = this.getKey(prefix, name);
        this.pushMetricRate(this.getKey(baseMetricName, Measurements.RATE_1MIN), metered.getOneMinuteRate(), timestamp);
        this.pushMetricRate(this.getKey(baseMetricName, Measurements.RATE_5MIN), metered.getFiveMinuteRate(), timestamp);
        this.pushMetricRate(this.getKey(baseMetricName, Measurements.RATE_15MIN), metered.getFifteenMinuteRate(), timestamp);
        this.pushMetricRate(this.getKey(baseMetricName, Measurements.MEAN_RATE), metered.getMeanRate(), timestamp);
    }

    private void pushMetric(String metricName, Number value, boolean toDuration, long timestamp) throws IOException {
        String metricValue = toDuration ? this.getValue(this.convertDuration(value.doubleValue())) : this.getValue(value);
        this.pushMetric(metricName, metricValue, timestamp);
    }

    private void pushMetricRate(String metricName, double value, long timestamp) throws IOException {
        this.pushMetric(metricName, this.getValue(this.convertRate(value)), timestamp);
    }

    private void pushMetric(String name, String value, long timestamp) throws IOException {
        this.graphitePusher.push(name, value, timestamp);
    }

    private String getValue(Number value) {
        return value.toString();
    }

    private String getKey(String baseName, Measurements measurements) {
        return this.getKey(baseName, measurements.getName());
    }

    private String getKey(String ... keys) {
        return JOINER.join((Object[])keys);
    }

    public static abstract class Builder<T extends ConfiguredScheduledReporter.Builder<T>>
    extends ConfiguredScheduledReporter.Builder<T> {
        protected MetricFilter filter;
        protected String hostname;
        protected int port;
        protected GraphiteConnectionType connectionType;
        protected Optional<GraphitePusher> graphitePusher;

        protected Builder() {
            this.name = "GraphiteReporter";
            this.graphitePusher = Optional.absent();
            this.filter = MetricFilter.ALL;
            this.connectionType = GraphiteConnectionType.TCP;
        }

        public T withGraphitePusher(GraphitePusher pusher) {
            this.graphitePusher = Optional.of((Object)pusher);
            return (T)this.self();
        }

        public T withConnection(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
            return (T)this.self();
        }

        public T withConnectionType(GraphiteConnectionType connectionType) {
            this.connectionType = connectionType;
            return (T)this.self();
        }

        public T filter(MetricFilter filter) {
            this.filter = filter;
            return (T)this.self();
        }

        public GraphiteReporter build(Properties props) throws IOException {
            return new GraphiteReporter(this, ConfigUtils.propertiesToConfig((Properties)props, (Optional)Optional.of((Object)"metrics.")));
        }
    }

    public static class BuilderImpl
    extends Builder<BuilderImpl> {
        protected BuilderImpl self() {
            return this;
        }
    }

    public static class Factory {
        public static BuilderImpl newBuilder() {
            return new BuilderImpl();
        }
    }
}

