/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter;

import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.FilterChainIterator;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class FilterChainImpl
implements FilterChain {
    private final List<RestFilter> _restFilters;
    private final List<StreamFilter> _streamFilters;

    public FilterChainImpl() {
        this._restFilters = Collections.emptyList();
        this._streamFilters = Collections.emptyList();
    }

    private FilterChainImpl(List<RestFilter> restFilters, List<StreamFilter> streamFilters) {
        this._restFilters = Collections.unmodifiableList(new ArrayList<RestFilter>(restFilters));
        this._streamFilters = Collections.unmodifiableList(new ArrayList<StreamFilter>(streamFilters));
    }

    @Override
    public FilterChain addFirstRest(RestFilter filter) {
        FilterChainImpl.notNull(filter, "filter");
        return new FilterChainImpl(this.doAddFirst(this._restFilters, filter), this._streamFilters);
    }

    @Override
    public FilterChain addLastRest(RestFilter filter) {
        FilterChainImpl.notNull(filter, "filter");
        return new FilterChainImpl(this.doAddLast(this._restFilters, filter), this._streamFilters);
    }

    @Override
    public FilterChain addFirst(StreamFilter filter) {
        FilterChainImpl.notNull(filter, "filter");
        return new FilterChainImpl(this._restFilters, this.doAddFirst(this._streamFilters, filter));
    }

    @Override
    public FilterChain addLast(StreamFilter filter) {
        FilterChainImpl.notNull(filter, "filter");
        return new FilterChainImpl(this._restFilters, this.doAddLast(this._streamFilters, filter));
    }

    @Override
    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs) {
        new FilterChainIterator.FilterChainRestIterator(this._restFilters, 0).onRequest(req, requestContext, wireAttrs);
    }

    @Override
    public void onRestResponse(RestResponse res, RequestContext requestContext, Map<String, String> wireAttrs) {
        new FilterChainIterator.FilterChainRestIterator(this._restFilters, this._restFilters.size()).onResponse(res, requestContext, wireAttrs);
    }

    @Override
    public void onRestError(Exception ex, RequestContext requestContext, Map<String, String> wireAttrs) {
        new FilterChainIterator.FilterChainRestIterator(this._restFilters, this._restFilters.size()).onError(ex, requestContext, wireAttrs);
    }

    @Override
    public void onStreamRequest(StreamRequest req, RequestContext requestContext, Map<String, String> wireAttrs) {
        new FilterChainIterator.FilterChainStreamIterator(this._streamFilters, 0).onRequest(req, requestContext, wireAttrs);
    }

    @Override
    public void onStreamResponse(StreamResponse res, RequestContext requestContext, Map<String, String> wireAttrs) {
        new FilterChainIterator.FilterChainStreamIterator(this._streamFilters, this._streamFilters.size()).onResponse(res, requestContext, wireAttrs);
    }

    @Override
    public void onStreamError(Exception ex, RequestContext requestContext, Map<String, String> wireAttrs) {
        new FilterChainIterator.FilterChainStreamIterator(this._streamFilters, this._streamFilters.size()).onError(ex, requestContext, wireAttrs);
    }

    private <T> List<T> doAddFirst(List<T> list, T obj) {
        ArrayList<T> newFilters = new ArrayList<T>(list.size() + 1);
        newFilters.add(obj);
        newFilters.addAll(list);
        return newFilters;
    }

    private <T> List<T> doAddLast(List<T> list, T obj) {
        ArrayList<T> newFilters = new ArrayList<T>(list.size() + 1);
        newFilters.addAll(list);
        newFilters.add(obj);
        return newFilters;
    }

    private static void notNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }
}

