/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.predicates;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HiveLocationDescriptor;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonPartitionTableRegistrationTimeSkipPredicate
implements Predicate<HiveCopyEntityHelper> {
    private static final Logger log = LoggerFactory.getLogger(NonPartitionTableRegistrationTimeSkipPredicate.class);

    public boolean apply(@Nullable HiveCopyEntityHelper helper) {
        if (helper == null) {
            return true;
        }
        if (!helper.getExistingTargetTable().isPresent()) {
            return false;
        }
        if (!((Table)helper.getExistingTargetTable().get()).getParameters().containsKey("registrationGenerationTimeMillis")) {
            return false;
        }
        try {
            long oldRegistrationTime = Long.parseLong((String)((Table)helper.getExistingTargetTable().get()).getParameters().get("registrationGenerationTimeMillis"));
            HiveLocationDescriptor sourceHiveDescriptor = HiveLocationDescriptor.forTable(helper.getDataset().getTable(), helper.getDataset().getFs(), helper.getDataset().getProperties());
            Optional<FileStatus> sourceFileStatus = helper.getConfiguration().getCopyContext().getFileStatus(helper.getDataset().getFs(), sourceHiveDescriptor.getLocation());
            if (!sourceFileStatus.isPresent()) {
                throw new RuntimeException(String.format("Source path %s does not exist!", sourceHiveDescriptor.getLocation()));
            }
            return oldRegistrationTime > ((FileStatus)sourceFileStatus.get()).getModificationTime();
        }
        catch (NumberFormatException nfe) {
            log.warn(String.format("Cannot parse %s in table %s. Will not skip.", "registrationGenerationTimeMillis", helper.getDataset().getTable().getDbName() + "." + helper.getDataset().getTable().getTableName()));
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

