/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.Destination;
import org.apache.gobblin.writer.WriterOutputFormat;
import org.apache.gobblin.writer.initializer.NoopWriterInitializer;
import org.apache.gobblin.writer.initializer.WriterInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataWriterBuilder<S, D> {
    private static final Logger log = LoggerFactory.getLogger(DataWriterBuilder.class);
    protected Destination destination;
    protected String writerId;
    protected WriterOutputFormat format;
    protected S schema;
    protected int branches;
    protected int branch;
    protected String writerAttemptId;

    public DataWriterBuilder<S, D> writeTo(Destination destination) {
        this.destination = destination;
        log.debug("For destination: {}", (Object)destination);
        return this;
    }

    public DataWriterBuilder<S, D> writeInFormat(WriterOutputFormat format) {
        this.format = format;
        log.debug("writeInFormat : {}", (Object)this.format);
        return this;
    }

    public DataWriterBuilder<S, D> withWriterId(String writerId) {
        this.writerId = writerId;
        log.debug("withWriterId : {}", (Object)this.writerId);
        return this;
    }

    public DataWriterBuilder<S, D> withSchema(S schema) {
        this.schema = schema;
        log.debug("withSchema : {}", this.schema);
        return this;
    }

    public DataWriterBuilder<S, D> withBranches(int branches) {
        this.branches = branches;
        log.debug("With branches: {}", (Object)this.branches);
        return this;
    }

    public DataWriterBuilder<S, D> forBranch(int branch) {
        this.branch = branch;
        log.debug("For branch: {}", (Object)this.branch);
        return this;
    }

    public DataWriterBuilder<S, D> withAttemptId(String attemptId) {
        this.writerAttemptId = attemptId;
        log.debug("With writerAttemptId: {}", (Object)this.writerAttemptId);
        return this;
    }

    public WriterInitializer getInitializer(State state, WorkUnitStream workUnits, int branches, int branchId) {
        return NoopWriterInitializer.INSTANCE;
    }

    public abstract DataWriter<D> build() throws IOException;

    public Destination getDestination() {
        return this.destination;
    }

    public String getWriterId() {
        return this.writerId;
    }

    public WriterOutputFormat getFormat() {
        return this.format;
    }

    public S getSchema() {
        return this.schema;
    }

    public int getBranches() {
        return this.branches;
    }

    public int getBranch() {
        return this.branch;
    }

    public String getWriterAttemptId() {
        return this.writerAttemptId;
    }
}

