/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.dataset;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;

public final class DatasetDescriptor {
    private static final String PLATFORM_KEY = "platform";
    private static final String NAME_KEY = "name";
    private final String platform;
    private final String name;
    private final Map<String, String> metadata = Maps.newHashMap();

    public DatasetDescriptor(DatasetDescriptor copy) {
        this.platform = copy.getPlatform();
        this.name = copy.getName();
        this.metadata.putAll((Map<String, String>)copy.getMetadata());
    }

    public ImmutableMap<String, String> getMetadata() {
        return ImmutableMap.builder().putAll(this.metadata).build();
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Map<String, String> toDataMap() {
        HashMap map = Maps.newHashMap();
        map.put(PLATFORM_KEY, this.platform);
        map.put(NAME_KEY, this.name);
        map.putAll(this.metadata);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetDescriptor that = (DatasetDescriptor)o;
        return this.platform.equals(that.platform) && this.name.equals(that.name) && this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result = this.platform.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public static DatasetDescriptor fromDataMap(Map<String, String> dataMap) {
        DatasetDescriptor descriptor = new DatasetDescriptor(dataMap.get(PLATFORM_KEY), dataMap.get(NAME_KEY));
        dataMap.forEach((key, value) -> {
            if (!key.equals(PLATFORM_KEY) && !key.equals(NAME_KEY)) {
                descriptor.addMetadata((String)key, (String)value);
            }
        });
        return descriptor;
    }

    @ConstructorProperties(value={"platform", "name"})
    public DatasetDescriptor(String platform, String name) {
        this.platform = platform;
        this.name = name;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getName() {
        return this.name;
    }
}

