/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.policy;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveTable;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicyBase;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.hive.spec.SimpleHiveSpec;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

@Alpha
public class HiveSnapshotRegistrationPolicy
extends HiveRegistrationPolicyBase {
    public static final String SNAPSHOT_PATH_PATTERN = "snapshot.path.pattern";
    protected final Optional<Pattern> snapshotPathPattern;

    protected HiveSnapshotRegistrationPolicy(State props) throws IOException {
        super(props);
        this.snapshotPathPattern = props.contains(SNAPSHOT_PATH_PATTERN) ? Optional.of((Object)Pattern.compile(props.getProp(SNAPSHOT_PATH_PATTERN))) : Optional.absent();
    }

    @Override
    public Collection<HiveSpec> getHiveSpecs(Path path) throws IOException {
        List<HiveTable> tables = this.getTables(path);
        if (tables.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList specs = Lists.newArrayList();
        for (HiveTable table : tables) {
            specs.add(((SimpleHiveSpec.Builder)((SimpleHiveSpec.Builder)new SimpleHiveSpec.Builder(path).withTable(table)).withPartition(this.getPartition(path, table))).build());
        }
        return specs;
    }

    @Override
    protected List<HiveTable> getTables(Path path) throws IOException {
        Path latestSnapshot = this.getLatestSnapshot(path);
        if (latestSnapshot == null) {
            return ImmutableList.of();
        }
        return super.getTables(latestSnapshot);
    }

    protected Path getLatestSnapshot(Path path) throws IOException {
        FileStatus[] statuses = this.fs.listStatus(path, new PathFilter(){

            public boolean accept(Path p) {
                try {
                    if (!HiveSnapshotRegistrationPolicy.this.fs.isDirectory(p)) {
                        return false;
                    }
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                return !HiveSnapshotRegistrationPolicy.this.snapshotPathPattern.isPresent() || ((Pattern)HiveSnapshotRegistrationPolicy.this.snapshotPathPattern.get()).matcher(p.toString()).matches();
            }
        });
        if (statuses.length == 0) {
            return null;
        }
        Arrays.sort(statuses, new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus o1, FileStatus o2) {
                return o2.getPath().getName().compareTo(o1.getPath().getName());
            }
        });
        return statuses[0].getPath();
    }
}

