/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor;

import java.util.Properties;
import org.apache.gobblin.configuration.State;

public enum JobCommitPolicy {
    COMMIT_ON_FULL_SUCCESS("full"),
    COMMIT_ON_PARTIAL_SUCCESS("partial"),
    COMMIT_SUCCESSFUL_TASKS("successful");

    private final String name;

    private JobCommitPolicy(String name) {
        this.name = name;
    }

    public static JobCommitPolicy forName(String name) {
        if (JobCommitPolicy.COMMIT_ON_FULL_SUCCESS.name.equalsIgnoreCase(name)) {
            return COMMIT_ON_FULL_SUCCESS;
        }
        if (JobCommitPolicy.COMMIT_ON_PARTIAL_SUCCESS.name.equalsIgnoreCase(name)) {
            return COMMIT_ON_PARTIAL_SUCCESS;
        }
        if (JobCommitPolicy.COMMIT_SUCCESSFUL_TASKS.name.equalsIgnoreCase(name)) {
            return COMMIT_SUCCESSFUL_TASKS;
        }
        throw new IllegalArgumentException(String.format("Job commit policy with name %s is not supported", name));
    }

    public static JobCommitPolicy getCommitPolicy(Properties jobProps) {
        return JobCommitPolicy.forName(jobProps.getProperty("job.commit.policy", "full"));
    }

    public static JobCommitPolicy getCommitPolicy(State state) {
        return JobCommitPolicy.forName(state.getProp("job.commit.policy", "full"));
    }
}

