/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.extractor;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.extractor.InstrumentedExtractorBase;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.records.RecordStreamWithMetadata;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.DecoratorUtils;
import org.apache.gobblin.util.FinalState;

public class InstrumentedExtractorDecorator<S, D>
extends InstrumentedExtractorBase<S, D>
implements Decorator {
    private final Extractor<S, D> embeddedExtractor;
    private final boolean isEmbeddedInstrumented;
    private volatile long lastRecordTime;

    public InstrumentedExtractorDecorator(WorkUnitState workUnitState, Extractor<S, D> extractor) {
        super(workUnitState, Optional.of(DecoratorUtils.resolveUnderlyingObject(extractor).getClass()));
        this.embeddedExtractor = (Extractor)this.closer.register(extractor);
        this.isEmbeddedInstrumented = Instrumented.isLineageInstrumented(extractor);
    }

    @Override
    public MetricContext getMetricContext() {
        return this.isEmbeddedInstrumented ? ((InstrumentedExtractorBase)this.embeddedExtractor).getMetricContext() : super.getMetricContext();
    }

    @Override
    public RecordEnvelope<D> readRecordEnvelope() throws DataRecordException, IOException {
        return this.isEmbeddedInstrumented ? this.embeddedExtractor.readRecordEnvelope() : super.readRecordEnvelope();
    }

    @Override
    protected RecordEnvelope<D> readRecordEnvelopeImpl() throws DataRecordException, IOException {
        return this.embeddedExtractor.readRecordEnvelope();
    }

    @Override
    public RecordStreamWithMetadata<D, S> recordStream(AtomicBoolean shutdownRequest) throws IOException {
        if (this.isEmbeddedInstrumented) {
            return this.embeddedExtractor.recordStream(shutdownRequest);
        }
        RecordStreamWithMetadata stream = this.embeddedExtractor.recordStream(shutdownRequest);
        stream = stream.mapRecords(r -> {
            if (this.lastRecordTime == 0L) {
                this.lastRecordTime = System.nanoTime();
            }
            this.afterRead(r.getRecord(), this.lastRecordTime);
            this.lastRecordTime = System.nanoTime();
            return r;
        });
        return stream;
    }

    public S getSchema() throws IOException {
        return (S)this.embeddedExtractor.getSchema();
    }

    public long getExpectedRecordCount() {
        return this.embeddedExtractor.getExpectedRecordCount();
    }

    public long getHighWatermark() {
        return this.embeddedExtractor.getHighWatermark();
    }

    @Override
    public State getFinalState() {
        if (this.embeddedExtractor instanceof FinalState) {
            return ((FinalState)this.embeddedExtractor).getFinalState();
        }
        return super.getFinalState();
    }

    public Object getDecoratedObject() {
        return this.embeddedExtractor;
    }
}

