/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.crypto;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionConfigParser {
    private static final Logger log = LoggerFactory.getLogger(EncryptionConfigParser.class);
    static final String WRITER_ENCRYPT_PREFIX = "writer.encrypt";
    static final String CONVERTER_ENCRYPT_PREFIX = "converter.encrypt";
    static final String CONVERTER_DECRYPT_PREFIX = "converter.decrypt";
    public static final String ENCRYPTION_ALGORITHM_KEY = "algorithm";
    public static final String ENCRYPTION_KEYSTORE_PATH_KEY = "keystore_path";
    public static final String ENCRYPTION_KEYSTORE_PASSWORD_KEY = "keystore_password";
    public static final String ENCRYPTION_KEY_NAME = "key_name";
    public static final String ENCRYPTION_KEYSTORE_TYPE_KEY = "keystore_type";
    public static final String ENCRYPTION_KEYSTORE_TYPE_KEY_DEFAULT = "java";
    public static final String ENCRYPTION_KEYSTORE_ENCODING_KEY = "keystore_encoding";
    public static final String ENCRYPTION_KEYSTORE_ENCODING_DEFAULT = "hex";
    public static final String ENCRYPTION_TYPE_ANY = "any";

    public static Map<String, Object> getConfigForBranch(EntityType entityType, WorkUnitState workUnitState) {
        return EncryptionConfigParser.getConfigForBranch(entityType, null, workUnitState);
    }

    public static Map<String, Object> getConfigForBranch(EntityType entityType, String entityName, WorkUnitState workUnitState) {
        Map<String, Object> config = EncryptionConfigParser.getConfigForBranch(workUnitState.getJobState(), entityType.getConfigPrefix(), ForkOperatorUtils.getPropertyNameForBranch((WorkUnitState)workUnitState, (String)""));
        if (entityName != null) {
            String entityPrefix = entityType.getConfigPrefix() + "." + entityName;
            Map<String, Object> entitySpecificConfig = EncryptionConfigParser.getConfigForBranch(workUnitState.getJobState(), entityPrefix, ForkOperatorUtils.getPropertyNameForBranch((WorkUnitState)workUnitState, (String)""));
            if (config == null) {
                config = entitySpecificConfig;
            } else if (entitySpecificConfig != null) {
                config.keySet().removeIf(s -> s.startsWith(entityName + "."));
                config.putAll(entitySpecificConfig);
            }
        }
        return config;
    }

    public static Map<String, Object> getConfigForBranch(EntityType entityType, State taskState, int numBranches, int branch) {
        return EncryptionConfigParser.getConfigForBranch(taskState, entityType.getConfigPrefix(), ForkOperatorUtils.getPropertyNameForBranch((String)"", (int)numBranches, (int)branch));
    }

    private static Map<String, Object> getConfigForBranch(State taskState, String prefix, String branchSuffix) {
        Map<String, Object> properties = EncryptionConfigParser.extractPropertiesForBranch(taskState.getProperties(), prefix, branchSuffix);
        if (properties.isEmpty()) {
            return null;
        }
        if (EncryptionConfigParser.getEncryptionType(properties) == null) {
            log.warn("Encryption algorithm not specified; ignoring other encryption settings");
            return null;
        }
        PasswordManager passwordManager = PasswordManager.getInstance((State)taskState);
        if (properties.containsKey(ENCRYPTION_KEYSTORE_PASSWORD_KEY)) {
            properties.put(ENCRYPTION_KEYSTORE_PASSWORD_KEY, passwordManager.readPassword((String)properties.get(ENCRYPTION_KEYSTORE_PASSWORD_KEY)));
        }
        return properties;
    }

    public static String getEncryptionType(Map<String, Object> properties) {
        return (String)properties.get(ENCRYPTION_ALGORITHM_KEY);
    }

    public static String getKeystorePath(Map<String, Object> properties) {
        return (String)properties.get(ENCRYPTION_KEYSTORE_PATH_KEY);
    }

    public static String getKeystorePassword(Map<String, Object> properties) {
        return (String)properties.get(ENCRYPTION_KEYSTORE_PASSWORD_KEY);
    }

    public static String getKeystoreType(Map<String, Object> parameters) {
        String type = (String)parameters.get(ENCRYPTION_KEYSTORE_TYPE_KEY);
        if (type == null) {
            type = ENCRYPTION_KEYSTORE_TYPE_KEY_DEFAULT;
        }
        return type;
    }

    public static String getKeyName(Map<String, Object> parameters) {
        return (String)parameters.get(ENCRYPTION_KEY_NAME);
    }

    public static String getKeystoreEncoding(Map<String, Object> parameters) {
        return (String)parameters.getOrDefault(ENCRYPTION_KEYSTORE_ENCODING_KEY, ENCRYPTION_KEYSTORE_ENCODING_DEFAULT);
    }

    private static Map<String, Object> extractPropertiesForBranch(Properties properties, String prefix, String branchSuffix) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            int strippedKeyStart;
            String key = (String)prop.getKey();
            if (!key.startsWith(prefix) || branchSuffix.length() != 0 && !key.endsWith(branchSuffix) || (strippedKeyStart = Math.min(key.length(), prefix.length() + 1)) != key.length() && key.charAt(strippedKeyStart - 1) != '.') continue;
            int strippedKeyEnd = Math.max(strippedKeyStart, key.length() - branchSuffix.length());
            String strippedKey = key.substring(strippedKeyStart, strippedKeyEnd);
            ret.put(strippedKey, prop.getValue());
        }
        return ret;
    }

    public static enum EntityType {
        CONVERTER_ENCRYPT("converter.encrypt"),
        CONVERTER_DECRYPT("converter.decrypt"),
        WRITER("writer.encrypt");

        private final String configPrefix;

        private EntityType(String configPrefix) {
            this.configPrefix = configPrefix;
        }

        public String getConfigPrefix() {
            return this.configPrefix;
        }
    }
}

