/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;

public class AvroSchemaFieldRemover {
    private static final Splitter SPLITTER_ON_COMMA = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Splitter SPLITTER_ON_DOT = Splitter.on((char)'.').trimResults().omitEmptyStrings();
    private static final AvroSchemaFieldRemover DO_NOTHING_INSTANCE = new AvroSchemaFieldRemover();
    private final Map<String, AvroSchemaFieldRemover> children = Maps.newHashMap();

    public AvroSchemaFieldRemover(String fieldNames) {
        this.addChildren(fieldNames);
    }

    private AvroSchemaFieldRemover() {
        this("");
    }

    private void addChildren(String fieldNames) {
        for (String fieldName : SPLITTER_ON_COMMA.splitToList((CharSequence)fieldNames)) {
            List fieldNameComponents = SPLITTER_ON_DOT.splitToList((CharSequence)fieldName);
            if (fieldNameComponents.isEmpty()) continue;
            this.addChildren(fieldNameComponents, 0);
        }
    }

    private void addChildren(List<String> fieldNameComponents, int level) {
        Preconditions.checkArgument((fieldNameComponents.size() > level ? 1 : 0) != 0);
        if (!this.children.containsKey(fieldNameComponents.get(level))) {
            this.children.put(fieldNameComponents.get(level), new AvroSchemaFieldRemover());
        }
        if (level < fieldNameComponents.size() - 1) {
            this.children.get(fieldNameComponents.get(level)).addChildren(fieldNameComponents, level + 1);
        }
    }

    public Schema removeFields(Schema schema) {
        return this.removeFields(schema, Maps.newHashMap());
    }

    private Schema removeFields(Schema schema, Map<String, Schema> schemaMap) {
        switch (schema.getType()) {
            case RECORD: {
                if (schemaMap.containsKey(schema.getFullName())) {
                    return schemaMap.get(schema.getFullName());
                }
                return this.removeFieldsFromRecords(schema, schemaMap);
            }
            case UNION: {
                return this.removeFieldsFromUnion(schema, schemaMap);
            }
            case ARRAY: {
                return this.removeFieldsFromArray(schema, schemaMap);
            }
            case MAP: {
                return this.removeFieldsFromMap(schema, schemaMap);
            }
        }
        return schema;
    }

    private Schema removeFieldsFromRecords(Schema schema, Map<String, Schema> schemaMap) {
        Schema newRecord = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
        schemaMap.put(schema.getFullName(), newRecord);
        ArrayList newFields = Lists.newArrayList();
        for (Schema.Field field : schema.getFields()) {
            if (this.shouldRemove(field)) continue;
            Schema.Field newField = this.children.containsKey(field.name()) ? new Schema.Field(field.name(), this.children.get(field.name()).removeFields(field.schema(), schemaMap), field.doc(), field.defaultValue()) : new Schema.Field(field.name(), DO_NOTHING_INSTANCE.removeFields(field.schema(), schemaMap), field.doc(), field.defaultValue());
            newFields.add(newField);
        }
        newRecord.setFields((List)newFields);
        return newRecord;
    }

    private boolean shouldRemove(Schema.Field field) {
        return this.children.containsKey(field.name()) && this.children.get((Object)field.name()).children.isEmpty();
    }

    private Schema removeFieldsFromUnion(Schema schema, Map<String, Schema> schemaMap) {
        ArrayList newUnion = Lists.newArrayList();
        for (Schema unionType : schema.getTypes()) {
            newUnion.add(this.removeFields(unionType, schemaMap));
        }
        return Schema.createUnion((List)newUnion);
    }

    private Schema removeFieldsFromArray(Schema schema, Map<String, Schema> schemaMap) {
        return Schema.createArray((Schema)this.removeFields(schema.getElementType(), schemaMap));
    }

    private Schema removeFieldsFromMap(Schema schema, Map<String, Schema> schemaMap) {
        return Schema.createMap((Schema)this.removeFields(schema.getValueType(), schemaMap));
    }
}

