/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class VectorizedBatchUtil {
    private static final Log LOG = LogFactory.getLog(VectorizedBatchUtil.class);

    public static void setNullColIsNullValue(ColumnVector cv, int rowIndex) {
        cv.isNull[rowIndex] = true;
        if (cv.noNulls) {
            cv.noNulls = false;
        }
    }

    public static void setNoNullFields(VectorizedRowBatch batch) {
        for (int i = 0; i < batch.numCols; ++i) {
            batch.cols[i].noNulls = true;
        }
    }

    public static void setRepeatingColumn(VectorizedRowBatch batch, int column) {
        ColumnVector cv = batch.cols[column];
        cv.isRepeating = true;
    }

    public static void setBatchSize(VectorizedRowBatch batch, int size) {
        assert (size <= batch.getMaxSize());
        batch.size = size;
    }

    private static void allocateColumnVector(StructObjectInspector oi, List<ColumnVector> cvList) throws HiveException {
        if (cvList == null) {
            throw new HiveException("Null columnvector list");
        }
        if (oi == null) {
            return;
        }
        List fields = oi.getAllStructFieldRefs();
        for (StructField field : fields) {
            ObjectInspector fieldObjectInspector = field.getFieldObjectInspector();
            block0 : switch (fieldObjectInspector.getCategory()) {
                case PRIMITIVE: {
                    PrimitiveObjectInspector poi = (PrimitiveObjectInspector)fieldObjectInspector;
                    switch (poi.getPrimitiveCategory()) {
                        case BOOLEAN: 
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: 
                        case TIMESTAMP: 
                        case DATE: {
                            cvList.add(new LongColumnVector(1024));
                            break block0;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            cvList.add(new DoubleColumnVector(1024));
                            break block0;
                        }
                        case BINARY: 
                        case STRING: 
                        case CHAR: 
                        case VARCHAR: {
                            cvList.add(new BytesColumnVector(1024));
                            break block0;
                        }
                        case DECIMAL: {
                            DecimalTypeInfo tInfo = (DecimalTypeInfo)poi.getTypeInfo();
                            cvList.add(new DecimalColumnVector(1024, tInfo.precision(), tInfo.scale()));
                            break block0;
                        }
                    }
                    throw new HiveException("Vectorizaton is not supported for datatype:" + poi.getPrimitiveCategory());
                }
                case STRUCT: {
                    throw new HiveException("Struct not supported");
                }
                default: {
                    throw new HiveException("Flattening is not supported for datatype:" + fieldObjectInspector.getCategory());
                }
            }
        }
    }

    public static VectorizedRowBatch constructVectorizedRowBatch(StructObjectInspector oi) throws HiveException {
        LinkedList<ColumnVector> cvList = new LinkedList<ColumnVector>();
        VectorizedBatchUtil.allocateColumnVector(oi, cvList);
        VectorizedRowBatch result = new VectorizedRowBatch(cvList.size());
        int i = 0;
        for (ColumnVector cv : cvList) {
            result.cols[i++] = cv;
        }
        return result;
    }

    public static VectorizedRowBatch constructVectorizedRowBatch(StructObjectInspector keyInspector, StructObjectInspector valueInspector) throws HiveException {
        LinkedList<ColumnVector> cvList = new LinkedList<ColumnVector>();
        VectorizedBatchUtil.allocateColumnVector(keyInspector, cvList);
        VectorizedBatchUtil.allocateColumnVector(valueInspector, cvList);
        VectorizedRowBatch result = new VectorizedRowBatch(cvList.size());
        result.cols = cvList.toArray(result.cols);
        return result;
    }

    public static void addRowToBatch(Object row, StructObjectInspector oi, int rowIndex, VectorizedRowBatch batch, DataOutputBuffer buffer) throws HiveException {
        VectorizedBatchUtil.addRowToBatchFrom(row, oi, rowIndex, 0, batch, buffer);
    }

    public static void addRowToBatchFrom(Object row, StructObjectInspector oi, int rowIndex, int colOffset, VectorizedRowBatch batch, DataOutputBuffer buffer) throws HiveException {
        List fieldRefs = oi.getAllStructFieldRefs();
        int off = colOffset;
        for (int i = 0; i < fieldRefs.size(); ++i) {
            VectorizedBatchUtil.setVector(row, oi, fieldRefs, batch, buffer, rowIndex, i, off);
        }
    }

    public static void acidAddRowToBatch(Object row, StructObjectInspector oi, int rowIndex, VectorizedRowBatch batch, VectorizedRowBatchCtx context, DataOutputBuffer buffer) throws HiveException {
        List fieldRefs = oi.getAllStructFieldRefs();
        for (int i = 0; i < fieldRefs.size(); ++i) {
            if (batch.cols[i] == null || context.isPartitionCol(i)) continue;
            VectorizedBatchUtil.setVector(row, oi, fieldRefs, batch, buffer, rowIndex, i, 0);
        }
    }

    private static void setVector(Object row, StructObjectInspector oi, List<? extends StructField> fieldRefs, VectorizedRowBatch batch, DataOutputBuffer buffer, int rowIndex, int colIndex, int offset) throws HiveException {
        Object fieldData = oi.getStructFieldData(row, fieldRefs.get(colIndex));
        ObjectInspector foi = fieldRefs.get(colIndex).getFieldObjectInspector();
        assert (foi.getCategory() == ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)foi;
        Object writableCol = poi.getPrimitiveWritableObject(fieldData);
        switch (poi.getPrimitiveCategory()) {
            case BOOLEAN: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((BooleanWritable)writableCol).get() ? 1L : 0L;
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case BYTE: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((ByteWritable)writableCol).get();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case SHORT: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((ShortWritable)writableCol).get();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case INT: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((IntWritable)writableCol).get();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case LONG: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((LongWritable)writableCol).get();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case DATE: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((DateWritable)writableCol).getDays();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case FLOAT: {
                DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    dcv.vector[rowIndex] = ((FloatWritable)writableCol).get();
                    dcv.isNull[rowIndex] = false;
                    break;
                }
                dcv.vector[rowIndex] = Double.NaN;
                VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                break;
            }
            case DOUBLE: {
                DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    dcv.vector[rowIndex] = ((DoubleWritable)writableCol).get();
                    dcv.isNull[rowIndex] = false;
                    break;
                }
                dcv.vector[rowIndex] = Double.NaN;
                VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                break;
            }
            case TIMESTAMP: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    Timestamp t = ((TimestampWritable)writableCol).getTimestamp();
                    lcv.vector[rowIndex] = TimestampUtils.getTimeNanoSec(t);
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case BINARY: {
                BytesColumnVector bcv = (BytesColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    bcv.isNull[rowIndex] = false;
                    BytesWritable bw = (BytesWritable)writableCol;
                    byte[] bytes = bw.getBytes();
                    int start = buffer.getLength();
                    int length = bw.getLength();
                    try {
                        buffer.write(bytes, 0, length);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("bad write", ioe);
                    }
                    bcv.setRef(rowIndex, buffer.getData(), start, length);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                break;
            }
            case STRING: {
                BytesColumnVector bcv = (BytesColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    bcv.isNull[rowIndex] = false;
                    Text colText = (Text)writableCol;
                    int start = buffer.getLength();
                    int length = colText.getLength();
                    try {
                        buffer.write(colText.getBytes(), 0, length);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("bad write", ioe);
                    }
                    bcv.setRef(rowIndex, buffer.getData(), start, length);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                break;
            }
            case CHAR: {
                BytesColumnVector bcv = (BytesColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    bcv.isNull[rowIndex] = false;
                    HiveChar colHiveChar = ((HiveCharWritable)writableCol).getHiveChar();
                    byte[] bytes = colHiveChar.getStrippedValue().getBytes();
                    int length = bytes.length;
                    int start = buffer.getLength();
                    try {
                        buffer.write(bytes, 0, length);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("bad write", ioe);
                    }
                    bcv.setRef(rowIndex, buffer.getData(), start, length);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                break;
            }
            case VARCHAR: {
                BytesColumnVector bcv = (BytesColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    bcv.isNull[rowIndex] = false;
                    HiveVarchar colHiveVarchar = ((HiveVarcharWritable)writableCol).getHiveVarchar();
                    byte[] bytes = colHiveVarchar.getValue().getBytes();
                    int length = bytes.length;
                    int start = buffer.getLength();
                    try {
                        buffer.write(bytes, 0, length);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("bad write", ioe);
                    }
                    bcv.setRef(rowIndex, buffer.getData(), start, length);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                break;
            }
            case DECIMAL: {
                DecimalColumnVector dcv = (DecimalColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    dcv.isNull[rowIndex] = false;
                    HiveDecimalWritable wobj = (HiveDecimalWritable)writableCol;
                    dcv.set(rowIndex, wobj);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                break;
            }
            default: {
                throw new HiveException("Vectorizaton is not supported for datatype:" + poi.getPrimitiveCategory());
            }
        }
    }
}

