/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.exec.CommonFunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.PartitionTableFunctionDescription;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hive.common.util.AnnotationUtils;

public class FunctionInfo
implements CommonFunctionInfo {
    private final boolean isNative;
    private final boolean isInternalTableFunction;
    private final String displayName;
    private GenericUDF genericUDF;
    private GenericUDTF genericUDTF;
    private GenericUDAFResolver genericUDAFResolver;
    private Class<? extends TableFunctionResolver> tableFunctionResolver;
    private boolean blockedFunction;

    public FunctionInfo(boolean isNative, String displayName, GenericUDF genericUDF) {
        this.isNative = isNative;
        this.displayName = displayName;
        this.genericUDF = genericUDF;
        this.isInternalTableFunction = false;
    }

    public FunctionInfo(boolean isNative, String displayName, GenericUDAFResolver genericUDAFResolver) {
        this.isNative = isNative;
        this.displayName = displayName;
        this.genericUDAFResolver = genericUDAFResolver;
        this.isInternalTableFunction = false;
    }

    public FunctionInfo(boolean isNative, String displayName, GenericUDTF genericUDTF) {
        this.isNative = isNative;
        this.displayName = displayName;
        this.genericUDTF = genericUDTF;
        this.isInternalTableFunction = false;
    }

    public FunctionInfo(String displayName, Class<? extends TableFunctionResolver> tFnCls) {
        this.displayName = displayName;
        this.tableFunctionResolver = tFnCls;
        PartitionTableFunctionDescription def = (PartitionTableFunctionDescription)AnnotationUtils.getAnnotation(this.tableFunctionResolver, PartitionTableFunctionDescription.class);
        this.isInternalTableFunction = this.isNative = def == null ? false : def.isInternal();
    }

    public GenericUDF getGenericUDF() {
        if (this.genericUDF == null) {
            return null;
        }
        return FunctionRegistry.cloneGenericUDF(this.genericUDF);
    }

    public GenericUDTF getGenericUDTF() {
        if (this.genericUDTF == null) {
            return null;
        }
        return FunctionRegistry.cloneGenericUDTF(this.genericUDTF);
    }

    public GenericUDAFResolver getGenericUDAFResolver() {
        return this.genericUDAFResolver;
    }

    @Override
    public Class<?> getFunctionClass() {
        if (this.isGenericUDF()) {
            if (this.genericUDF instanceof GenericUDFBridge) {
                return ((GenericUDFBridge)this.genericUDF).getUdfClass();
            }
            return this.genericUDF.getClass();
        }
        if (this.isGenericUDAF()) {
            if (this.genericUDAFResolver instanceof GenericUDAFBridge) {
                return ((GenericUDAFBridge)this.genericUDAFResolver).getUDAFClass();
            }
            return this.genericUDAFResolver.getClass();
        }
        if (this.isGenericUDTF()) {
            return this.genericUDTF.getClass();
        }
        if (this.isTableFunction()) {
            return this.tableFunctionResolver;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isInternalTableFunction() {
        return this.isInternalTableFunction;
    }

    public boolean isGenericUDF() {
        return null != this.genericUDF;
    }

    public boolean isGenericUDAF() {
        return null != this.genericUDAFResolver;
    }

    public boolean isGenericUDTF() {
        return null != this.genericUDTF;
    }

    public boolean isTableFunction() {
        return null != this.tableFunctionResolver;
    }

    public boolean isBlockedFunction() {
        return this.blockedFunction;
    }

    public void setBlockedFunction(boolean blockedFunction) {
        this.blockedFunction = blockedFunction;
    }
}

