/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitDispatcher;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.calcite.util.trace.CalciteTrace;

public class RelDecorrelator
implements ReflectiveVisitor {
    private static final Logger SQL2REL_LOGGER = CalciteTrace.getSqlToRelTracer();
    private CorelMap cm;
    private final DecorrelateRelVisitor decorrelateVisitor;
    private final RexBuilder rexBuilder;
    private RelNode currentRel;
    private final Context context;
    private final Map<RelNode, RelNode> mapOldToNewRel = Maps.newHashMap();
    private final Map<RelNode, SortedMap<Correlation, Integer>> mapNewRelToMapCorVarToOutputPos = Maps.newHashMap();
    private final Map<RelNode, Map<Integer, Integer>> mapNewRelToMapOldToNewOutputPos = Maps.newHashMap();
    private final HashSet<LogicalCorrelate> generatedCorRels = Sets.newHashSet();

    private RelDecorrelator(RexBuilder rexBuilder, CorelMap cm, Context context) {
        this.cm = cm;
        this.rexBuilder = rexBuilder;
        this.context = context;
        this.decorrelateVisitor = new DecorrelateRelVisitor();
    }

    public static RelNode decorrelateQuery(RelNode rootRel) {
        CorelMap corelMap = CorelMap.build(rootRel);
        if (!corelMap.hasCorrelation()) {
            return rootRel;
        }
        RelOptCluster cluster = rootRel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDecorrelator decorrelator = new RelDecorrelator(rexBuilder, corelMap, cluster.getPlanner().getContext());
        RelNode newRootRel = decorrelator.removeCorrelationViaRule(rootRel);
        if (SQL2REL_LOGGER.isLoggable(Level.FINE)) {
            SQL2REL_LOGGER.fine(RelOptUtil.dumpPlan("Plan after removing Correlator", newRootRel, false, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        if (!decorrelator.cm.mapCorVarToCorRel.isEmpty()) {
            newRootRel = decorrelator.decorrelate(newRootRel);
        }
        return newRootRel;
    }

    private void setCurrent(RelNode root, LogicalCorrelate corRel) {
        this.currentRel = corRel;
        if (corRel != null) {
            this.cm = CorelMap.build(Util.first(root, corRel));
        }
    }

    private RelNode decorrelate(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance(new AdjustProjectForCountAggregateRule(false)).addRuleInstance(new AdjustProjectForCountAggregateRule(true)).addRuleInstance(FilterJoinRule.FILTER_ON_JOIN).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        root = planner.findBestExp();
        this.mapOldToNewRel.clear();
        this.mapNewRelToMapCorVarToOutputPos.clear();
        this.mapNewRelToMapOldToNewOutputPos.clear();
        this.decorrelateVisitor.visit(root, 0, null);
        if (this.mapOldToNewRel.containsKey(root)) {
            return this.mapOldToNewRel.get(root);
        }
        return root;
    }

    private Function2<RelNode, RelNode, Void> createCopyHook() {
        return new Function2<RelNode, RelNode, Void>(){

            public Void apply(RelNode oldNode, RelNode newNode) {
                if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey((Object)oldNode)) {
                    RelDecorrelator.this.cm.mapRefRelToCorVar.putAll((Object)newNode, (Iterable)RelDecorrelator.this.cm.mapRefRelToCorVar.get((Object)oldNode));
                }
                if (oldNode instanceof LogicalCorrelate && newNode instanceof LogicalCorrelate) {
                    LogicalCorrelate oldCor = (LogicalCorrelate)oldNode;
                    CorrelationId c = oldCor.getCorrelationId();
                    if (RelDecorrelator.this.cm.mapCorVarToCorRel.get(c) == oldNode) {
                        RelDecorrelator.this.cm.mapCorVarToCorRel.put(c, (LogicalCorrelate)newNode);
                    }
                    if (RelDecorrelator.this.generatedCorRels.contains(oldNode)) {
                        RelDecorrelator.this.generatedCorRels.add((LogicalCorrelate)newNode);
                    }
                }
                return null;
            }
        };
    }

    private HepPlanner createPlanner(HepProgram program) {
        return new HepPlanner(program, this.context, true, this.createCopyHook(), RelOptCostImpl.FACTORY);
    }

    public RelNode removeCorrelationViaRule(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance(new RemoveSingleAggregateRule()).addRuleInstance(new RemoveCorrelationForScalarProjectRule()).addRuleInstance(new RemoveCorrelationForScalarAggregateRule()).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        RelNode newRootRel = planner.findBestExp();
        return newRootRel;
    }

    protected RexNode decorrelateExpr(RexNode exp) {
        DecorrelateRexShuttle shuttle = new DecorrelateRexShuttle();
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator);
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, nullIndicator);
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, isCount);
        return exp.accept(shuttle);
    }

    public void decorrelateRelGeneric(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        if (rel.getInputs().size() > 0) {
            List<RelNode> oldInputs = rel.getInputs();
            ArrayList newInputs = Lists.newArrayList();
            for (int i = 0; i < oldInputs.size(); ++i) {
                RelNode newInputRel = this.mapOldToNewRel.get(oldInputs.get(i));
                if (newInputRel == null || this.mapNewRelToMapCorVarToOutputPos.containsKey(newInputRel)) {
                    return;
                }
                newInputs.add(newInputRel);
                newRel.replaceInput(i, newInputRel);
            }
            if (!Util.equalShallow(oldInputs, newInputs)) {
                newRel = rel.copy(rel.getTraitSet(), newInputs);
            }
        }
        HashMap mapOldToNewOutputPos = Maps.newHashMap();
        for (int i = 0; i < rel.getRowType().getFieldCount(); ++i) {
            mapOldToNewOutputPos.put(i, i);
        }
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, mapOldToNewOutputPos);
    }

    public void decorrelateRel(Sort rel) {
        assert (!this.cm.mapRefRelToCorVar.containsKey((Object)rel));
        RelNode oldChildRel = rel.getInput();
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        if (newChildRel == null) {
            return;
        }
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        Mappings.TargetMapping mapping = Mappings.target(childMapOldToNewOutputPos, oldChildRel.getRowType().getFieldCount(), newChildRel.getRowType().getFieldCount());
        RelCollation oldCollation = rel.getCollation();
        RelCollation newCollation = RexUtil.apply(mapping, oldCollation);
        LogicalSort newRel = LogicalSort.create(newChildRel, newCollation, rel.offset, rel.fetch);
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, childMapOldToNewOutputPos);
    }

    public void decorrelateRel(LogicalAggregate rel) {
        int newPos;
        if (rel.getGroupType() != Aggregate.Group.SIMPLE) {
            throw new AssertionError(false);
        }
        assert (!this.cm.mapRefRelToCorVar.containsKey((Object)rel));
        RelNode oldChildRel = rel.getInput();
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        if (newChildRel == null) {
            return;
        }
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        HashMap mapNewChildToProjOutputPos = Maps.newHashMap();
        int oldGroupKeyCount = rel.getGroupSet().cardinality();
        ArrayList projects = Lists.newArrayList();
        List<RelDataTypeField> newChildOutput = newChildRel.getRowType().getFieldList();
        for (newPos = 0; newPos < oldGroupKeyCount; ++newPos) {
            int newChildPos = childMapOldToNewOutputPos.get(newPos);
            projects.add(RexInputRef.of2(newChildPos, newChildOutput));
            mapNewChildToProjOutputPos.put(newChildPos, newPos);
        }
        TreeMap mapCorVarToOutputPos = Maps.newTreeMap();
        boolean produceCorVar = this.mapNewRelToMapCorVarToOutputPos.containsKey(newChildRel);
        if (produceCorVar) {
            SortedMap<Correlation, Integer> childMapCorVarToOutputPos = this.mapNewRelToMapCorVarToOutputPos.get(newChildRel);
            for (Correlation corVar : childMapCorVarToOutputPos.keySet()) {
                int newChildPos = (Integer)childMapCorVarToOutputPos.get(corVar);
                projects.add(RexInputRef.of2(newChildPos, newChildOutput));
                mapCorVarToOutputPos.put(corVar, newPos);
                mapNewChildToProjOutputPos.put(newChildPos, newPos);
                ++newPos;
            }
        }
        int newGroupKeyCount = newPos;
        for (int i = 0; i < newChildOutput.size(); ++i) {
            if (mapNewChildToProjOutputPos.containsKey(i)) continue;
            projects.add(RexInputRef.of2(i, newChildOutput));
            mapNewChildToProjOutputPos.put(i, newPos);
            ++newPos;
        }
        assert (newPos == newChildOutput.size());
        RelNode newProjectRel = RelOptUtil.createProject(newChildRel, projects, false);
        HashMap combinedMap = Maps.newHashMap();
        for (Integer oldChildPos : childMapOldToNewOutputPos.keySet()) {
            combinedMap.put(oldChildPos, mapNewChildToProjOutputPos.get(childMapOldToNewOutputPos.get(oldChildPos)));
        }
        this.mapOldToNewRel.put(oldChildRel, newProjectRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newProjectRel, combinedMap);
        if (produceCorVar) {
            this.mapNewRelToMapCorVarToOutputPos.put(newProjectRel, mapCorVarToOutputPos);
        }
        ArrayList newAggCalls = Lists.newArrayList();
        List<AggregateCall> oldAggCalls = rel.getAggCallList();
        int oldChildOutputFieldCount = oldChildRel.getRowType().getFieldCount();
        int newChildOutputFieldCount = newProjectRel.getRowType().getFieldCount();
        int i = -1;
        for (AggregateCall oldAggCall : oldAggCalls) {
            ++i;
            List<Integer> oldAggArgs = oldAggCall.getArgList();
            ArrayList aggArgs = Lists.newArrayList();
            for (int oldPos : oldAggArgs) {
                aggArgs.add(combinedMap.get(oldPos));
            }
            int filterArg = oldAggCall.filterArg < 0 ? oldAggCall.filterArg : (Integer)combinedMap.get(oldAggCall.filterArg);
            newAggCalls.add(oldAggCall.adaptTo(newProjectRel, aggArgs, filterArg, oldGroupKeyCount, newGroupKeyCount));
            combinedMap.put(oldChildOutputFieldCount + i, newChildOutputFieldCount + i);
        }
        LogicalAggregate newAggregate = LogicalAggregate.create(newProjectRel, false, ImmutableBitSet.range(newGroupKeyCount), null, newAggCalls);
        this.mapOldToNewRel.put(rel, newAggregate);
        this.mapNewRelToMapOldToNewOutputPos.put(newAggregate, combinedMap);
        if (produceCorVar) {
            this.mapNewRelToMapCorVarToOutputPos.put(newAggregate, mapCorVarToOutputPos);
        }
    }

    public void decorrelateRel(LogicalProject rel) {
        int newPos;
        RelNode oldChildRel = rel.getInput();
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        if (newChildRel == null) {
            return;
        }
        List<RexNode> oldProj = rel.getProjects();
        List<RelDataTypeField> relOutput = rel.getRowType().getFieldList();
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        HashMap mapOldToNewOutputPos = Maps.newHashMap();
        boolean produceCorVar = this.mapNewRelToMapCorVarToOutputPos.containsKey(newChildRel);
        ArrayList projects = Lists.newArrayList();
        if (this.cm.mapRefRelToCorVar.containsKey((Object)rel)) {
            this.decorrelateInputWithValueGenerator(rel);
            newChildRel = this.mapOldToNewRel.get(oldChildRel);
            produceCorVar = true;
        }
        for (newPos = 0; newPos < oldProj.size(); ++newPos) {
            projects.add(newPos, Pair.of(this.decorrelateExpr(oldProj.get(newPos)), relOutput.get(newPos).getName()));
            mapOldToNewOutputPos.put(newPos, newPos);
        }
        TreeMap mapCorVarToOutputPos = Maps.newTreeMap();
        if (produceCorVar) {
            SortedMap<Correlation, Integer> childMapCorVarToOutputPos = this.mapNewRelToMapCorVarToOutputPos.get(newChildRel);
            List<RelDataTypeField> newChildOutput = newChildRel.getRowType().getFieldList();
            for (Correlation corVar : childMapCorVarToOutputPos.keySet()) {
                int corVarPos = (Integer)childMapCorVarToOutputPos.get(corVar);
                projects.add(RexInputRef.of2(corVarPos, newChildOutput));
                mapCorVarToOutputPos.put(corVar, newPos);
                ++newPos;
            }
        }
        RelNode newProjectRel = RelOptUtil.createProject(newChildRel, projects, false);
        this.mapOldToNewRel.put(rel, newProjectRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newProjectRel, mapOldToNewOutputPos);
        if (produceCorVar) {
            this.mapNewRelToMapCorVarToOutputPos.put(newProjectRel, mapCorVarToOutputPos);
        }
    }

    private RelNode createValueGenerator(Iterable<Correlation> correlations, int valueGenFieldOffset, SortedMap<Correlation, Integer> mapCorVarToOutputPos) {
        List newLocalOutputPosList;
        RelNode newInputRel;
        RelNode oldInputRel;
        RelNode resultRel = null;
        HashMap mapNewInputRelToOutputPos = Maps.newHashMap();
        HashMap mapNewInputRelToNewOffset = Maps.newHashMap();
        for (Correlation corVar : correlations) {
            int oldCorVarOffset = corVar.field;
            oldInputRel = ((LogicalCorrelate)this.cm.mapCorVarToCorRel.get(corVar.corr)).getInput(0);
            assert (oldInputRel != null);
            newInputRel = this.mapOldToNewRel.get(oldInputRel);
            assert (newInputRel != null);
            newLocalOutputPosList = !mapNewInputRelToOutputPos.containsKey(newInputRel) ? Lists.newArrayList() : (List)mapNewInputRelToOutputPos.get(newInputRel);
            Map<Integer, Integer> mapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newInputRel);
            assert (mapOldToNewOutputPos != null);
            int newCorVarOffset = mapOldToNewOutputPos.get(oldCorVarOffset);
            if (!newLocalOutputPosList.contains(newCorVarOffset)) {
                newLocalOutputPosList.add(newCorVarOffset);
            }
            mapNewInputRelToOutputPos.put(newInputRel, newLocalOutputPosList);
        }
        int offset = 0;
        HashSet joinedInputRelSet = Sets.newHashSet();
        for (Correlation corVar : correlations) {
            oldInputRel = ((LogicalCorrelate)this.cm.mapCorVarToCorRel.get(corVar.corr)).getInput(0);
            assert (oldInputRel != null);
            newInputRel = this.mapOldToNewRel.get(oldInputRel);
            assert (newInputRel != null);
            if (joinedInputRelSet.contains(newInputRel)) continue;
            RelNode projectRel = RelOptUtil.createProject(newInputRel, (List)mapNewInputRelToOutputPos.get(newInputRel));
            RelNode distinctRel = RelOptUtil.createDistinctRel(projectRel);
            RelOptCluster cluster = distinctRel.getCluster();
            joinedInputRelSet.add(newInputRel);
            mapNewInputRelToNewOffset.put(newInputRel, offset);
            offset += distinctRel.getRowType().getFieldCount();
            if (resultRel == null) {
                resultRel = distinctRel;
                continue;
            }
            resultRel = LogicalJoin.create(resultRel, distinctRel, cluster.getRexBuilder().makeLiteral(true), JoinRelType.INNER, (Set<String>)ImmutableSet.of());
        }
        for (Correlation corVar : correlations) {
            newInputRel = this.mapOldToNewRel.get(((LogicalCorrelate)this.cm.mapCorVarToCorRel.get(corVar.corr)).getInput(0));
            newLocalOutputPosList = (List)mapNewInputRelToOutputPos.get(newInputRel);
            Map<Integer, Integer> mapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newInputRel);
            assert (mapOldToNewOutputPos != null);
            int newLocalOutputPos = mapOldToNewOutputPos.get(corVar.field);
            int newOutputPos = newLocalOutputPosList.indexOf(newLocalOutputPos) + (Integer)mapNewInputRelToNewOffset.get(newInputRel) + valueGenFieldOffset;
            if (mapCorVarToOutputPos.containsKey(corVar)) assert ((Integer)mapCorVarToOutputPos.get(corVar) == newOutputPos);
            mapCorVarToOutputPos.put(corVar, newOutputPos);
        }
        return resultRel;
    }

    private void decorrelateInputWithValueGenerator(RelNode rel) {
        assert (rel.getInputs().size() == 1);
        RelNode oldChildRel = rel.getInput(0);
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        TreeMap mapCorVarToOutputPos = Maps.newTreeMap();
        if (this.mapNewRelToMapCorVarToOutputPos.containsKey(newChildRel)) {
            mapCorVarToOutputPos.putAll((Map)this.mapNewRelToMapCorVarToOutputPos.get(newChildRel));
        }
        Collection corVarList = this.cm.mapRefRelToCorVar.get((Object)rel);
        RelNode newLeftChildRel = newChildRel;
        int leftChildOutputCount = newLeftChildRel.getRowType().getFieldCount();
        RelNode valueGenRel = this.createValueGenerator(corVarList, leftChildOutputCount, mapCorVarToOutputPos);
        Set<String> variablesStopped = Collections.emptySet();
        LogicalJoin joinRel = LogicalJoin.create(newLeftChildRel, valueGenRel, this.rexBuilder.makeLiteral(true), JoinRelType.INNER, variablesStopped);
        this.mapOldToNewRel.put(oldChildRel, joinRel);
        this.mapNewRelToMapCorVarToOutputPos.put(joinRel, mapCorVarToOutputPos);
        this.mapNewRelToMapOldToNewOutputPos.put(joinRel, childMapOldToNewOutputPos);
    }

    public void decorrelateRel(LogicalFilter rel) {
        RelNode oldChildRel = rel.getInput();
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        if (newChildRel == null) {
            return;
        }
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        boolean produceCorVar = this.mapNewRelToMapCorVarToOutputPos.containsKey(newChildRel);
        if (this.cm.mapRefRelToCorVar.containsKey((Object)rel)) {
            this.decorrelateInputWithValueGenerator(rel);
            newChildRel = this.mapOldToNewRel.get(oldChildRel);
            produceCorVar = true;
        }
        RelNode newFilterRel = RelOptUtil.createFilter(newChildRel, this.decorrelateExpr(rel.getCondition()));
        this.mapOldToNewRel.put(rel, newFilterRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newFilterRel, childMapOldToNewOutputPos);
        if (produceCorVar) {
            this.mapNewRelToMapCorVarToOutputPos.put(newFilterRel, this.mapNewRelToMapCorVarToOutputPos.get(newChildRel));
        }
    }

    public void decorrelateRel(LogicalCorrelate rel) {
        RelNode oldLeftRel = rel.getInputs().get(0);
        RelNode oldRightRel = rel.getInputs().get(1);
        RelNode newLeftRel = this.mapOldToNewRel.get(oldLeftRel);
        RelNode newRightRel = this.mapOldToNewRel.get(oldRightRel);
        if (newLeftRel == null || newRightRel == null) {
            return;
        }
        SortedMap<Correlation, Integer> rightChildMapCorVarToOutputPos = this.mapNewRelToMapCorVarToOutputPos.get(newRightRel);
        if (rightChildMapCorVarToOutputPos == null) {
            return;
        }
        Map<Integer, Integer> leftChildMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newLeftRel);
        assert (leftChildMapOldToNewOutputPos != null);
        Map<Integer, Integer> rightChildMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newRightRel);
        assert (rightChildMapOldToNewOutputPos != null);
        SortedMap<Correlation, Integer> mapCorVarToOutputPos = rightChildMapCorVarToOutputPos;
        assert (rel.getRequiredColumns().cardinality() <= rightChildMapCorVarToOutputPos.keySet().size());
        RexNode condition = this.rexBuilder.makeLiteral(true);
        List<RelDataTypeField> newLeftOutput = newLeftRel.getRowType().getFieldList();
        int newLeftFieldCount = newLeftOutput.size();
        List<RelDataTypeField> newRightOutput = newRightRel.getRowType().getFieldList();
        for (Map.Entry rightOutputPos : Lists.newArrayList(rightChildMapCorVarToOutputPos.entrySet())) {
            Correlation corVar = (Correlation)rightOutputPos.getKey();
            if (!corVar.corr.equals(rel.getCorrelationId())) continue;
            int newLeftPos = leftChildMapOldToNewOutputPos.get(corVar.field);
            int newRightPos = (Integer)rightChildMapCorVarToOutputPos.get(corVar);
            RexNode equi = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, RexInputRef.of(newLeftPos, newLeftOutput), new RexInputRef(newLeftFieldCount + newRightPos, newRightOutput.get(newRightPos).getType()));
            condition = condition == this.rexBuilder.makeLiteral(true) ? equi : this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, condition, equi);
            mapCorVarToOutputPos.remove(corVar);
        }
        for (Correlation corVar : mapCorVarToOutputPos.keySet()) {
            int newPos = (Integer)mapCorVarToOutputPos.get(corVar) + newLeftFieldCount;
            mapCorVarToOutputPos.put(corVar, newPos);
        }
        if (this.mapNewRelToMapCorVarToOutputPos.containsKey(newLeftRel)) {
            mapCorVarToOutputPos.putAll((Map<Correlation, Integer>)this.mapNewRelToMapCorVarToOutputPos.get(newLeftRel));
        }
        HashMap mapOldToNewOutputPos = Maps.newHashMap();
        int oldLeftFieldCount = oldLeftRel.getRowType().getFieldCount();
        int oldRightFieldCount = oldRightRel.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputPos.putAll(leftChildMapOldToNewOutputPos);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputPos.put(i + oldLeftFieldCount, rightChildMapOldToNewOutputPos.get(i) + newLeftFieldCount);
        }
        Set<String> variablesStopped = Collections.emptySet();
        LogicalJoin newRel = LogicalJoin.create(newLeftRel, newRightRel, condition, rel.getJoinType().toJoinType(), variablesStopped);
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, mapOldToNewOutputPos);
        if (!mapCorVarToOutputPos.isEmpty()) {
            this.mapNewRelToMapCorVarToOutputPos.put(newRel, mapCorVarToOutputPos);
        }
    }

    public void decorrelateRel(LogicalJoin rel) {
        RelNode oldLeftRel = rel.getInputs().get(0);
        RelNode oldRightRel = rel.getInputs().get(1);
        RelNode newLeftRel = this.mapOldToNewRel.get(oldLeftRel);
        RelNode newRightRel = this.mapOldToNewRel.get(oldRightRel);
        if (newLeftRel == null || newRightRel == null) {
            return;
        }
        Map<Integer, Integer> leftChildMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newLeftRel);
        assert (leftChildMapOldToNewOutputPos != null);
        Map<Integer, Integer> rightChildMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newRightRel);
        assert (rightChildMapOldToNewOutputPos != null);
        TreeMap mapCorVarToOutputPos = Maps.newTreeMap();
        Set<String> variablesStopped = Collections.emptySet();
        LogicalJoin newRel = LogicalJoin.create(newLeftRel, newRightRel, this.decorrelateExpr(rel.getCondition()), rel.getJoinType(), variablesStopped);
        HashMap mapOldToNewOutputPos = Maps.newHashMap();
        int oldLeftFieldCount = oldLeftRel.getRowType().getFieldCount();
        int newLeftFieldCount = newLeftRel.getRowType().getFieldCount();
        int oldRightFieldCount = oldRightRel.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputPos.putAll(leftChildMapOldToNewOutputPos);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputPos.put(i + oldLeftFieldCount, rightChildMapOldToNewOutputPos.get(i) + newLeftFieldCount);
        }
        if (this.mapNewRelToMapCorVarToOutputPos.containsKey(newLeftRel)) {
            mapCorVarToOutputPos.putAll((Map)this.mapNewRelToMapCorVarToOutputPos.get(newLeftRel));
        }
        if (this.mapNewRelToMapCorVarToOutputPos.containsKey(newRightRel)) {
            SortedMap<Correlation, Integer> rightChildMapCorVarToOutputPos = this.mapNewRelToMapCorVarToOutputPos.get(newRightRel);
            for (Correlation corVar : rightChildMapCorVarToOutputPos.keySet()) {
                int oldRightPos = (Integer)rightChildMapCorVarToOutputPos.get(corVar);
                mapCorVarToOutputPos.put(corVar, oldRightPos + newLeftFieldCount);
            }
        }
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, mapOldToNewOutputPos);
        if (!mapCorVarToOutputPos.isEmpty()) {
            this.mapNewRelToMapCorVarToOutputPos.put(newRel, mapCorVarToOutputPos);
        }
    }

    private RexInputRef getNewForOldInputRef(RexInputRef oldInputRef) {
        int oldLocalOrdinal;
        assert (this.currentRel != null);
        int oldOrdinal = oldInputRef.getIndex();
        int newOrdinal = 0;
        List<RelNode> oldInputRels = this.currentRel.getInputs();
        RelNode oldInputRel = null;
        for (RelNode oldInputRel0 : oldInputRels) {
            RelDataType oldInputType = oldInputRel0.getRowType();
            int n = oldInputType.getFieldCount();
            if (oldOrdinal < n) {
                oldInputRel = oldInputRel0;
                break;
            }
            RelNode newInput = this.mapOldToNewRel.get(oldInputRel0);
            newOrdinal += newInput.getRowType().getFieldCount();
            oldOrdinal -= n;
        }
        assert (oldInputRel != null);
        RelNode newInputRel = this.mapOldToNewRel.get(oldInputRel);
        assert (newInputRel != null);
        int newLocalOrdinal = oldLocalOrdinal = oldOrdinal;
        Map<Integer, Integer> mapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newInputRel);
        if (mapOldToNewOutputPos != null) {
            newLocalOrdinal = mapOldToNewOutputPos.get(oldLocalOrdinal);
        }
        return new RexInputRef(newOrdinal += newLocalOrdinal, newInputRel.getRowType().getFieldList().get(newLocalOrdinal).getType());
    }

    private RelNode projectJoinOutputWithNullability(LogicalJoin join, LogicalProject projRel, int nullIndicatorPos) {
        RelDataTypeFactory typeFactory = join.getCluster().getTypeFactory();
        RelNode leftInputRel = join.getLeft();
        JoinRelType joinType = join.getJoinType();
        RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, typeFactory.createTypeWithNullability(join.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
        ArrayList newProjExprs = Lists.newArrayList();
        List<RelDataTypeField> leftInputFields = leftInputRel.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjExprs.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : projRel.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, nullIndicator);
            newProjExprs.add(Pair.of(newProjExpr, pair.right));
        }
        RelNode newProjRel = RelOptUtil.createProject((RelNode)join, newProjExprs, false);
        return newProjRel;
    }

    private RelNode aggregateCorrelatorOutput(LogicalCorrelate corRel, LogicalProject projRel, Set<Integer> isCount) {
        RelNode leftInputRel = corRel.getLeft();
        JoinRelType joinType = corRel.getJoinType().toJoinType();
        ArrayList newProjects = Lists.newArrayList();
        List<RelDataTypeField> leftInputFields = leftInputRel.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjects.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : projRel.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, isCount);
            newProjects.add(Pair.of(newProjExpr, pair.right));
        }
        return RelOptUtil.createProject((RelNode)corRel, newProjects, false);
    }

    private boolean checkCorVars(LogicalCorrelate corRel, LogicalProject projRel, LogicalFilter filter, List<RexFieldAccess> correlatedJoinKeys) {
        if (filter != null) {
            assert (correlatedJoinKeys != null);
            HashSet corVarInFilter = Sets.newHashSet((Iterable)this.cm.mapRefRelToCorVar.get((Object)filter));
            for (RexFieldAccess correlatedJoinKey : correlatedJoinKeys) {
                corVarInFilter.remove(this.cm.mapFieldAccessToCorVar.get(correlatedJoinKey));
            }
            if (!corVarInFilter.isEmpty()) {
                return false;
            }
            corVarInFilter.addAll(this.cm.mapRefRelToCorVar.get((Object)filter));
            for (Correlation corVar : corVarInFilter) {
                if (this.cm.mapCorVarToCorRel.get(corVar.corr) == corRel) continue;
                return false;
            }
        }
        if (projRel != null && this.cm.mapRefRelToCorVar.containsKey((Object)projRel)) {
            for (Correlation corVar : this.cm.mapRefRelToCorVar.get((Object)projRel)) {
                if (this.cm.mapCorVarToCorRel.get(corVar.corr) == corRel) continue;
                return false;
            }
        }
        return true;
    }

    private void removeCorVarFromTree(LogicalCorrelate corRel) {
        if (this.cm.mapCorVarToCorRel.get(corRel.getCorrelationId()) == corRel) {
            this.cm.mapCorVarToCorRel.remove(corRel.getCorrelationId());
        }
    }

    private RelNode createProjectWithAdditionalExprs(RelNode childRel, List<Pair<RexNode, String>> additionalExprs) {
        List<RelDataTypeField> fieldList = childRel.getRowType().getFieldList();
        ArrayList projects = Lists.newArrayList();
        for (Ord field : Ord.zip(fieldList)) {
            projects.add(Pair.of(this.rexBuilder.makeInputRef(((RelDataTypeField)field.e).getType(), field.i), ((RelDataTypeField)field.e).getName()));
        }
        projects.addAll(additionalExprs);
        return RelOptUtil.createProject(childRel, projects, false);
    }

    private static class CorelMap {
        private final Multimap<RelNode, Correlation> mapRefRelToCorVar;
        private final SortedMap<CorrelationId, LogicalCorrelate> mapCorVarToCorRel;
        private final Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar;

        private CorelMap(Multimap<RelNode, Correlation> mapRefRelToCorVar, SortedMap<CorrelationId, LogicalCorrelate> mapCorVarToCorRel, Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar) {
            this.mapRefRelToCorVar = mapRefRelToCorVar;
            this.mapCorVarToCorRel = mapCorVarToCorRel;
            this.mapFieldAccessToCorVar = mapFieldAccessToCorVar;
        }

        public String toString() {
            return "mapRefRelToCorVar=" + this.mapRefRelToCorVar + "\nmapCorVarToCorRel=" + this.mapCorVarToCorRel + "\nmapFieldAccessToCorVar=" + this.mapFieldAccessToCorVar + "\n";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CorelMap && this.mapRefRelToCorVar.equals(((CorelMap)obj).mapRefRelToCorVar) && this.mapCorVarToCorRel.equals(((CorelMap)obj).mapCorVarToCorRel) && this.mapFieldAccessToCorVar.equals(((CorelMap)obj).mapFieldAccessToCorVar);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mapRefRelToCorVar, this.mapCorVarToCorRel, this.mapFieldAccessToCorVar});
        }

        public static CorelMap of(SortedSetMultimap<RelNode, Correlation> mapRefRelToCorVar, SortedMap<CorrelationId, LogicalCorrelate> mapCorVarToCorRel, Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar) {
            return new CorelMap((Multimap<RelNode, Correlation>)mapRefRelToCorVar, mapCorVarToCorRel, mapFieldAccessToCorVar);
        }

        public static CorelMap build(RelNode rel) {
            final TreeMap<CorrelationId, LogicalCorrelate> mapCorVarToCorRel = new TreeMap<CorrelationId, LogicalCorrelate>();
            final SortedSetMultimap mapRefRelToCorVar = Multimaps.newSortedSetMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<TreeSet<Correlation>>(){

                public TreeSet<Correlation> get() {
                    Bug.upgrade("use MultimapBuilder when we're on Guava-16");
                    return Sets.newTreeSet();
                }
            });
            final HashMap<RexFieldAccess, Correlation> mapFieldAccessToCorVar = new HashMap<RexFieldAccess, Correlation>();
            final Holder<Integer> offset = Holder.of(0);
            final int[] corrIdGenerator = new int[1];
            RelShuttleImpl shuttle = new RelShuttleImpl(){

                @Override
                public RelNode visit(LogicalJoin join) {
                    join.getCondition().accept(this.rexVisitor(join));
                    return this.visitJoin(join);
                }

                @Override
                protected RelNode visitChild(RelNode parent, int i, RelNode child) {
                    return super.visitChild(parent, i, CorelMap.stripHep(child));
                }

                @Override
                public RelNode visit(LogicalCorrelate correlate) {
                    mapCorVarToCorRel.put(correlate.getCorrelationId(), correlate);
                    return this.visitJoin(correlate);
                }

                private RelNode visitJoin(BiRel join) {
                    int x = (Integer)offset.get();
                    this.visitChild(join, 0, join.getLeft());
                    offset.set(x + join.getLeft().getRowType().getFieldCount());
                    this.visitChild(join, 1, join.getRight());
                    offset.set(x);
                    return join;
                }

                @Override
                public RelNode visit(LogicalFilter filter) {
                    filter.getCondition().accept(this.rexVisitor(filter));
                    return super.visit(filter);
                }

                @Override
                public RelNode visit(LogicalProject project) {
                    for (RexNode node : project.getProjects()) {
                        node.accept(this.rexVisitor(project));
                    }
                    return super.visit(project);
                }

                private RexVisitorImpl<Void> rexVisitor(final RelNode rel) {
                    return new RexVisitorImpl<Void>(true){

                        @Override
                        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                            RexNode ref = fieldAccess.getReferenceExpr();
                            if (ref instanceof RexCorrelVariable) {
                                RexCorrelVariable var = (RexCorrelVariable)ref;
                                int n = corrIdGenerator[0];
                                corrIdGenerator[0] = n + 1;
                                Correlation correlation = new Correlation(new CorrelationId(var.getName()), fieldAccess.getField().getIndex(), n);
                                mapFieldAccessToCorVar.put(fieldAccess, correlation);
                                mapRefRelToCorVar.put((Object)rel, (Object)correlation);
                            }
                            return (Void)super.visitFieldAccess(fieldAccess);
                        }
                    };
                }
            };
            CorelMap.stripHep(rel).accept(shuttle);
            return new CorelMap((Multimap<RelNode, Correlation>)mapRefRelToCorVar, mapCorVarToCorRel, mapFieldAccessToCorVar);
        }

        private static RelNode stripHep(RelNode rel) {
            if (rel instanceof HepRelVertex) {
                HepRelVertex hepRelVertex = (HepRelVertex)rel;
                rel = hepRelVertex.getCurrentRel();
            }
            return rel;
        }

        public boolean hasCorrelation() {
            return !this.mapCorVarToCorRel.isEmpty();
        }
    }

    static class Correlation
    implements Comparable<Correlation> {
        public final int uniqueKey;
        public final CorrelationId corr;
        public final int field;

        Correlation(CorrelationId corr, int field, int uniqueKey) {
            this.corr = corr;
            this.field = field;
            this.uniqueKey = uniqueKey;
        }

        @Override
        public int compareTo(Correlation o) {
            int res = this.corr.compareTo(o.corr);
            if (res != 0) {
                return res;
            }
            if (this.field != o.field) {
                return this.field - o.field;
            }
            return this.uniqueKey - o.uniqueKey;
        }
    }

    private final class AdjustProjectForCountAggregateRule
    extends RelOptRule {
        final boolean flavor;

        public AdjustProjectForCountAggregateRule(boolean flavor) {
            super(flavor ? AdjustProjectForCountAggregateRule.operand(LogicalCorrelate.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(LogicalProject.class, AdjustProjectForCountAggregateRule.operand(LogicalAggregate.class, AdjustProjectForCountAggregateRule.any()), new RelOptRuleOperand[0])) : AdjustProjectForCountAggregateRule.operand(LogicalCorrelate.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(LogicalAggregate.class, AdjustProjectForCountAggregateRule.any())));
            this.flavor = flavor;
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalAggregate aggRel;
            LogicalProject aggOutputProjRel;
            LogicalCorrelate corRel = (LogicalCorrelate)call.rel(0);
            Object leftInputRel = call.rel(1);
            if (this.flavor) {
                aggOutputProjRel = (LogicalProject)call.rel(2);
                aggRel = (LogicalAggregate)call.rel(3);
            } else {
                aggRel = (LogicalAggregate)call.rel(2);
                ArrayList projects = Lists.newArrayList();
                List<RelDataTypeField> fields = aggRel.getRowType().getFieldList();
                for (int i = 0; i < fields.size(); ++i) {
                    projects.add(RexInputRef.of2(projects.size(), fields));
                }
                aggOutputProjRel = (LogicalProject)RelOptUtil.createProject((RelNode)aggRel, projects, false);
            }
            this.onMatch2(call, corRel, (RelNode)leftInputRel, aggOutputProjRel, aggRel);
        }

        private void onMatch2(RelOptRuleCall call, LogicalCorrelate corRel, RelNode leftInputRel, LogicalProject aggOutputProjRel, LogicalAggregate aggRel) {
            RelOptCluster cluster = corRel.getCluster();
            if (RelDecorrelator.this.generatedCorRels.contains(corRel)) {
                return;
            }
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), corRel);
            List<RexNode> aggOutputProjExprs = aggOutputProjRel.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            JoinRelType joinType = corRel.getJoinType().toJoinType();
            RexLiteral joinCond = RelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            List<AggregateCall> aggCalls = aggRel.getAggCallList();
            HashSet isCount = Sets.newHashSet();
            int i = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++i;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction)) continue;
                isCount.add(i);
            }
            LogicalCorrelate newCorRel = LogicalCorrelate.create(leftInputRel, aggRel, corRel.getCorrelationId(), corRel.getRequiredColumns(), corRel.getJoinType());
            RelDecorrelator.this.generatedCorRels.add(newCorRel);
            if (RelDecorrelator.this.cm.mapCorVarToCorRel.get(corRel.getCorrelationId()) == corRel) {
                RelDecorrelator.this.cm.mapCorVarToCorRel.put(corRel.getCorrelationId(), newCorRel);
            }
            RelNode newOutputRel = RelDecorrelator.this.aggregateCorrelatorOutput(newCorRel, aggOutputProjRel, isCount);
            call.transformTo(newOutputRel);
        }
    }

    private final class RemoveCorrelationForScalarAggregateRule
    extends RelOptRule {
        public RemoveCorrelationForScalarAggregateRule() {
            super(RemoveCorrelationForScalarAggregateRule.operand(LogicalCorrelate.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), RemoveCorrelationForScalarAggregateRule.operand(LogicalProject.class, RemoveCorrelationForScalarAggregateRule.operand(LogicalAggregate.class, null, Aggregate.IS_SIMPLE, RemoveCorrelationForScalarAggregateRule.operand(LogicalProject.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalCorrelate corRel = (LogicalCorrelate)call.rel(0);
            Object leftInputRel = call.rel(1);
            LogicalProject aggOutputProjRel = (LogicalProject)call.rel(2);
            LogicalAggregate aggRel = (LogicalAggregate)call.rel(3);
            LogicalProject aggInputProjRel = (LogicalProject)call.rel(4);
            Object rightInputRel = call.rel(5);
            RelOptCluster cluster = corRel.getCluster();
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), corRel);
            List<RexNode> aggOutputProjExprs = aggOutputProjRel.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            JoinRelType joinType = corRel.getJoinType().toJoinType();
            RexNode joinCond = RelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            List<RexNode> aggInputProjExprs = aggInputProjRel.getProjects();
            List<AggregateCall> aggCalls = aggRel.getAggCallList();
            HashSet isCountStar = Sets.newHashSet();
            int k = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++k;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction) || aggCall.getArgList().size() != 0) continue;
                isCountStar.add(k);
            }
            if (rightInputRel instanceof LogicalFilter && RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(rightInputRel)) {
                LogicalFilter filter = (LogicalFilter)rightInputRel;
                rightInputRel = filter.getInput();
                assert (rightInputRel instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(rightInputRel = ((HepRelVertex)rightInputRel).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList rightJoinKeys = Lists.newArrayList();
                ArrayList tmpCorrelatedJoinKeys = Lists.newArrayList();
                RelOptUtil.splitCorrelatedFilterCondition(filter, rightJoinKeys, tmpCorrelatedJoinKeys, true);
                ArrayList correlatedJoinKeys = Lists.newArrayList();
                ArrayList correlatedInputRefJoinKeys = Lists.newArrayList();
                for (RexNode joinKey : tmpCorrelatedJoinKeys) {
                    assert (joinKey instanceof RexFieldAccess);
                    correlatedJoinKeys.add((RexFieldAccess)joinKey);
                    RexNode correlatedInputRef = RelDecorrelator.this.removeCorrelationExpr(joinKey, false);
                    assert (correlatedInputRef instanceof RexInputRef);
                    correlatedInputRefJoinKeys.add((RexInputRef)correlatedInputRef);
                }
                if (correlatedInputRefJoinKeys.isEmpty()) {
                    return;
                }
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(leftInputRel, correlatedInputRefJoinKeys)) {
                    SQL2REL_LOGGER.fine(((Object)correlatedJoinKeys).toString() + "are not unique keys for " + leftInputRel.toString());
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, aggInputProjRel, filter, correlatedJoinKeys)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filter.getCondition(), false);
            } else if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey((Object)aggInputProjRel)) {
                if (RelOptUtil.getVariablesUsed(rightInputRel).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, aggInputProjRel, null, null)) {
                    return;
                }
                int nFields = leftInputRel.getRowType().getFieldCount();
                ImmutableBitSet allCols = ImmutableBitSet.range(nFields);
                if (!RelMdUtil.areColumnsDefinitelyUnique(leftInputRel, allCols)) {
                    SQL2REL_LOGGER.fine("There are no unique keys for " + leftInputRel);
                    return;
                }
            } else {
                return;
            }
            RelDataType leftInputFieldType = leftInputRel.getRowType();
            int leftInputFieldCount = leftInputFieldType.getFieldCount();
            int joinOutputProjExprCount = leftInputFieldCount + aggInputProjExprs.size() + 1;
            rightInputRel = RelDecorrelator.this.createProjectWithAdditionalExprs(rightInputRel, (List)ImmutableList.of(Pair.of(RelDecorrelator.this.rexBuilder.makeLiteral(true), "nullIndicator")));
            LogicalJoin join = LogicalJoin.create(leftInputRel, rightInputRel, joinCond, joinType, (Set<String>)ImmutableSet.of());
            int nullIndicatorPos = join.getRowType().getFieldCount() - 1;
            RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, cluster.getTypeFactory().createTypeWithNullability(join.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
            ArrayList joinOutputProjExprs = Lists.newArrayList();
            for (int i = 0; i < leftInputFieldCount; ++i) {
                joinOutputProjExprs.add(RelDecorrelator.this.rexBuilder.makeInputRef(leftInputFieldType.getFieldList().get(i).getType(), i));
            }
            for (RexNode aggInputProjExpr : aggInputProjExprs) {
                joinOutputProjExprs.add(RelDecorrelator.this.removeCorrelationExpr(aggInputProjExpr, joinType.generatesNullsOnRight(), nullIndicator));
            }
            joinOutputProjExprs.add(RelDecorrelator.this.rexBuilder.makeInputRef(join, nullIndicatorPos));
            RelNode joinOutputProjRel = RelOptUtil.createProject((RelNode)join, joinOutputProjExprs, null);
            nullIndicatorPos = joinOutputProjExprCount - 1;
            int groupCount = leftInputFieldCount;
            ArrayList newAggCalls = Lists.newArrayList();
            k = -1;
            for (AggregateCall aggCall : aggCalls) {
                List<Object> argList;
                if (isCountStar.contains(++k)) {
                    argList = Collections.singletonList(nullIndicatorPos);
                } else {
                    argList = Lists.newArrayList();
                    for (Integer aggArg : aggCall.getArgList()) {
                        argList.add(aggArg + groupCount);
                    }
                }
                int filterArg = aggCall.filterArg < 0 ? aggCall.filterArg : aggCall.filterArg + groupCount;
                newAggCalls.add(aggCall.adaptTo(joinOutputProjRel, argList, filterArg, aggRel.getGroupCount(), groupCount));
            }
            ImmutableBitSet groupSet = ImmutableBitSet.range(groupCount);
            LogicalAggregate newAggRel = LogicalAggregate.create(joinOutputProjRel, false, groupSet, null, newAggCalls);
            ArrayList newAggOutputProjExprList = Lists.newArrayList();
            for (int i : groupSet) {
                newAggOutputProjExprList.add(RelDecorrelator.this.rexBuilder.makeInputRef(newAggRel, i));
            }
            RexNode newAggOutputProjExpr = RelDecorrelator.this.removeCorrelationExpr(aggOutputProjExprs.get(0), false);
            newAggOutputProjExprList.add(RelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(newAggOutputProjExpr.getType(), true), newAggOutputProjExpr));
            RelNode newAggOutputProjRel = RelOptUtil.createProject((RelNode)newAggRel, newAggOutputProjExprList, null);
            call.transformTo(newAggOutputProjRel);
            RelDecorrelator.this.removeCorVarFromTree(corRel);
        }
    }

    private final class RemoveCorrelationForScalarProjectRule
    extends RelOptRule {
        public RemoveCorrelationForScalarProjectRule() {
            super(RemoveCorrelationForScalarProjectRule.operand(LogicalCorrelate.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), RemoveCorrelationForScalarProjectRule.operand(LogicalAggregate.class, RemoveCorrelationForScalarProjectRule.operand(LogicalProject.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            int nullIndicatorPos;
            LogicalCorrelate corRel = (LogicalCorrelate)call.rel(0);
            Object leftInputRel = call.rel(1);
            LogicalAggregate aggRel = (LogicalAggregate)call.rel(2);
            LogicalProject projRel = (LogicalProject)call.rel(3);
            Object rightInputRel = call.rel(4);
            RelOptCluster cluster = corRel.getCluster();
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), corRel);
            JoinRelType joinType = corRel.getJoinType().toJoinType();
            RexNode joinCond = RelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty() || aggRel.getAggCallList().size() != 1 || !(aggRel.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            if (projRel.getProjects().size() != 1) {
                return;
            }
            if (rightInputRel instanceof LogicalFilter && RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(rightInputRel)) {
                LogicalFilter filter = (LogicalFilter)rightInputRel;
                rightInputRel = filter.getInput();
                assert (rightInputRel instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(rightInputRel = ((HepRelVertex)rightInputRel).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList tmpRightJoinKeys = Lists.newArrayList();
                ArrayList correlatedJoinKeys = Lists.newArrayList();
                RelOptUtil.splitCorrelatedFilterCondition(filter, tmpRightJoinKeys, correlatedJoinKeys, false);
                ArrayList<RexInputRef> rightJoinKeys = new ArrayList<RexInputRef>();
                for (RexNode key : tmpRightJoinKeys) {
                    assert (key instanceof RexInputRef);
                    rightJoinKeys.add((RexInputRef)key);
                }
                if (rightJoinKeys.isEmpty()) {
                    return;
                }
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered((RelNode)rightInputRel, rightJoinKeys)) {
                    SQL2REL_LOGGER.fine(((Object)rightJoinKeys).toString() + "are not unique keys for " + rightInputRel.toString());
                    return;
                }
                RexUtil.FieldAccessFinder visitor = new RexUtil.FieldAccessFinder();
                RexUtil.apply((RexVisitor<Void>)visitor, correlatedJoinKeys, null);
                List<RexFieldAccess> correlatedKeyList = visitor.getFieldAccessList();
                if (!RelDecorrelator.this.checkCorVars(corRel, projRel, filter, correlatedKeyList)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filter.getCondition(), false);
                nullIndicatorPos = leftInputRel.getRowType().getFieldCount() + ((RexInputRef)rightJoinKeys.get(0)).getIndex();
            } else if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey((Object)projRel)) {
                if (RelOptUtil.getVariablesUsed(rightInputRel).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, projRel, null, null)) {
                    return;
                }
                rightInputRel = RelDecorrelator.this.createProjectWithAdditionalExprs(rightInputRel, (List)ImmutableList.of(Pair.of(RelDecorrelator.this.rexBuilder.makeLiteral(true), "nullIndicator")));
                rightInputRel = RelOptUtil.createSingleValueAggRel(cluster, rightInputRel);
                nullIndicatorPos = leftInputRel.getRowType().getFieldCount() + rightInputRel.getRowType().getFieldCount() - 1;
            } else {
                return;
            }
            LogicalJoin join = LogicalJoin.create(leftInputRel, (RelNode)rightInputRel, joinCond, joinType, (Set<String>)ImmutableSet.of());
            RelNode newProjRel = RelDecorrelator.this.projectJoinOutputWithNullability(join, projRel, nullIndicatorPos);
            call.transformTo(newProjRel);
            RelDecorrelator.this.removeCorVarFromTree(corRel);
        }
    }

    private final class RemoveSingleAggregateRule
    extends RelOptRule {
        public RemoveSingleAggregateRule() {
            super(RemoveSingleAggregateRule.operand(LogicalAggregate.class, RemoveSingleAggregateRule.operand(LogicalProject.class, RemoveSingleAggregateRule.operand(LogicalAggregate.class, RemoveSingleAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalAggregate singleAggRel = (LogicalAggregate)call.rel(0);
            LogicalProject projRel = (LogicalProject)call.rel(1);
            LogicalAggregate aggRel = (LogicalAggregate)call.rel(2);
            if (!singleAggRel.getGroupSet().isEmpty() || singleAggRel.getAggCallList().size() != 1 || !(singleAggRel.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            List<RexNode> projExprs = projRel.getProjects();
            if (projExprs.size() != 1) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            RelOptCluster cluster = projRel.getCluster();
            RelNode newProjRel = RelOptUtil.createProject((RelNode)aggRel, (List<? extends RexNode>)ImmutableList.of((Object)RelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(projExprs.get(0).getType(), true), projExprs.get(0))), null);
            call.transformTo(newProjRel);
        }
    }

    private class RemoveCorrelationRexShuttle
    extends RexShuttle {
        RexBuilder rexBuilder;
        RelDataTypeFactory typeFactory;
        boolean projectPulledAboveLeftCorrelator;
        RexInputRef nullIndicator;
        Set<Integer> isCount;

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, null, null);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, nullIndicator, null);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, null, isCount);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator, Set<Integer> isCount) {
            this.projectPulledAboveLeftCorrelator = projectPulledAboveLeftCorrelator;
            this.nullIndicator = nullIndicator;
            this.isCount = isCount;
            this.rexBuilder = rexBuilder;
            this.typeFactory = rexBuilder.getTypeFactory();
        }

        private RexNode createCaseExpression(RexInputRef nullInputRef, RexLiteral lit, RexNode rexNode) {
            RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexInputRef(nullInputRef.getIndex(), this.typeFactory.createTypeWithNullability(nullInputRef.getType(), true))), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), lit), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), rexNode)};
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (RelDecorrelator.this.cm.mapFieldAccessToCorVar.containsKey(fieldAccess)) {
                Correlation corVar = (Correlation)RelDecorrelator.this.cm.mapFieldAccessToCorVar.get(fieldAccess);
                RexNode newRexNode = new RexInputRef(corVar.field, fieldAccess.getType());
                if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                    newRexNode = this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newRexNode);
                }
                return newRexNode;
            }
            return fieldAccess;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            if (RelDecorrelator.this.currentRel != null && RelDecorrelator.this.currentRel instanceof LogicalCorrelate) {
                int leftInputFieldCount = ((LogicalCorrelate)RelDecorrelator.this.currentRel).getLeft().getRowType().getFieldCount();
                RelDataType newType = inputRef.getType();
                if (this.projectPulledAboveLeftCorrelator) {
                    newType = this.typeFactory.createTypeWithNullability(newType, true);
                }
                int pos = inputRef.getIndex();
                RexInputRef newInputRef = new RexInputRef(leftInputFieldCount + pos, newType);
                if (this.isCount != null && this.isCount.contains(pos)) {
                    return this.createCaseExpression(newInputRef, this.rexBuilder.makeExactLiteral(BigDecimal.ZERO), newInputRef);
                }
                return newInputRef;
            }
            return inputRef;
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            if (!RexUtil.isNull(literal) && this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), literal);
            }
            return literal;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall;
            boolean[] update = new boolean[]{false};
            List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
            if (update[0]) {
                SqlFunction function;
                SqlOperator operator = call.getOperator();
                boolean isSpecialCast = false;
                if (operator instanceof SqlFunction && (function = (SqlFunction)operator).getKind() == SqlKind.CAST && call.operands.size() < 2) {
                    isSpecialCast = true;
                }
                RelDataType newType = !isSpecialCast ? this.rexBuilder.deriveReturnType(operator, clonedOperands) : call.getType();
                newCall = this.rexBuilder.makeCall(newType, operator, clonedOperands);
            } else {
                newCall = call;
            }
            if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newCall);
            }
            return newCall;
        }
    }

    private class DecorrelateRexShuttle
    extends RexShuttle {
        private DecorrelateRexShuttle() {
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            int newInputRelOutputOffset = 0;
            List<RelNode> inputs = RelDecorrelator.this.currentRel.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                RelNode oldInputRel = inputs.get(i);
                RelNode newInputRel = (RelNode)RelDecorrelator.this.mapOldToNewRel.get(oldInputRel);
                if (newInputRel != null && RelDecorrelator.this.mapNewRelToMapCorVarToOutputPos.containsKey(newInputRel)) {
                    Integer newInputPos;
                    Correlation corVar;
                    SortedMap childMapCorVarToOutputPos = (SortedMap)RelDecorrelator.this.mapNewRelToMapCorVarToOutputPos.get(newInputRel);
                    if (childMapCorVarToOutputPos != null && (corVar = (Correlation)RelDecorrelator.this.cm.mapFieldAccessToCorVar.get(fieldAccess)) != null && (newInputPos = (Integer)childMapCorVarToOutputPos.get(corVar)) != null) {
                        newInputPos = newInputPos + newInputRelOutputOffset;
                        RexInputRef newInput = new RexInputRef(newInputPos, fieldAccess.getType());
                        return newInput;
                    }
                    newInputRelOutputOffset += newInputRel.getRowType().getFieldCount();
                    continue;
                }
                newInputRelOutputOffset += oldInputRel.getRowType().getFieldCount();
            }
            return fieldAccess;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RexInputRef newInputRef = RelDecorrelator.this.getNewForOldInputRef(inputRef);
            return newInputRef;
        }
    }

    private class DecorrelateRelVisitor
    extends RelVisitor {
        private final ReflectiveVisitDispatcher<RelDecorrelator, RelNode> dispatcher = ReflectUtil.createDispatcher(RelDecorrelator.class, RelNode.class);

        private DecorrelateRelVisitor() {
        }

        @Override
        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            RelDecorrelator.this.currentRel = p;
            String visitMethodName = "decorrelateRel";
            boolean found = this.dispatcher.invokeVisitor(RelDecorrelator.this, RelDecorrelator.this.currentRel, "decorrelateRel");
            RelDecorrelator.this.setCurrent(null, null);
            if (!found) {
                RelDecorrelator.this.decorrelateRelGeneric(p);
            }
        }
    }
}

