/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;

public class AvroToJsonConverter
extends Converter<String, JsonArray, GenericRecord, JsonObject> {
    private Gson gson;

    public Converter<String, JsonArray, GenericRecord, JsonObject> init(WorkUnitState workUnit) {
        this.gson = new GsonBuilder().create();
        return this;
    }

    public JsonArray convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return new JsonParser().parse(inputSchema).getAsJsonArray();
    }

    public Iterable<JsonObject> convertRecord(JsonArray outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        HashMap record = Maps.newHashMap();
        for (Schema.Field field : inputRecord.getSchema().getFields()) {
            Object col = inputRecord.get(field.name());
            if (col != null && col instanceof Utf8) {
                col = col.toString();
            }
            record.put(field.name(), col);
        }
        return Collections.singleton(((JsonObject)this.gson.fromJson(this.gson.toJson((Object)record), JsonObject.class)).getAsJsonObject());
    }
}

