/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.util.ArgumentUtil;

public class HashBasedPartitionProperties
implements PartitionProperties {
    private final String _partitionKeyRegex;
    private final int _partitionCount;
    private final HashAlgorithm _hashAlgorithm;

    public HashBasedPartitionProperties(String partitionKeyRegex, int partitionCount, HashAlgorithm hashAlgorithm2) {
        ArgumentUtil.notNull((Object)partitionKeyRegex, (String)"partitionKeyRegex");
        this._partitionKeyRegex = partitionKeyRegex;
        this._partitionCount = partitionCount;
        this._hashAlgorithm = hashAlgorithm2;
    }

    public String getPartitionKeyRegex() {
        return this._partitionKeyRegex;
    }

    public int getPartitionCount() {
        return this._partitionCount;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this._hashAlgorithm;
    }

    @Override
    public PartitionProperties.PartitionType getPartitionType() {
        return PartitionProperties.PartitionType.HASH;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashBasedPartitionProperties other = (HashBasedPartitionProperties)obj;
        if (!this._partitionKeyRegex.equals(other._partitionKeyRegex)) {
            return false;
        }
        if (this._partitionCount != other._partitionCount) {
            return false;
        }
        return this._hashAlgorithm == other._hashAlgorithm;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._partitionKeyRegex == null ? 0 : this._partitionKeyRegex.hashCode());
        result = 31 * result + this._partitionCount;
        result = 31 * result + (this._hashAlgorithm == null ? 0 : this._hashAlgorithm.hashCode());
        return result;
    }

    public static enum HashAlgorithm {
        MODULO,
        MD5;

    }
}

