/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.PropertyBuilder;
import com.linkedin.d2.discovery.stores.PropertyStoreAsync;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigWriter<T> {
    private static final Logger _log = LoggerFactory.getLogger(ConfigWriter.class);
    private final PropertyStoreAsync<T> _store;
    private final PropertyBuilder<T> _builder;
    private final Map<String, Map<String, Object>> _source;
    private final Map<String, Object> _defaultMap;
    private final long _timeout;
    private final TimeUnit _timeoutUnit;
    private final int _maxOutstandingWrites;

    public ConfigWriter(PropertyStoreAsync<T> store, PropertyBuilder<T> builder, Map<String, Map<String, Object>> source, Map<String, Object> defaultMap, long timeout, TimeUnit timeoutUnit, int maxOutstandingWrites) {
        this._store = store;
        this._builder = builder;
        this._source = source;
        this._defaultMap = defaultMap;
        this._timeout = timeout;
        this._timeoutUnit = timeoutUnit;
        this._maxOutstandingWrites = maxOutstandingWrites;
    }

    public void writeConfig() throws ExecutionException, TimeoutException, InterruptedException {
        long startTime = System.currentTimeMillis();
        FutureCallback callback = new FutureCallback();
        this._store.start((Callback<None>)callback);
        callback.get(this._timeout, this._timeoutUnit);
        final Semaphore outstandingPutSemaphore = new Semaphore(this._maxOutstandingWrites);
        for (final String key : this._source.keySet()) {
            Map<String, Object> map = ConfigWriter.merge(this._source.get(key), this._defaultMap);
            T properties = this._builder.fromMap(map);
            Callback<None> putCallback = new Callback<None>(){

                public void onSuccess(None none) {
                    outstandingPutSemaphore.release();
                }

                public void onError(Throwable e) {
                    _log.error("Put failed for {}", (Object)key, (Object)e);
                    outstandingPutSemaphore.release();
                }
            };
            if (!outstandingPutSemaphore.tryAcquire(this._timeout, this._timeoutUnit)) {
                _log.error("Put timed out for {}", (Object)key);
                throw new TimeoutException();
            }
            this._store.put(key, properties, putCallback);
        }
        if (!outstandingPutSemaphore.tryAcquire(this._maxOutstandingWrites, this._timeout, this._timeoutUnit)) {
            _log.error("Put timed out with {} outstanding writes", (Object)(this._maxOutstandingWrites - outstandingPutSemaphore.availablePermits()));
            throw new TimeoutException();
        }
        FutureCallback shutdownCallback = new FutureCallback();
        this._store.shutdown((Callback<None>)shutdownCallback);
        shutdownCallback.get(this._timeout, this._timeoutUnit);
        long elapsedTime = System.currentTimeMillis() - startTime;
        _log.info("A total of {}.{}s elapsed to write configs to store.", (Object)(elapsedTime / 1000L), (Object)(elapsedTime % 1000L));
    }

    public static Map<String, Object> merge(Map<String, Object> source, Map<String, Object> defaultMap) {
        if (source == null) {
            source = Collections.emptyMap();
        }
        if (defaultMap == null) {
            defaultMap = Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(defaultMap);
        for (String key : source.keySet()) {
            Object sourceValue = source.get(key);
            Object resultValue = result.get(key);
            if (resultValue instanceof Map || sourceValue instanceof Map) {
                Map subDefault = (Map)resultValue;
                Map subSource = (Map)sourceValue;
                result.put(key, ConfigWriter.merge(subSource, subDefault));
                continue;
            }
            result.put(key, sourceValue);
        }
        return result;
    }
}

