/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.data.template.RecordTemplate;
import java.util.List;

public class CollectionResult<T extends RecordTemplate, MD extends RecordTemplate> {
    private final List<T> _elements;
    private final MD _metadata;
    private final Integer _total;
    private final PageIncrement _pageIncrement;

    public CollectionResult(List<T> elements, MD metadata) {
        this(elements, null, metadata);
    }

    public CollectionResult(List<T> elements, MD metadata, PageIncrement pageIncrement) {
        this(elements, null, metadata, pageIncrement);
    }

    public CollectionResult(List<T> elements) {
        this(elements, null, (RecordTemplate)null);
    }

    public CollectionResult(List<T> elements, Integer total) {
        this(elements, total, null);
    }

    public CollectionResult(List<T> elements, Integer total, MD metadata) {
        this(elements, total, metadata, PageIncrement.RELATIVE);
    }

    public CollectionResult(List<T> elements, Integer total, MD metadata, PageIncrement pageIncrement) {
        this._elements = elements;
        this._total = total;
        this._metadata = metadata;
        this._pageIncrement = pageIncrement;
        if (this._pageIncrement == PageIncrement.FIXED && this._total == null) {
            throw new IllegalArgumentException("'total' must be non null if PageIncrement is FIXED.");
        }
    }

    public List<T> getElements() {
        return this._elements;
    }

    public PageIncrement getPageIncrement() {
        return this._pageIncrement;
    }

    public boolean getHasTotal() {
        return this._total != null;
    }

    public Integer getTotal() {
        return this._total;
    }

    public MD getMetadata() {
        return this._metadata;
    }

    public static enum PageIncrement {
        RELATIVE,
        FIXED;

    }
}

