/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.util;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.it.Builder;
import com.linkedin.data.it.IterationOrder;
import com.linkedin.data.it.Predicate;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.transform.filter.CopyFilter;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.restli.common.CollectionMetadata;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.Link;
import com.linkedin.restli.common.LinkArray;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.model.Parameter;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.util.ArgumentUtils;
import com.linkedin.restli.internal.server.util.MIMEParse;
import com.linkedin.restli.server.CollectionResult;
import com.linkedin.restli.server.InvalidMimeTypeException;
import com.linkedin.restli.server.PagingContext;
import com.linkedin.restli.server.ProjectionMode;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.RoutingException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RestUtils {
    private static final DataMap EMPTY_DATAMAP = new DataMap();

    public static CollectionMetadata buildMetadata(URI requestUri, ResourceContext resourceContext, ResourceMethodDescriptor methodDescriptor, List<?> resultElements, CollectionResult.PageIncrement pageIncrement, Integer totalResults) {
        CollectionMetadata metadata = new CollectionMetadata();
        List<Parameter<?>> pagingContextParams = methodDescriptor.getParametersWithType(Parameter.ParamType.PAGING_CONTEXT_PARAM);
        PagingContext defaultPagingContext = pagingContextParams.isEmpty() ? null : (PagingContext)pagingContextParams.get(0).getDefaultValue();
        PagingContext pagingContext = RestUtils.getPagingContext(resourceContext, defaultPagingContext);
        metadata.setCount(pagingContext.getCount());
        metadata.setStart(pagingContext.getStart());
        if (totalResults != null) {
            metadata.setTotal(totalResults);
        } else {
            metadata.removeTotal();
        }
        LinkArray links = new LinkArray();
        String bestEncoding = "application/json";
        if (resourceContext.getRawRequest() != null) {
            bestEncoding = RestUtils.pickBestEncoding(resourceContext.getRequestHeaders().get("Accept"));
        }
        if (pagingContext.getCount() > 0) {
            Integer nextStart;
            if (pagingContext.getStart() > 0) {
                int prevStart = Math.max(0, pagingContext.getStart() - pagingContext.getCount());
                String prevUri = RestUtils.buildPaginatedUri(requestUri, prevStart, pagingContext.getCount());
                Link prevLink = new Link();
                prevLink.setRel("prev");
                prevLink.setHref(prevUri);
                prevLink.setType(bestEncoding);
                links.add((DataTemplate)prevLink);
            }
            if ((nextStart = RestUtils.getNextPageStart(resultElements.size(), totalResults, pagingContext, pageIncrement)) != null) {
                String nextUri = RestUtils.buildPaginatedUri(requestUri, nextStart, pagingContext.getCount());
                Link nextLink = new Link();
                nextLink.setRel("next");
                nextLink.setHref(nextUri);
                nextLink.setType(bestEncoding);
                links.add((DataTemplate)nextLink);
            }
            metadata.setLinks(links);
        }
        return metadata;
    }

    private static Integer getNextPageStart(int elementsOnCurrentPage, Integer totalResults, PagingContext pagingContext, CollectionResult.PageIncrement pageIncrement) {
        if (pageIncrement == CollectionResult.PageIncrement.RELATIVE) {
            if (totalResults != null && pagingContext.getStart() + elementsOnCurrentPage < totalResults || elementsOnCurrentPage == pagingContext.getCount()) {
                return pagingContext.getStart() + elementsOnCurrentPage;
            }
            return null;
        }
        if (pageIncrement == CollectionResult.PageIncrement.FIXED) {
            if (totalResults == null) {
                throw new IllegalStateException("'total' must be non-null when PageIncrement is FIXED");
            }
            if (pagingContext.getStart() + pagingContext.getCount() < totalResults) {
                return pagingContext.getStart() + pagingContext.getCount();
            }
            return null;
        }
        throw new IllegalStateException("Unrecognized enumeration value: " + (Object)((Object)pageIncrement));
    }

    private static String buildPaginatedUri(URI requestUri, int start, Integer count) {
        UriBuilder builder = UriBuilder.fromUri((URI)requestUri);
        builder.replaceQueryParam("start", new Object[]{String.valueOf(start)});
        builder.replaceQueryParam("count", new Object[]{String.valueOf(count)});
        return builder.build(new Object[0]).toString();
    }

    public static PagingContext getPagingContext(ResourceContext context, PagingContext defaultContext) {
        String startString = ArgumentUtils.argumentAsString(context.getParameter("start"), "start");
        String countString = ArgumentUtils.argumentAsString(context.getParameter("count"), "count");
        try {
            int count;
            int defaultStart = defaultContext == null ? 0 : defaultContext.getStart();
            int defaultCount = defaultContext == null ? 10 : defaultContext.getCount();
            int start = startString == null || StringUtils.isEmpty((String)startString.trim()) ? defaultStart : Integer.parseInt(startString);
            int n = count = countString == null || StringUtils.isEmpty((String)countString.trim()) ? defaultCount : Integer.parseInt(countString);
            if (count < 0 || start < 0) {
                throw new RoutingException("start/count parameters must be non-negative", 400);
            }
            return new PagingContext(start, count, startString != null, countString != null);
        }
        catch (NumberFormatException e) {
            throw new RoutingException("Invalid (non-integer) start/count parameters", 400);
        }
    }

    public static String pickBestEncoding(String acceptHeader) {
        if (acceptHeader == null || acceptHeader.isEmpty()) {
            return "application/json";
        }
        try {
            List<String> acceptTypes = MIMEParse.parseAcceptType(acceptHeader);
            if (acceptTypes.size() == 1 && acceptTypes.get(0).equalsIgnoreCase("multipart/related")) {
                return "application/json";
            }
            return MIMEParse.bestMatch(RestConstants.SUPPORTED_MIME_TYPES, acceptHeader);
        }
        catch (InvalidMimeTypeException e) {
            throw new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST, String.format("Encountered invalid MIME type '%s' in accept header.", e.getType()));
        }
    }

    public static DataMap projectFields(DataMap dataMap, ProjectionMode projectionMode, MaskTree projectionMask) {
        if (projectionMode == ProjectionMode.MANUAL) {
            return dataMap;
        }
        if (projectionMask == null) {
            return dataMap;
        }
        DataMap filterMap = projectionMask.getDataMap();
        if (projectionMask.getDataMap().isEmpty()) {
            return EMPTY_DATAMAP;
        }
        try {
            return (DataMap)new CopyFilter().filter((Object)dataMap, filterMap);
        }
        catch (Exception e) {
            throw new RestLiInternalException("Error projecting fields", e);
        }
    }

    public static void validateRequestHeadersAndUpdateResourceContext(Map<String, String> headers, ServerResourceContext resourceContext) {
        String mimeType = RestUtils.pickBestEncoding(headers.get("Accept"));
        if (StringUtils.isEmpty((String)mimeType)) {
            throw new RestLiServiceException(HttpStatus.S_406_NOT_ACCEPTABLE, "None of the types in the request's 'Accept' header are supported. Supported MIME types are: " + RestConstants.SUPPORTED_MIME_TYPES);
        }
        resourceContext.setResponseMimeType(mimeType);
    }

    public static void trimRecordTemplate(RecordTemplate recordTemplate, MaskTree override, boolean failOnMismatch) {
        RestUtils.trimRecordTemplate(recordTemplate.data(), recordTemplate.schema(), override, failOnMismatch);
    }

    public static void trimRecordTemplate(DataMap dataMap, RecordDataSchema schema, MaskTree override, final boolean failOnMismatch) {
        if (dataMap == null || schema == null) {
            return;
        }
        DataMap overrideResults = RestUtils.projectFields(dataMap, ProjectionMode.AUTOMATIC, override);
        Builder.create((Object)dataMap, (DataSchema)schema, (IterationOrder)IterationOrder.PRE_ORDER).filterBy(new Predicate(){

            public boolean evaluate(DataElement element) {
                if (failOnMismatch && element.getSchema() == null) {
                    throw new IllegalArgumentException("Schema validation did not succeed: " + element.getValue().toString());
                }
                return element.getSchema() == null;
            }
        }).remove();
        CheckedUtil.putAllWithoutChecking((CheckedMap)dataMap, (Map)overrideResults);
    }

    public static void trimRecordTemplate(DataMap dataMap, RecordDataSchema schema, boolean failOnMismatch) {
        RestUtils.trimRecordTemplate(dataMap, schema, new MaskTree(), failOnMismatch);
    }

    public static void trimRecordTemplate(RecordTemplate recordTemplate, boolean failOnMismatch) {
        if (recordTemplate == null) {
            return;
        }
        RestUtils.trimRecordTemplate(recordTemplate.data(), recordTemplate.schema(), failOnMismatch);
    }

    static {
        EMPTY_DATAMAP.makeReadOnly();
    }
}

