/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.DataList;
import com.linkedin.data.collections.CheckedList;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.CollectionMetadata;
import com.linkedin.restli.common.CollectionResponse;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.methods.AnyRecord;
import com.linkedin.restli.internal.server.response.CollectionResponseEnvelope;
import com.linkedin.restli.internal.server.response.FinderResponseEnvelope;
import com.linkedin.restli.internal.server.response.GetAllResponseEnvelope;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.util.RestUtils;
import com.linkedin.restli.server.CollectionResult;
import com.linkedin.restli.server.ProjectionMode;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CollectionResponseBuilder
implements RestLiResponseBuilder {
    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        CollectionResponseEnvelope response = responseData.getCollectionResponseEnvelope();
        PartialRestResponse.Builder builder = new PartialRestResponse.Builder();
        CollectionResponse collectionResponse = new CollectionResponse(AnyRecord.class);
        collectionResponse.setPaging(response.getCollectionResponsePaging());
        DataList elementsMap = (DataList)collectionResponse.data().get((Object)"elements");
        for (RecordTemplate recordTemplate : response.getCollectionResponse()) {
            CheckedUtil.addWithoutChecking((CheckedList)elementsMap, (Object)recordTemplate.data());
        }
        if (response.getCollectionResponseCustomMetadata() != null) {
            collectionResponse.setMetadataRaw(response.getCollectionResponseCustomMetadata().data());
        }
        builder.entity((RecordTemplate)collectionResponse);
        return builder.headers(responseData.getHeaders()).cookies(responseData.getCookies()).build();
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object object, Map<String, String> headers, List<HttpCookie> cookies) {
        if (object instanceof List) {
            List result = (List)object;
            return CollectionResponseBuilder.buildRestLiResponseData(request, routingResult, result, CollectionResult.PageIncrement.RELATIVE, null, null, headers, cookies);
        }
        CollectionResult collectionResult = (CollectionResult)object;
        if (collectionResult.getElements() == null) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null elements List inside of CollectionResult returned by the resource method: " + routingResult.getResourceMethod());
        }
        return CollectionResponseBuilder.buildRestLiResponseData(request, routingResult, collectionResult.getElements(), collectionResult.getPageIncrement(), collectionResult.getMetadata(), collectionResult.getTotal(), headers, cookies);
    }

    private static RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, List<? extends RecordTemplate> elements, CollectionResult.PageIncrement pageIncrement, RecordTemplate customMetadata, Integer totalResults, Map<String, String> headers, List<HttpCookie> cookies) {
        CollectionResponseEnvelope responseEnvelope;
        ResourceContext resourceContext = routingResult.getContext();
        CollectionMetadata paging = RestUtils.buildMetadata(request.getURI(), resourceContext, routingResult.getResourceMethod(), elements, pageIncrement, totalResults);
        CollectionMetadata projectedPaging = new CollectionMetadata(RestUtils.projectFields(paging.data(), ProjectionMode.AUTOMATIC, resourceContext.getPagingProjectionMask()));
        ArrayList<AnyRecord> processedElements = new ArrayList<AnyRecord>(elements.size());
        for (RecordTemplate recordTemplate : elements) {
            if (recordTemplate == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null element inside of a List returned by the resource method: " + routingResult.getResourceMethod());
            }
            processedElements.add(new AnyRecord(RestUtils.projectFields(recordTemplate.data(), resourceContext.getProjectionMode(), resourceContext.getProjectionMask())));
        }
        AnyRecord projectedCustomMetadata = customMetadata != null ? new AnyRecord(RestUtils.projectFields(customMetadata.data(), resourceContext.getMetadataProjectionMode(), resourceContext.getMetadataProjectionMask())) : null;
        RestLiResponseDataImpl restLiResponseDataImpl = new RestLiResponseDataImpl(HttpStatus.S_200_OK, headers, cookies);
        switch (routingResult.getResourceMethod().getType()) {
            case GET_ALL: {
                responseEnvelope = new GetAllResponseEnvelope(processedElements, projectedPaging, projectedCustomMetadata, restLiResponseDataImpl);
                break;
            }
            case FINDER: {
                responseEnvelope = new FinderResponseEnvelope(processedElements, projectedPaging, projectedCustomMetadata, restLiResponseDataImpl);
                break;
            }
            default: {
                throw new IllegalStateException("Resource method is invalid for CollectionResponseBuilder");
            }
        }
        restLiResponseDataImpl.setResponseEnvelope(responseEnvelope);
        return restLiResponseDataImpl;
    }
}

