/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.net.InetSocketAddress;
import org.apache.commons.validator.routines.InetAddressValidator;

public class LocatorAddress {
    private final InetSocketAddress socketInetAddress;
    private final String hostname;
    private final int port;
    private final boolean isIpString;

    public LocatorAddress(InetSocketAddress loc, String locStr) {
        this.socketInetAddress = loc;
        this.hostname = locStr;
        this.port = loc.getPort();
        this.isIpString = InetAddressValidator.getInstance().isValid(locStr);
    }

    public boolean isIpString() {
        return this.isIpString;
    }

    public InetSocketAddress getSocketInetAddress() {
        if (this.isIpString) {
            return this.socketInetAddress;
        }
        return new InetSocketAddress(this.hostname, this.socketInetAddress.getPort());
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getSocketInetAddressNoLookup() {
        return this.socketInetAddress;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.isIpString ? 1231 : 1237);
        result = prime * result + (this.socketInetAddress == null ? 0 : this.socketInetAddress.hashCode());
        result = prime * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocatorAddress other = (LocatorAddress)obj;
        if (this.isIpString != other.isIpString) {
            return false;
        }
        if (this.socketInetAddress == null ? other.socketInetAddress != null : !this.socketInetAddress.equals(other.socketInetAddress)) {
            return false;
        }
        return !(this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [socketInetAddress=" + this.socketInetAddress + ", hostname=" + this.hostname + ", isIpString=" + this.isIpString + "]";
    }
}

