/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.geode.internal.ClassPathLoader;

public class DriverJarUtil {
    public void registerDriver(String driverClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        Driver driver = this.getDriverInstanceByClassName(driverClassName);
        DriverWrapper d = new DriverWrapper(driver);
        this.registerDriverWithDriverManager(d);
    }

    public void deregisterDriver(String driverClassName) throws SQLException {
        Enumeration<Driver> driverEnumeration = this.getDrivers();
        while (driverEnumeration.hasMoreElements()) {
            Driver driver = driverEnumeration.nextElement();
            if (!this.compareDriverClassName(driver, driverClassName)) continue;
            this.deregisterDriverWithDriverManager(driver);
        }
    }

    public List<Driver> getRegisteredDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        return Collections.list(drivers);
    }

    public List<String> getRegisteredDriverNames() {
        ArrayList<String> listOfDriverNames = new ArrayList<String>();
        for (Driver driver : this.getRegisteredDrivers()) {
            if (driver instanceof DriverWrapper) {
                listOfDriverNames.add(((DriverWrapper)driver).getWrappedDriverName());
                continue;
            }
            listOfDriverNames.add(driver.getClass().getName());
        }
        return listOfDriverNames;
    }

    Driver getDriverInstanceByClassName(String driverClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (Driver)ClassPathLoader.getLatest().forName(driverClassName).newInstance();
    }

    Enumeration<Driver> getDrivers() {
        return DriverManager.getDrivers();
    }

    boolean compareDriverClassName(Driver driver, String driverClassName) {
        if (driver instanceof DriverWrapper) {
            return ((DriverWrapper)driver).getWrappedDriverName().equals(driverClassName);
        }
        return driver.getClass().getName().equals(driverClassName);
    }

    void registerDriverWithDriverManager(Driver driver) throws SQLException {
        DriverManager.registerDriver(driver);
    }

    void deregisterDriverWithDriverManager(Driver driver) throws SQLException {
        DriverManager.deregisterDriver(driver);
    }

    class DriverWrapper
    implements Driver {
        private Driver jdbcDriver;

        DriverWrapper(Driver jdbcDriver) {
            this.jdbcDriver = jdbcDriver;
        }

        public String getWrappedDriverName() {
            return this.jdbcDriver.getClass().getName();
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.jdbcDriver.connect(url, info);
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.jdbcDriver.acceptsURL(url);
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.jdbcDriver.getPropertyInfo(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.jdbcDriver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.jdbcDriver.getMinorVersion();
        }

        @Override
        public boolean jdbcCompliant() {
            return this.jdbcDriver.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.jdbcDriver.getParentLogger();
        }
    }
}

