/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.client.internal.locator.ServerLocationResponse;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.util.ArgumentRedactor;

public class LocatorStatusResponse
extends ServerLocationResponse {
    private Integer pid;
    private List<String> jvmArgs;
    private Long uptime;
    private String classpath;
    private String gemfireVersion;
    private String javaVersion;
    private String workingDirectory;
    private String logFile;
    private String host;
    private Integer port;
    private String name;

    private static Integer identifyPid() {
        try {
            return ProcessUtils.identifyPid();
        }
        catch (PidUnavailableException ignore) {
            return null;
        }
    }

    public LocatorStatusResponse initialize(int locatorPort, String locatorHost, String locatorLogFile, String locatorName) {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        this.pid = LocatorStatusResponse.identifyPid();
        this.jvmArgs = ArgumentRedactor.redactEachInList(runtimeBean.getInputArguments());
        this.uptime = runtimeBean.getUptime();
        this.classpath = runtimeBean.getClassPath();
        this.gemfireVersion = GemFireVersion.getGemFireVersion();
        this.javaVersion = System.getProperty("java.version");
        this.workingDirectory = System.getProperty("user.dir");
        this.logFile = locatorLogFile;
        this.host = locatorHost;
        this.port = locatorPort;
        this.name = locatorName;
        return this;
    }

    public int getDSFID() {
        return 2156;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getGemFireVersion() {
        return this.gemfireVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public List<String> getJvmArgs() {
        return Collections.unmodifiableList(this.jvmArgs != null ? this.jvmArgs : Collections.emptyList());
    }

    public Integer getPid() {
        return this.pid;
    }

    public Long getUptime() {
        return this.uptime;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.readPid(in);
        this.readUptime(in);
        this.readWorkingDirectory(in);
        this.readJvmArguments(in);
        this.readClasspath(in);
        this.readGemFireVersion(in);
        this.readJavaVersion(in);
        this.readLogFile(in);
        this.readHost(in);
        this.readPort(in);
        this.readName(in);
    }

    protected void readPid(DataInput in) throws IOException {
        int pid = in.readInt();
        this.pid = pid == 0 ? null : Integer.valueOf(pid);
    }

    protected void readUptime(DataInput in) throws IOException {
        this.uptime = in.readLong();
    }

    protected void readWorkingDirectory(DataInput in) throws IOException {
        this.workingDirectory = StringUtils.nullifyIfBlank(in.readUTF());
    }

    protected void readJvmArguments(DataInput in) throws IOException {
        int length = in.readInt();
        ArrayList<String> jvmArgs = new ArrayList<String>(length);
        for (int index = 0; index < length; ++index) {
            jvmArgs.add(in.readUTF());
        }
        this.jvmArgs = jvmArgs;
    }

    protected void readClasspath(DataInput in) throws IOException {
        this.classpath = StringUtils.nullifyIfBlank(in.readUTF());
    }

    protected void readGemFireVersion(DataInput in) throws IOException {
        this.gemfireVersion = StringUtils.nullifyIfBlank(in.readUTF());
    }

    protected void readJavaVersion(DataInput in) throws IOException {
        this.javaVersion = StringUtils.nullifyIfBlank(in.readUTF());
    }

    protected void readLogFile(DataInput in) throws IOException {
        this.logFile = StringUtils.nullifyIfBlank(in.readUTF());
    }

    protected void readHost(DataInput in) throws IOException {
        this.host = StringUtils.nullifyIfBlank(in.readUTF());
    }

    protected void readPort(DataInput in) throws IOException {
        int port = in.readInt();
        this.port = port == 0 ? null : Integer.valueOf(port);
    }

    protected void readName(DataInput in) throws IOException {
        this.name = StringUtils.nullifyIfBlank(in.readUTF());
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        this.writePid(out);
        this.writeUptime(out);
        this.writeWorkingDirectory(out);
        this.writeJvmArguments(out);
        this.writeClasspath(out);
        this.writeGemFireVersion(out);
        this.writeJavaVersion(out);
        this.writeLogFile(out);
        this.writeHost(out);
        this.writePort(out);
        this.writeName(out);
    }

    protected void writePid(DataOutput out) throws IOException {
        Integer pid = this.getPid();
        out.writeInt(pid != null ? pid : Integer.valueOf(0));
    }

    protected void writeUptime(DataOutput out) throws IOException {
        out.writeLong(this.getUptime());
    }

    protected void writeWorkingDirectory(DataOutput out) throws IOException {
        String workingDir = this.getWorkingDirectory();
        out.writeUTF(workingDir != null ? workingDir : "");
    }

    protected void writeJvmArguments(DataOutput out) throws IOException {
        List<String> jvmArgs = this.getJvmArgs();
        out.writeInt(jvmArgs.size());
        for (String jvmArg : jvmArgs) {
            out.writeUTF(jvmArg);
        }
    }

    protected void writeClasspath(DataOutput out) throws IOException {
        String classpath = this.getClasspath();
        out.writeUTF(classpath != null ? classpath : "");
    }

    protected void writeGemFireVersion(DataOutput out) throws IOException {
        String version = this.getGemFireVersion();
        out.writeUTF(version != null ? version : "");
    }

    protected void writeJavaVersion(DataOutput out) throws IOException {
        String version = this.getJavaVersion();
        out.writeUTF(version != null ? version : "");
    }

    protected void writeLogFile(DataOutput out) throws IOException {
        String log = this.getLogFile();
        out.writeUTF(log != null ? log : "");
    }

    protected void writeHost(DataOutput out) throws IOException {
        String host = this.getHost();
        out.writeUTF(host != null ? host : "");
    }

    protected void writePort(DataOutput out) throws IOException {
        Integer port = this.getPort();
        out.writeInt(port != null ? port : Integer.valueOf(0));
    }

    protected void writeName(DataOutput out) throws IOException {
        String name = this.getName();
        out.writeUTF(name != null ? name : "");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocatorStatusResponse)) {
            return false;
        }
        LocatorStatusResponse that = (LocatorStatusResponse)obj;
        return ObjectUtils.equalsIgnoreNull(this.getPid(), that.getPid()) && ObjectUtils.equals(this.getUptime(), that.getUptime()) && ObjectUtils.equals(this.getWorkingDirectory(), that.getWorkingDirectory()) && ObjectUtils.equals(this.getJvmArgs(), that.getJvmArgs()) && ObjectUtils.equals(this.getClasspath(), that.getClasspath()) && ObjectUtils.equals(this.getGemFireVersion(), that.getGemFireVersion()) && ObjectUtils.equals(this.getJavaVersion(), that.getJavaVersion());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getPid());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getUptime());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getWorkingDirectory());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getJvmArgs());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getClasspath());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getGemFireVersion());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getJavaVersion());
        return hashValue;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ pid = " + this.getPid() + ", uptime = " + this.getUptime() + ", workingDirectory = " + this.getWorkingDirectory() + ", jvmArgs = " + ArgumentRedactor.redact(this.getJvmArgs()) + ", classpath = " + this.getClasspath() + ", gemfireVersion = " + this.getGemFireVersion() + ", javaVersion = " + this.getJavaVersion() + "}";
    }
}

