/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.xml;

import java.util.Stack;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.xml.RegionMappingConfiguration;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.RegionCreation;
import org.xml.sax.Attributes;

public enum ElementType {
    JDBC_MAPPING("mapping"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof RegionCreation)) {
                throw new CacheXmlException("<jdbc:mapping> elements must occur within <region> elements");
            }
            RegionCreation regionCreation = (RegionCreation)stack.peek();
            RegionMapping mapping = new RegionMapping();
            mapping.setRegionName(regionCreation.getFullPath().substring(1));
            mapping.setDataSourceName(attributes.getValue("data-source"));
            mapping.setTableName(attributes.getValue("table"));
            mapping.setPdxName(attributes.getValue("pdx-name"));
            mapping.setIds(attributes.getValue("ids"));
            mapping.setCatalog(attributes.getValue("catalog"));
            mapping.setSchema(attributes.getValue("schema"));
            stack.push((Object)mapping);
        }

        @Override
        void endElement(Stack<Object> stack) {
            RegionMapping mapping = (RegionMapping)((Object)stack.pop());
            RegionCreation regionCreation = (RegionCreation)stack.peek();
            regionCreation.getExtensionPoint().addExtension((Extension)new RegionMappingConfiguration(mapping));
        }
    }
    ,
    FIELD_MAPPING("field-mapping"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof RegionMapping)) {
                throw new CacheXmlException("<jdbc:field-mapping> elements must occur within <jdbc:mapping> elements");
            }
            RegionMapping mapping = (RegionMapping)((Object)stack.peek());
            String pdxName = attributes.getValue("pdx-name");
            String pdxType = attributes.getValue("pdx-type");
            String jdbcName = attributes.getValue("jdbc-name");
            String jdbcType = attributes.getValue("jdbc-type");
            String jdbcNullable = attributes.getValue("jdbc-nullable");
            FieldMapping fieldMapping = new FieldMapping(pdxName, pdxType, jdbcName, jdbcType, Boolean.parseBoolean(jdbcNullable));
            mapping.addFieldMapping(fieldMapping);
        }

        @Override
        void endElement(Stack<Object> stack) {
        }
    };

    private String typeName;

    private ElementType(String typeName) {
        this.typeName = typeName;
    }

    static ElementType getTypeFromName(String typeName) {
        for (ElementType type : ElementType.values()) {
            if (!type.typeName.equals(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid type '" + typeName + "'");
    }

    public String getTypeName() {
        return this.typeName;
    }

    abstract void startElement(Stack<Object> var1, Attributes var2);

    abstract void endElement(Stack<Object> var1);
}

