/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.Index;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.domain.IndexDetails;

public class ListIndexFunction
implements InternalFunction<Void> {
    public String getId() {
        return ListIndexFunction.class.getName();
    }

    public void execute(FunctionContext<Void> context) {
        try {
            HashSet<IndexDetails> indexDetailsSet = new HashSet<IndexDetails>();
            Cache cache = context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            for (Index index : cache.getQueryService().getIndexes()) {
                indexDetailsSet.add(new IndexDetails(member, index));
            }
            context.getResultSender().lastResult(indexDetailsSet);
        }
        catch (Exception e) {
            context.getResultSender().sendException((Throwable)e);
        }
    }
}

