/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.xml.sax.SAXException;

public class ConfigurationResponse
implements DataSerializableFixedID {
    private Map<String, Configuration> requestedConfiguration = new HashMap<String, Configuration>();
    private Map<String, Set<String>> jarNames = new HashMap<String, Set<String>>();
    private boolean failedToGetSharedConfig = false;
    private transient DistributedMember member;

    public int getDSFID() {
        return 2160;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeHashMap(this.requestedConfiguration, out);
        DataSerializer.writeHashMap(this.jarNames, out);
        DataSerializer.writeBoolean(this.failedToGetSharedConfig, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.requestedConfiguration = DataSerializer.readHashMap(in);
        this.jarNames = DataSerializer.readHashMap(in);
        this.failedToGetSharedConfig = DataSerializer.readBoolean(in);
    }

    public Map<String, Configuration> getRequestedConfiguration() {
        return this.requestedConfiguration;
    }

    public void addConfiguration(Configuration configuration) {
        if (configuration != null) {
            this.requestedConfiguration.put(configuration.getConfigName(), configuration);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<String> configNames = this.requestedConfiguration.keySet();
        for (String configName : configNames) {
            sb.append("\n" + this.requestedConfiguration.get(configName));
        }
        return sb.toString();
    }

    public String describeConfig() {
        StringBuffer sb = new StringBuffer();
        if (this.requestedConfiguration.isEmpty()) {
            sb.append("Received an empty shared configuration");
        } else {
            Set<Map.Entry<String, Configuration>> entries = this.requestedConfiguration.entrySet();
            for (Map.Entry<String, Configuration> entry : entries) {
                String configType = entry.getKey();
                Configuration config = entry.getValue();
                if (config == null) continue;
                sb.append("\n***************************************************************");
                sb.append("\nConfiguration for  '" + configType + "'");
                sb.append("\n\nJar files to be deployed:");
                Set<String> jarNames = config.getJarNames();
                if (jarNames.size() == 0) {
                    sb.append("\n  None");
                } else {
                    jarNames.forEach(c -> sb.append("\n  " + c));
                }
                try {
                    String cacheXmlContent = config.getCacheXmlContent();
                    if (!StringUtils.isNotBlank((CharSequence)cacheXmlContent)) continue;
                    sb.append("\n" + XmlUtils.prettyXml(cacheXmlContent));
                }
                catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
                    throw new InternalGemFireError(e);
                }
            }
        }
        return sb.toString();
    }

    public void addJar(String group, Set<String> jarNames) {
        this.jarNames.put(group, new HashSet<String>(jarNames));
    }

    public Map<String, Set<String>> getJarNames() {
        return this.jarNames;
    }

    public DistributedMember getMember() {
        return this.member;
    }

    public void setMember(DistributedMember member) {
        this.member = member;
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

