/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.monitoring;

import java.util.TimerTask;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.executor.AbstractExecutor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ThreadsMonitoringProcess
extends TimerTask {
    private static final Logger logger = LogService.getLogger();
    private final ThreadsMonitoring threadsMonitoring;
    private final int timeLimitMillis;
    private final InternalDistributedSystem internalDistributedSystem;
    private ResourceManagerStats resourceManagerStats = null;

    protected ThreadsMonitoringProcess(ThreadsMonitoring tMonitoring, InternalDistributedSystem iDistributedSystem, int timeLimitMillis) {
        this.timeLimitMillis = timeLimitMillis;
        this.threadsMonitoring = tMonitoring;
        this.internalDistributedSystem = iDistributedSystem;
    }

    @VisibleForTesting
    public boolean mapValidation() {
        int numOfStuck = 0;
        for (AbstractExecutor executor : this.threadsMonitoring.getMonitorMap().values()) {
            if (executor.isMonitoringSuspended()) continue;
            long startTime = executor.getStartTime();
            long currentTime = System.currentTimeMillis();
            if (startTime == 0L) {
                executor.setStartTime(currentTime);
                continue;
            }
            long threadId = executor.getThreadID();
            logger.trace("Checking thread {}", (Object)threadId);
            long delta = currentTime - startTime;
            if (delta < (long)this.timeLimitMillis) continue;
            ++numOfStuck;
            logger.warn("Thread {} (0x{}) is stuck", (Object)threadId, (Object)Long.toHexString(threadId));
            executor.handleExpiry(delta);
        }
        this.updateNumThreadStuckStatistic(numOfStuck);
        if (numOfStuck == 0) {
            logger.trace("There are no stuck threads in the system");
        } else if (numOfStuck != 1) {
            logger.warn("There are {} stuck threads in this node", (Object)numOfStuck);
        } else {
            logger.warn("There is 1 stuck thread in this node");
        }
        return numOfStuck != 0;
    }

    private void updateNumThreadStuckStatistic(int numOfStuck) {
        ResourceManagerStats stats = this.getResourceManagerStats();
        if (stats != null) {
            stats.setNumThreadStuck(numOfStuck);
        }
    }

    @Override
    public void run() {
        this.mapValidation();
    }

    @VisibleForTesting
    public ResourceManagerStats getResourceManagerStats() {
        ResourceManagerStats result = this.resourceManagerStats;
        if (result == null) {
            try {
                if (this.internalDistributedSystem == null || !this.internalDistributedSystem.isConnected()) {
                    return null;
                }
                DistributionManager distributionManager = this.internalDistributedSystem.getDistributionManager();
                InternalCache cache = distributionManager.getExistingCache();
                this.resourceManagerStats = result = cache.getInternalResourceManager().getStats();
            }
            catch (CacheClosedException e1) {
                logger.trace("could not update statistic since cache is closed");
            }
        }
        return result;
    }
}

