/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.CancelException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EntryOperation;
import org.apache.geode.cache.FixedPartitionAttributes;
import org.apache.geode.cache.FixedPartitionResolver;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.partition.PartitionNotAvailableException;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.cache.util.CacheWriterAdapter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryOperationImpl;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.Node;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionHelper {
    private static final Logger logger = LogService.getLogger();
    static final long BYTES_PER_MB = 0x100000L;
    public static final String PR_ROOT_REGION_NAME = "__PR";
    public static final String PARTITION_LOCK_SERVICE_NAME = "__PRLS";
    static final String BUCKET_REGION_PREFIX = "_B_";
    static final String VM_OWNERSHIP_WAIT_TIME_PROPERTY = "gemfire.VM_OWNERSHIP_WAIT_TIME";
    static final long VM_OWNERSHIP_WAIT_TIME_DEFAULT = Long.MAX_VALUE;
    static final String MAX_PARTITIONED_REGION_ID = "MAX_PARTITIONED_REGION_ID";
    public static final int DEFAULT_WAIT_PER_RETRY_ITERATION = 100;
    public static final int DEFAULT_TOTAL_WAIT_RETRY_ITERATION = 3600000;
    @Immutable
    public static final DataPolicy DEFAULT_DATA_POLICY = DataPolicy.PARTITION;
    @Immutable
    public static final Set ALLOWED_DATA_POLICIES;
    static final Object dlockMonitor;
    private static final String BUCKET_FULL_PATH_PREFIX = "__PR/_B_";
    public static final String TWO_SEPARATORS = "//";

    static void removeGlobalMetadataForFailedNode(Node failedNode, String regionIdentifier, InternalCache cache) {
        PartitionedRegionHelper.removeGlobalMetadataForFailedNode(failedNode, regionIdentifier, cache, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeGlobalMetadataForFailedNode(Node failedNode, String regionIdentifier, InternalCache cache, boolean lock) {
        LocalRegion root = PartitionedRegionHelper.getPRRoot(cache, false);
        if (root == null) {
            return;
        }
        PartitionRegionConfig prConfig = (PartitionRegionConfig)root.get(regionIdentifier);
        if (null == prConfig || !prConfig.containsNode(failedNode)) {
            return;
        }
        PartitionedRegion.RegionLock rl = PartitionedRegion.getRegionLock(regionIdentifier, cache);
        try {
            if (lock) {
                rl.lock();
            }
            if ((prConfig = (PartitionRegionConfig)root.get(regionIdentifier)) != null && prConfig.containsNode(failedNode)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cleaning up config for pr {} node {}", (Object)regionIdentifier, (Object)failedNode);
                }
                if (prConfig.getNumberOfNodes() - 1 <= 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No nodes left but failed node {} destroying entry {} nodes {}", (Object)failedNode, (Object)regionIdentifier, prConfig.getNodes());
                    }
                    try {
                        root.destroy(regionIdentifier);
                    }
                    catch (EntryNotFoundException e) {
                        logger.warn(String.format("Got EntryNotFoundException in destroy Op for allPRRegion key, %s", regionIdentifier), (Throwable)e);
                    }
                } else {
                    prConfig.removeNode(failedNode);
                    if (prConfig.getNumberOfNodes() == 0) {
                        root.destroy(regionIdentifier);
                    } else {
                        root.put(regionIdentifier, prConfig);
                    }
                }
            }
        }
        finally {
            if (lock) {
                rl.unlock();
            }
        }
    }

    public static LocalRegion getPRRoot(InternalCache cache) {
        return PartitionedRegionHelper.getPRRoot(cache, true);
    }

    public static LocalRegion getPRRoot(final InternalCache cache, boolean createIfAbsent) {
        DistributedRegion root = (DistributedRegion)cache.getRegion(PR_ROOT_REGION_NAME, true);
        if (root == null) {
            if (!createIfAbsent) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Creating root Partitioned Admin Region {}", (Object)PR_ROOT_REGION_NAME);
            }
            InternalRegionFactory factory = cache.createInternalRegionFactory(RegionShortcut.REPLICATE);
            factory.addCacheListener(new FixedPartitionAttributesListener());
            if (Boolean.getBoolean("gemfire.PRDebug")) {
                factory.addCacheListener(new CacheListenerAdapter(){

                    @Override
                    public void afterCreate(EntryEvent event) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Create Event for allPR: key = {} oldVal = {} newVal = {} Op = {} origin = {} isNetSearch = {}", event.getKey(), event.getOldValue(), event.getNewValue(), (Object)event.getOperation(), (Object)event.getDistributedMember(), (Object)event.getOperation().isNetSearch());
                        }
                    }

                    @Override
                    public void afterUpdate(EntryEvent event) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Update Event for allPR: key = {} oldVal = {} newVal = {} Op = {} origin = {} isNetSearch = {}", event.getKey(), event.getOldValue(), event.getNewValue(), (Object)event.getOperation(), (Object)event.getDistributedMember(), (Object)event.getOperation().isNetSearch());
                        }
                    }

                    @Override
                    public void afterDestroy(EntryEvent event) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Destroy Event for allPR: key = {} oldVal = {} newVal = {} Op = {} origin = {} isNetSearch = {}", event.getKey(), event.getOldValue(), event.getNewValue(), (Object)event.getOperation(), (Object)event.getDistributedMember(), (Object)event.getOperation().isNetSearch());
                        }
                    }
                });
                factory.setCacheWriter(new CacheWriterAdapter(){

                    @Override
                    public void beforeUpdate(EntryEvent event) throws CacheWriterException {
                        PartitionRegionConfig oldConf;
                        PartitionRegionConfig newConf = (PartitionRegionConfig)event.getNewValue();
                        if (newConf != (oldConf = (PartitionRegionConfig)event.getOldValue()) && !newConf.isGreaterNodeListVersion(oldConf)) {
                            throw new CacheWriterException(String.format("New PartitionedRegionConfig %s does not have newer version than previous %s", newConf, oldConf));
                        }
                    }
                });
            }
            HasCachePerfStats prMetaStatsHolder = new HasCachePerfStats(){

                @Override
                public CachePerfStats getCachePerfStats() {
                    return new CachePerfStats(cache.getDistributedSystem(), "RegionStats-partitionMetaData", cache.getStatisticsClock());
                }
            };
            factory.setIsUsedForPartitionedRegionAdmin(true);
            factory.setInternalRegion(true);
            factory.setCachePerfStatsHolder(prMetaStatsHolder);
            try {
                root = (DistributedRegion)factory.create(PR_ROOT_REGION_NAME);
                root.getDistributionAdvisor().addMembershipListener(new MemberFailureListener(cache));
            }
            catch (RegionExistsException ignore) {
                root = (DistributedRegion)cache.getRegion(PR_ROOT_REGION_NAME, true);
            }
        }
        Assert.assertTrue(root != null, "Can not obtain internal Partitioned Region configuration root");
        return root;
    }

    public static void cleanUpMetaDataOnNodeFailure(InternalCache cache, DistributedMember failedMemId) {
        try {
            LocalRegion rootReg;
            if (cache == null || cache.getCancelCriterion().isCancelInProgress()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Cleaning PartitionedRegion meta data for memberId={}", (Object)failedMemId);
            }
            if ((rootReg = PartitionedRegionHelper.getPRRoot(cache, false)) == null) {
                return;
            }
            ArrayList ks = new ArrayList(rootReg.keySet());
            if (ks.size() > 1) {
                Collections.shuffle(ks, PartitionedRegion.RANDOM);
            }
            for (String prName : ks) {
                try {
                    PartitionedRegionHelper.cleanUpMetaDataForRegion(cache, prName, failedMemId, null);
                }
                catch (CancelException cancelException) {
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Got exception in cleaning up metadata. {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpMetaDataForRegion(final InternalCache cache, final String prName, DistributedMember failedMemId, final Runnable postCleanupTask) {
        boolean runPostCleanUp = true;
        try {
            PartitionRegionConfig prConf;
            LocalRegion rootReg = PartitionedRegionHelper.getPRRoot(cache, false);
            if (rootReg == null) {
                return;
            }
            try {
                prConf = (PartitionRegionConfig)rootReg.get(prName);
            }
            catch (EntryDestroyedException ignore) {
                if (runPostCleanUp && postCleanupTask != null) {
                    postCleanupTask.run();
                }
                return;
            }
            if (prConf == null) {
                return;
            }
            Set<Node> nodeList = prConf.getNodes();
            if (nodeList == null) {
                return;
            }
            for (final Node node1 : nodeList) {
                if (cache.getCancelCriterion().isCancelInProgress()) {
                    return;
                }
                if (!node1.getMemberId().equals(failedMemId)) continue;
                cache.getDistributionManager().getExecutors().getPrMetaDataCleanupThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        PartitionedRegionHelper.cleanPartitionedRegionMetaDataForNode(cache, node1, prConf, prName);
                        if (postCleanupTask != null) {
                            postCleanupTask.run();
                        }
                    }
                });
                runPostCleanUp = false;
                return;
            }
        }
        finally {
            if (runPostCleanUp && postCleanupTask != null) {
                postCleanupTask.run();
            }
        }
    }

    private static void cleanPartitionedRegionMetaDataForNode(InternalCache cache, Node node, PartitionRegionConfig prConf, String regionIdentifier) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cleaning PartitionedRegion meta data for node={} for Partitioned Region={} configuration={}", (Object)node, (Object)regionIdentifier, (Object)prConf);
        }
        PartitionedRegionHelper.removeGlobalMetadataForFailedNode(node, regionIdentifier, cache);
        if (logger.isDebugEnabled()) {
            logger.debug("Done Cleaning PartitionedRegion meta data for memberId={} for {}", (Object)node, (Object)regionIdentifier);
        }
    }

    private static PartitionResolver getResolver(PartitionedRegion pr, Object key, Object callbackArgument) {
        PartitionResolver result = pr.getPartitionResolver();
        if (result != null) {
            return result;
        }
        if (key != null && key instanceof PartitionResolver) {
            return (PartitionResolver)key;
        }
        if (callbackArgument != null && callbackArgument instanceof PartitionResolver) {
            return (PartitionResolver)callbackArgument;
        }
        return null;
    }

    public static int getHashKey(PartitionedRegion pr, Operation operation, Object key, Object value, Object callbackArgument) {
        try {
            return PartitionedRegionHelper.getHashKey(null, pr, operation, key, value, callbackArgument);
        }
        catch (IllegalStateException e) {
            pr.getCache().getCancelCriterion().checkCancelInProgress(e);
            pr.checkClosedOrDestroyed();
            throw e;
        }
    }

    public static int getHashKey(EntryOperation event) {
        return PartitionedRegionHelper.getHashKey(event, null, null, null, null, null);
    }

    private static int getHashKey(EntryOperation event, PartitionedRegion pr, Operation operation, Object key, Object value, Object callbackArgument) {
        if (event != null) {
            pr = (PartitionedRegion)event.getRegion();
            key = event.getKey();
            callbackArgument = event.getCallbackArgument();
        }
        PartitionResolver resolver = PartitionedRegionHelper.getResolver(pr, key, callbackArgument);
        Object resolveKey = null;
        if (pr.isFixedPartitionedRegion()) {
            Integer[] bucketArray;
            String partition = null;
            if (resolver instanceof FixedPartitionResolver) {
                ConcurrentMap<String, Integer[]> partitionMap = pr.getPartitionsMap();
                if (event == null) {
                    event = new EntryOperationImpl(pr, operation, key, value, callbackArgument);
                }
                if ((partition = ((FixedPartitionResolver)resolver).getPartitionName(event, partitionMap.keySet())) == null) {
                    Object[] prms = new Object[]{pr.getName(), resolver};
                    throw new IllegalStateException(String.format("For region %s, partition resolver %s returned partition name null", prms));
                }
                bucketArray = (Integer[])partitionMap.get(partition);
                if (bucketArray == null) {
                    Object[] prms = new Object[]{pr.getName(), partition};
                    throw new PartitionNotAvailableException(String.format("For FixedPartitionedRegion %s, partition %s is not available on any datastore.", prms));
                }
            } else {
                if (resolver == null) {
                    throw new IllegalStateException(String.format("For FixedPartitionedRegion %s, FixedPartitionResolver is not available (neither through the partition attribute partition-resolver nor key/callbackArg implementing FixedPartitionResolver)", pr.getName()));
                }
                Object[] prms = new Object[]{pr.getName(), resolver};
                throw new IllegalStateException(String.format("For FixedPartitionedRegion %s, Resolver defined %s is not an instance of FixedPartitionResolver", prms));
            }
            int numBukets = bucketArray[1];
            resolveKey = numBukets == 1 ? partition : resolver.getRoutingObject(event);
            return PartitionedRegionHelper.assignFixedBucketId(pr, partition, resolveKey);
        }
        if (resolver == null) {
            resolveKey = key;
            if (resolveKey == null) {
                throw new IllegalStateException("attempting to hash null");
            }
        } else {
            if (event == null) {
                event = new EntryOperationImpl(pr, operation, key, value, callbackArgument);
            }
            if ((resolveKey = resolver.getRoutingObject(event)) == null) {
                throw new IllegalStateException("The RoutingObject returned by PartitionResolver is null. Resolver: " + resolver);
            }
        }
        return PartitionedRegionHelper.getHashKey(pr, resolveKey);
    }

    private static int assignFixedBucketId(PartitionedRegion pr, String partition, Object resolveKey) {
        Object[] prms;
        int startingBucketID = 0;
        int partitionNumBuckets = 0;
        boolean isPartitionAvailable = pr.getPartitionsMap().containsKey(partition);
        Integer[] partitionDeatils = (Integer[])pr.getPartitionsMap().get(partition);
        if (isPartitionAvailable) {
            startingBucketID = partitionDeatils[0];
            partitionNumBuckets = partitionDeatils[1];
            int hc = resolveKey.hashCode();
            int bucketId = Math.abs(hc % partitionNumBuckets);
            int n = bucketId + startingBucketID;
            assert (n != -1);
            return n;
        }
        List<FixedPartitionAttributesImpl> localFPAs = pr.getFixedPartitionAttributesImpl();
        if (localFPAs != null) {
            for (FixedPartitionAttributesImpl fixedPartitionAttributesImpl : localFPAs) {
                if (!fixedPartitionAttributesImpl.getPartitionName().equals(partition)) continue;
                isPartitionAvailable = true;
                partitionNumBuckets = fixedPartitionAttributesImpl.getNumBuckets();
                startingBucketID = fixedPartitionAttributesImpl.getStartingBucketID();
                break;
            }
        }
        if (!isPartitionAvailable) {
            List<FixedPartitionAttributesImpl> remoteFPAs = pr.getRegionAdvisor().adviseAllFixedPartitionAttributes();
            for (FixedPartitionAttributesImpl fpa : remoteFPAs) {
                if (!fpa.getPartitionName().equals(partition)) continue;
                isPartitionAvailable = true;
                partitionNumBuckets = fpa.getNumBuckets();
                startingBucketID = fpa.getStartingBucketID();
                break;
            }
        }
        if (partitionNumBuckets == 0 && isPartitionAvailable) {
            prms = new Object[]{pr.getName(), partition};
            throw new IllegalStateException(String.format("For region %s, For partition %s partition-num-buckets is set to 0. Buckets cann not be created on this partition.", prms));
        }
        if (!isPartitionAvailable) {
            prms = new Object[]{pr.getName(), partition};
            throw new PartitionNotAvailableException(String.format("For region %s, partition name %s is not available on any datastore.", prms));
        }
        int hc = resolveKey.hashCode();
        int n = Math.abs(hc % partitionNumBuckets);
        int partitionBucketID = n + startingBucketID;
        assert (partitionBucketID != -1);
        return partitionBucketID;
    }

    public static int getHashKey(PartitionedRegion pr, Object routingObject) {
        return PartitionedRegionHelper.getHashKey(routingObject, pr.getTotalNumberOfBuckets());
    }

    public static int getHashKey(Object routingObject, int totalNumBuckets) {
        int hc = routingObject.hashCode();
        int bucketId = hc % totalNumBuckets;
        return Math.abs(bucketId);
    }

    public static PartitionedRegion getPartitionedRegion(String prName, Cache cache) {
        Region region = cache.getRegion(prName);
        if (region != null && region instanceof PartitionedRegion) {
            return (PartitionedRegion)region;
        }
        return null;
    }

    public static boolean isBucketRegion(String fullPath) {
        return PartitionedRegionHelper.getBucketName(fullPath) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bucket getProxyBucketRegion(Cache cache, String fullPath, boolean postInit) throws PRLocallyDestroyedException {
        Region region;
        if (cache == null) {
            return null;
        }
        String bucketName = PartitionedRegionHelper.getBucketName(fullPath);
        if (bucketName == null) {
            return null;
        }
        String prid = PartitionedRegionHelper.getPRPath(bucketName);
        LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.ANY_INIT);
        try {
            region = cache.getRegion(prid);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        if (!(region instanceof PartitionedRegion)) {
            return null;
        }
        PartitionedRegion pr = (PartitionedRegion)region;
        int bid = PartitionedRegionHelper.getBucketId(bucketName);
        RegionAdvisor ra = (RegionAdvisor)pr.getDistributionAdvisor();
        if (postInit) {
            return ra.getBucketPostInit(bid);
        }
        if (!ra.areBucketsInitialized()) {
            return null;
        }
        return ra.getBucket(bid);
    }

    public static String getBucketName(String bucketFullPath) {
        if (bucketFullPath == null || bucketFullPath.length() == 0) {
            return null;
        }
        int idxStartRoot = bucketFullPath.indexOf(BUCKET_FULL_PATH_PREFIX);
        if (idxStartRoot != -1) {
            int idxEndRoot = idxStartRoot + PR_ROOT_REGION_NAME.length() + "/".length();
            return bucketFullPath.substring(idxEndRoot);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getBucketString no match fullPath={}", (Object)bucketFullPath);
        }
        return null;
    }

    public static String getBucketFullPath(String prFullPath, int bucketId) {
        String name = PartitionedRegionHelper.getBucketName(prFullPath, bucketId);
        if (name != null) {
            return "/__PR/" + name;
        }
        return null;
    }

    public static String escapePRPath(String prFullPath) {
        String escaped = prFullPath.replace("_", "__");
        escaped = escaped.replace('/', '_');
        return escaped;
    }

    public static String unescapePRPath(String escapedPath) {
        String path = escapedPath.replace('_', '/');
        path = path.replace(TWO_SEPARATORS, "_");
        return path;
    }

    public static String getBucketName(String prPath, int bucketId) {
        return BUCKET_REGION_PREFIX + PartitionedRegionHelper.escapePRPath(prPath) + "_" + bucketId;
    }

    public static String getPRPath(String bucketName) {
        int pridIdx = BUCKET_REGION_PREFIX.length();
        int bidSepIdx = bucketName.lastIndexOf("_");
        Assert.assertTrue(bidSepIdx > -1, "getProxyBucketRegion failed on " + bucketName);
        return PartitionedRegionHelper.unescapePRPath(bucketName.substring(pridIdx, bidSepIdx));
    }

    public static int getBucketId(String bucketName) {
        int bidSepIdx = bucketName.lastIndexOf("_");
        String bid = bucketName.substring(bidSepIdx + 1);
        return Integer.parseInt(bid);
    }

    public static boolean isSubRegion(String fullPath) {
        int idx;
        boolean isSubRegion = false;
        if (null != fullPath && (idx = fullPath.indexOf("/", "/".length())) >= 0) {
            isSubRegion = true;
        }
        return isSubRegion;
    }

    public static void logForDataLoss(PartitionedRegion partitionedRegion, int bucketId, String callingMethod) {
        if (!Boolean.getBoolean("gemfire.PRDebug")) {
            return;
        }
        LocalRegion root = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
        PartitionRegionConfig prConfig = (PartitionRegionConfig)root.get(partitionedRegion.getRegionIdentifier());
        if (prConfig == null) {
            return;
        }
        Set<InternalDistributedMember> members = partitionedRegion.getDistributionManager().getDistributionManagerIds();
        logger.warn("DATALOSS (  {}  ) :: Size of nodeList After verifyBucketNodes for bucket ID,  {}  is 0", (Object)callingMethod, (Object)bucketId);
        logger.warn("DATALOSS (  {}  ) :: NodeList from prConfig,  {}", (Object)callingMethod, (Object)PartitionedRegionHelper.printCollection(prConfig.getNodes()));
        logger.warn("DATALOSS (  {}  ) :: Current Membership List,  {}", (Object)callingMethod, (Object)PartitionedRegionHelper.printCollection(members));
    }

    public static String printCollection(Collection c) {
        if (c != null) {
            StringBuilder sb = new StringBuilder("[");
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                sb.append(itr.next());
                if (!itr.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        return "[null]";
    }

    public static FixedPartitionAttributesImpl getFixedPartitionAttributesForBucket(PartitionedRegion pr, int bucketId) {
        List<FixedPartitionAttributesImpl> localFPAs = pr.getFixedPartitionAttributesImpl();
        if (localFPAs != null) {
            for (FixedPartitionAttributesImpl fixedPartitionAttributesImpl : localFPAs) {
                if (!fixedPartitionAttributesImpl.hasBucket(bucketId)) continue;
                return fixedPartitionAttributesImpl;
            }
        }
        List<FixedPartitionAttributesImpl> remoteFPAs = pr.getRegionAdvisor().adviseAllFixedPartitionAttributes();
        for (FixedPartitionAttributesImpl fpa : remoteFPAs) {
            if (!fpa.hasBucket(bucketId)) continue;
            return fpa;
        }
        Object[] objectArray = new Object[]{pr.getName(), bucketId};
        throw new PartitionNotAvailableException(String.format("For FixedPartitionedRegion %s, Fixed partition is not defined for bucket id %s on any datastore", objectArray));
    }

    private static Set<String> getAllAvailablePartitions(PartitionedRegion region) {
        HashSet<String> partitionSet = new HashSet<String>();
        List<FixedPartitionAttributesImpl> localFPAs = region.getFixedPartitionAttributesImpl();
        if (localFPAs != null) {
            for (FixedPartitionAttributesImpl fpa : localFPAs) {
                partitionSet.add(fpa.getPartitionName());
            }
        }
        List<FixedPartitionAttributesImpl> remoteFPAs = region.getRegionAdvisor().adviseAllFixedPartitionAttributes();
        for (FixedPartitionAttributes fixedPartitionAttributes : remoteFPAs) {
            partitionSet.add(fixedPartitionAttributes.getPartitionName());
        }
        return Collections.unmodifiableSet(partitionSet);
    }

    public static Set<FixedPartitionAttributes> getAllFixedPartitionAttributes(PartitionedRegion region) {
        HashSet<FixedPartitionAttributes> fpaSet = new HashSet<FixedPartitionAttributes>();
        List<FixedPartitionAttributesImpl> localFPAs = region.getFixedPartitionAttributesImpl();
        if (localFPAs != null) {
            fpaSet.addAll(localFPAs);
        }
        List<FixedPartitionAttributesImpl> remoteFPAs = region.getRegionAdvisor().adviseAllFixedPartitionAttributes();
        fpaSet.addAll(remoteFPAs);
        return fpaSet;
    }

    static {
        dlockMonitor = new Object();
        HashSet<DataPolicy> policies = new HashSet<DataPolicy>();
        policies.add(DEFAULT_DATA_POLICY);
        policies.add(DataPolicy.PERSISTENT_PARTITION);
        ALLOWED_DATA_POLICIES = Collections.unmodifiableSet(policies);
    }

    static class FixedPartitionAttributesListener
    extends CacheListenerAdapter {
        private static final Logger logger = LogService.getLogger();

        FixedPartitionAttributesListener() {
        }

        @Override
        public void afterCreate(EntryEvent event) {
            PartitionRegionConfig prConfig = (PartitionRegionConfig)event.getNewValue();
            if (!prConfig.getElderFPAs().isEmpty()) {
                this.updatePartitionMap(prConfig);
            }
        }

        @Override
        public void afterUpdate(EntryEvent event) {
            PartitionRegionConfig prConfig = (PartitionRegionConfig)event.getNewValue();
            if (!prConfig.getElderFPAs().isEmpty()) {
                this.updatePartitionMap(prConfig);
            }
        }

        private void updatePartitionMap(PartitionRegionConfig prConfig) {
            int prId = prConfig.getPRId();
            PartitionedRegion pr = null;
            try {
                pr = PartitionedRegion.getPRFromId(prId);
                if (pr != null) {
                    ConcurrentMap<String, Integer[]> partitionMap = pr.getPartitionsMap();
                    for (FixedPartitionAttributesImpl fxPrAttr : prConfig.getElderFPAs()) {
                        partitionMap.put(fxPrAttr.getPartitionName(), new Integer[]{fxPrAttr.getStartingBucketID(), fxPrAttr.getNumBuckets()});
                    }
                }
            }
            catch (PRLocallyDestroyedException e) {
                logger.debug("PRLocallyDestroyedException : Region ={} is locally destroyed on this node", (Object)prConfig.getPRId(), (Object)e);
            }
        }
    }

    private static class MemberFailureListener
    implements MembershipListener {
        InternalCache cache = null;

        MemberFailureListener(InternalCache cache) {
            this.cache = cache;
        }

        @Override
        public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        }

        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            PartitionedRegionHelper.cleanUpMetaDataOnNodeFailure(this.cache, id);
        }

        @Override
        public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }
    }
}

