/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledBindArgument;
import org.apache.geode.cache.query.internal.CompiledComparison;
import org.apache.geode.cache.query.internal.CompiledFunction;
import org.apache.geode.cache.query.internal.CompiledID;
import org.apache.geode.cache.query.internal.CompiledIndexOperation;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledLiteral;
import org.apache.geode.cache.query.internal.CompiledNegation;
import org.apache.geode.cache.query.internal.CompiledOperation;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledUndefined;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.MapIndexable;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;

class FunctionalIndexCreationHelper
extends IndexCreationHelper {
    private boolean isMapTypeIndex;
    private boolean isAllKeys = false;
    ExecutionContext context = null;
    private CompiledValue indexedExpr;
    private List fromClauseIterators;
    QRegion region;
    String[] multiIndexKeysPattern;
    Object[] mapKeys;
    List indexInitIterators = null;
    CompiledValue missingLink = null;
    CompiledValue additionalProj = null;
    ObjectType addnlProjType = null;
    CompiledValue modifiedIndexExpr = null;
    boolean isFirstIteratorRegionEntry = false;
    boolean isFirstIteratorRegionKey = false;
    private final String imports;

    FunctionalIndexCreationHelper(String fromClause, String indexedExpression, String projectionAttributes, String imports, InternalCache cache, ExecutionContext externalContext, IndexManager imgr) throws IndexInvalidException {
        super(fromClause, projectionAttributes, cache);
        this.context = externalContext == null ? new ExecutionContext(null, cache) : externalContext;
        this.context.newScope(1);
        this.imports = imports;
        this.prepareFromClause(imgr);
        this.prepareIndexExpression(indexedExpression);
        this.prepareProjectionAttributes(projectionAttributes);
        Object[] data = this.modifyIterDefToSuiteIMQ((CompiledIteratorDef)this.fromClauseIterators.get(0));
        if (data[0] == null || data[1] == null) {
            throw new IndexInvalidException(String.format("Invalid FROM Clause : ' %s '", fromClause));
        }
        this.fromClauseIterators.remove(0);
        this.fromClauseIterators.add(0, data[1]);
        this.region = (QRegion)data[0];
    }

    @Override
    public List getIterators() {
        return this.fromClauseIterators;
    }

    @Override
    public CompiledValue getCompiledIndexedExpression() {
        return this.indexedExpr;
    }

    @Override
    public Region getRegion() {
        return this.region.getRegion();
    }

    @Override
    boolean isMapTypeIndex() {
        return this.isMapTypeIndex;
    }

    boolean isAllKeys() {
        return this.isAllKeys;
    }

    private void prepareFromClause(IndexManager imgr) throws IndexInvalidException {
        List list;
        if (this.imports != null) {
            this.compiler.compileImports(this.imports);
        }
        if ((list = this.compiler.compileFromClause(this.fromClause)) == null) {
            throw new IndexInvalidException(String.format("Invalid FROM Clause : ' %s '", this.fromClause));
        }
        int size = list.size();
        this.canonicalizedIteratorNames = new String[size];
        this.canonicalizedIteratorDefinitions = new String[size];
        StringBuilder tempBuff = new StringBuilder();
        boolean isFromClauseNull = true;
        try {
            PartitionedRegion pr = this.context.getPartitionedRegion();
            for (int i = 0; i < size; ++i) {
                CompiledIteratorDef newItr;
                String definition;
                CompiledIteratorDef iterDef = (CompiledIteratorDef)list.get(i);
                iterDef.computeDependencies(this.context);
                RuntimeIterator rIter = iterDef.getRuntimeIterator(this.context);
                this.context.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                this.context.bindIterator(rIter);
                if (i != 0 && !iterDef.isDependentOnCurrentScope(this.context)) {
                    throw new IndexInvalidException(String.format("Invalid FROM Clause : ' %s '; subsequent iterator expressions in from clause must be dependent on previous iterators", this.fromClause));
                }
                this.canonicalizedIteratorDefinitions[i] = definition = rIter.getDefinition();
                this.canonicalizedIteratorNames[i] = imgr.putCanonicalizedIteratorNameIfAbsent(definition);
                this.canonicalizedIteratorNames[i] = pr != null ? pr.getIndexManager().putCanonicalizedIteratorNameIfAbsent(definition) : imgr.putCanonicalizedIteratorNameIfAbsent(definition);
                rIter.setIndexInternalID(this.canonicalizedIteratorNames[i]);
                tempBuff.append(definition).append(' ').append(this.canonicalizedIteratorNames[i]).append(", ");
                isFromClauseNull = false;
                if (i == 0) {
                    CompiledValue cv = iterDef.getCollectionExpr();
                    this.addnlProjType = rIter.getElementType();
                    String name = iterDef.getName();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = this.canonicalizedIteratorNames[i];
                    }
                    AbstractCompiledValue newCollExpr = new CompiledPath(new CompiledBindArgument(1), "entries");
                    if (cv instanceof CompiledRegion) {
                        this.additionalProj = this.missingLink = new CompiledPath(new CompiledID(name), "value");
                    } else if (cv instanceof CompiledOperation || cv instanceof CompiledPath || cv instanceof CompiledIndexOperation) {
                        int secondTokenType;
                        ArrayList<Object> reconstruct = new ArrayList<Object>();
                        while (!(cv instanceof CompiledRegion)) {
                            CompiledValue prevCV = cv;
                            if (cv instanceof CompiledOperation) {
                                reconstruct.add(0, ((CompiledOperation)cv).getArguments());
                                reconstruct.add(0, ((CompiledOperation)cv).getMethodName());
                                cv = ((CompiledOperation)cv).getReceiver(this.context);
                            } else if (cv instanceof CompiledPath) {
                                reconstruct.add(0, ((CompiledPath)cv).getTailID());
                                cv = cv.getReceiver();
                            } else if (cv instanceof CompiledIndexOperation) {
                                reconstruct.add(0, ((CompiledIndexOperation)cv).getExpression());
                                cv = cv.getReceiver();
                            } else {
                                throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:From clause is neither a CompiledPath nor CompiledOperation");
                            }
                            reconstruct.add(0, prevCV.getType());
                        }
                        int firstTokenType = (Integer)reconstruct.get(0);
                        if (firstTokenType == -5) {
                            String secTokName;
                            String tailID = (String)reconstruct.get(1);
                            if (tailID.equals("asList") || tailID.equals("asSet") || tailID.equals("values") || tailID.equals("toArray") || tailID.equals("getValues")) {
                                this.missingLink = new CompiledPath(new CompiledID(name), "value");
                            } else if (tailID.equals("keys") || tailID.equals("getKeys") || tailID.equals("keySet")) {
                                this.missingLink = new CompiledPath(new CompiledID(name), "key");
                                this.isFirstIteratorRegionKey = true;
                            } else if (tailID.equals("entries") || tailID.equals("getEntries") || tailID.equals("entrySet")) {
                                this.isFirstIteratorRegionEntry = true;
                            } else {
                                throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:From clause does not evaluate to valid collection");
                            }
                            this.remove(reconstruct, 2, 0);
                            int n = secondTokenType = reconstruct.size() > 1 ? (Integer)reconstruct.get(0) : -1;
                            if (!this.isFirstIteratorRegionEntry && secondTokenType == 24) {
                                if (!tailID.equals("values") && !tailID.equals("getValues")) {
                                    if (tailID.equals("toList") || tailID.equals("toArray")) {
                                        throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:toList and toArray not supported");
                                    }
                                    throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:toList and toArray not supported");
                                }
                                boolean returnEntryForRegionCollection = true;
                                this.additionalProj = new CompiledIndexOperation(new CompiledBindArgument(1), (CompiledValue)reconstruct.get(1), returnEntryForRegionCollection);
                                this.isFirstIteratorRegionEntry = true;
                                this.remove(reconstruct, 2, 0);
                            } else if (!this.isFirstIteratorRegionEntry && (secondTokenType == 54 || secondTokenType == -5) && (tailID.equals("values") || tailID.equals("getValues") || tailID.equals("keySet") || tailID.equals("keys") || tailID.equals("getKeys")) && ((secTokName = (String)reconstruct.get(1)).equals("asList") || secTokName.equals("asSet") || secTokName.equals("toArray"))) {
                                this.remove(reconstruct, secondTokenType == 54 ? 3 : 2, 0);
                            }
                        } else if (firstTokenType == 24) {
                            boolean returnEntryForRegionCollection = true;
                            this.additionalProj = new CompiledIndexOperation(new CompiledBindArgument(1), (CompiledValue)reconstruct.get(1), returnEntryForRegionCollection);
                            this.isFirstIteratorRegionEntry = true;
                        } else if (firstTokenType == 54) {
                            String secTokName;
                            String methodName = (String)reconstruct.get(1);
                            if (methodName.equals("asList") || methodName.equals("asSet") || methodName.equals("values") || methodName.equals("toArray") || methodName.equals("getValues")) {
                                this.missingLink = new CompiledPath(new CompiledID(name), "value");
                            } else if (methodName.equals("keys") || methodName.equals("getKeys") || methodName.equals("keySet")) {
                                this.missingLink = new CompiledPath(new CompiledID(name), "key");
                                this.isFirstIteratorRegionKey = true;
                            } else if (methodName.equals("entries") || methodName.equals("getEntries") || methodName.equals("entrySet")) {
                                Object obj;
                                this.isFirstIteratorRegionEntry = true;
                                List args = (List)reconstruct.get(2);
                                if (args != null && args.size() == 1 && (obj = args.get(0)) instanceof CompiledBindArgument) {
                                    throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:entries method called with CompiledBindArgument");
                                }
                            }
                            this.remove(reconstruct, 3, 0);
                            int n = secondTokenType = reconstruct.size() > 1 ? (Integer)reconstruct.get(0) : -1;
                            if (!this.isFirstIteratorRegionEntry && secondTokenType == 24) {
                                if (!methodName.equals("values") && !methodName.equals("getValues")) {
                                    if (methodName.equals("toList") || methodName.equals("toArray")) {
                                        throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:toList and toArray not supported yet");
                                    }
                                    throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:toList and toArray not supported yet");
                                }
                                boolean returnEntryForRegionCollection = true;
                                newCollExpr = new CompiledIndexOperation(new CompiledBindArgument(1), (CompiledValue)reconstruct.get(1), returnEntryForRegionCollection);
                                this.remove(reconstruct, 2, 0);
                            } else if (!this.isFirstIteratorRegionEntry && (secondTokenType == 54 || secondTokenType == -5) && (methodName.equals("values") || methodName.equals("getValues") || methodName.equals("keys") || methodName.equals("getKeys") || methodName.equals("keySet")) && ((secTokName = (String)reconstruct.get(1)).equals("asList") || secTokName.equals("asSet") || secTokName.equals("toArray"))) {
                                this.remove(reconstruct, secondTokenType == 54 ? 3 : 2, 0);
                            }
                        }
                        if (!this.isFirstIteratorRegionEntry) {
                            this.additionalProj = this.missingLink;
                            int len = reconstruct.size();
                            for (int j = 0; j < len; ++j) {
                                Object obj = reconstruct.get(j);
                                if (!(obj instanceof Integer)) continue;
                                int tokenType = (Integer)obj;
                                if (tokenType == -5) {
                                    this.additionalProj = new CompiledPath(this.additionalProj, (String)reconstruct.get(++j));
                                    continue;
                                }
                                if (tokenType == 24) {
                                    this.additionalProj = new CompiledIndexOperation(this.additionalProj, (CompiledValue)reconstruct.get(++j));
                                    continue;
                                }
                                if (tokenType != 54) continue;
                                this.additionalProj = new CompiledOperation(this.additionalProj, (String)reconstruct.get(++j), (List)reconstruct.get(++j));
                            }
                        }
                    } else {
                        throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:From clause is neither a CompiledPath nor CompiledOperation");
                    }
                    if (this.isFirstIteratorRegionEntry) continue;
                    newItr = new CompiledIteratorDef(name, null, newCollExpr);
                    this.indexInitIterators = new ArrayList();
                    this.indexInitIterators.add(newItr);
                    continue;
                }
                if (this.isFirstIteratorRegionEntry) continue;
                newItr = iterDef;
                if (rIter.getDefinition().contains(this.canonicalizedIteratorNames[0])) {
                    newItr = (CompiledIteratorDef)this.getModifiedDependentCompiledValue(this.context, i, iterDef, true);
                }
                this.indexInitIterators.add(newItr);
            }
        }
        catch (IndexInvalidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexInvalidException(e);
        }
        if (isFromClauseNull) {
            throw new IndexInvalidException(String.format("Invalid FROM Clause : ' %s '", this.fromClause));
        }
        this.fromClause = tempBuff.substring(0, tempBuff.length() - 2);
        this.fromClauseIterators = list;
    }

    private void prepareIndexExpression(String indexedExpression) throws IndexInvalidException {
        CompiledValue expr = this.compiler.compileQuery(indexedExpression);
        if (expr == null) {
            throw new IndexInvalidException(String.format("Invalid indexed expression : ' %s '", indexedExpression));
        }
        if (expr instanceof CompiledUndefined || expr instanceof CompiledLiteral || expr instanceof CompiledComparison || expr instanceof CompiledBindArgument || expr instanceof CompiledNegation) {
            throw new IndexInvalidException(String.format("Invalid indexed expression : ' %s '", indexedExpression));
        }
        try {
            StringBuilder sb = new StringBuilder();
            if (expr instanceof MapIndexable) {
                MapIndexable mi = (MapIndexable)((Object)expr);
                List<CompiledValue> indexingKeys = mi.getIndexingKeys();
                if (indexingKeys.size() == 1 && indexingKeys.get(0) == CompiledValue.MAP_INDEX_ALL_KEYS) {
                    this.isMapTypeIndex = true;
                    this.isAllKeys = true;
                    expr = mi.getReceiverSansIndexArgs();
                    expr.generateCanonicalizedExpression(sb, this.context);
                    sb.append('[').append('*').append(']');
                } else if (indexingKeys.size() == 1) {
                    expr.generateCanonicalizedExpression(sb, this.context);
                } else {
                    this.isMapTypeIndex = true;
                    this.multiIndexKeysPattern = new String[indexingKeys.size()];
                    this.mapKeys = new Object[indexingKeys.size()];
                    expr = mi.getReceiverSansIndexArgs();
                    expr.generateCanonicalizedExpression(sb, this.context);
                    sb.append('[');
                    String prefixStr = sb.toString();
                    StringBuilder sb2 = new StringBuilder();
                    int size = indexingKeys.size();
                    for (int j = 0; j < size; ++j) {
                        CompiledValue cv = indexingKeys.get(size - j - 1);
                        this.mapKeys[size - j - 1] = cv.evaluate(this.context);
                        StringBuilder sb3 = new StringBuilder();
                        cv.generateCanonicalizedExpression(sb3, this.context);
                        sb3.insert(0, prefixStr);
                        sb3.append(']');
                        this.multiIndexKeysPattern[j] = sb3.toString();
                        cv.generateCanonicalizedExpression(sb2, this.context);
                        sb2.insert(0, ',');
                    }
                    sb2.deleteCharAt(0);
                    sb.append((CharSequence)sb2);
                    sb.append(']');
                }
            } else {
                expr.generateCanonicalizedExpression(sb, this.context);
            }
            this.indexedExpression = sb.toString();
            this.modifiedIndexExpr = expr;
            if (!this.isFirstIteratorRegionEntry && this.indexedExpression.contains(this.canonicalizedIteratorNames[0])) {
                this.modifiedIndexExpr = this.getModifiedDependentCompiledValue(this.context, -1, expr, true);
            }
        }
        catch (Exception e) {
            throw new IndexInvalidException(String.format("Invalid indexed expression : ' %s '", indexedExpression), e);
        }
        this.indexedExpr = expr;
    }

    private void prepareProjectionAttributes(String projectionAttributes) throws IndexInvalidException {
        if (projectionAttributes != null && !projectionAttributes.equals("*")) {
            throw new IndexInvalidException(String.format("Invalid projection attributes : ' %s '", projectionAttributes));
        }
        this.projectionAttributes = projectionAttributes;
    }

    private Object[] modifyIterDefToSuiteIMQ(CompiledIteratorDef iterDef) throws IndexInvalidException {
        Object[] retValues = new Object[]{null, null};
        try {
            CompiledValue def = iterDef.getCollectionExpr();
            if (def instanceof CompiledRegion) {
                CompiledBindArgument bindArg = new CompiledBindArgument(1);
                CompiledIteratorDef newDef = new CompiledIteratorDef(iterDef.getName(), null, bindArg);
                retValues[0] = def.evaluate(this.context);
                retValues[1] = newDef;
                return retValues;
            }
            if (def instanceof CompiledPath || def instanceof CompiledOperation || def instanceof CompiledIndexOperation) {
                CompiledValue cv = def;
                ArrayList<Object> reconstruct = new ArrayList<Object>();
                while (!(cv instanceof CompiledRegion)) {
                    CompiledValue prevCV = cv;
                    if (cv instanceof CompiledOperation) {
                        reconstruct.add(0, ((CompiledOperation)cv).getArguments());
                        reconstruct.add(0, ((CompiledOperation)cv).getMethodName());
                        cv = ((CompiledOperation)cv).getReceiver(this.context);
                    } else if (cv instanceof CompiledPath) {
                        reconstruct.add(0, ((CompiledPath)cv).getTailID());
                        cv = ((CompiledPath)cv).getReceiver();
                    } else if (cv instanceof CompiledIndexOperation) {
                        reconstruct.add(0, ((CompiledIndexOperation)cv).getExpression());
                        cv = ((CompiledIndexOperation)cv).getReceiver();
                    } else {
                        throw new IndexInvalidException("FunctionalIndexCreationHelper::prepareFromClause:From clause is neither a CompiledPath nor CompiledOperation");
                    }
                    reconstruct.add(0, prevCV.getType());
                }
                CompiledValue v = cv;
                cv = new CompiledBindArgument(1);
                int len = reconstruct.size();
                for (int j = 0; j < len; ++j) {
                    Object obj = reconstruct.get(j);
                    if (!(obj instanceof Integer)) continue;
                    int tokenType = (Integer)obj;
                    if (tokenType == -5) {
                        cv = new CompiledPath(cv, (String)reconstruct.get(++j));
                        continue;
                    }
                    if (tokenType == 24) {
                        cv = new CompiledIndexOperation(cv, (CompiledValue)reconstruct.get(++j));
                        continue;
                    }
                    if (tokenType != 54) continue;
                    cv = new CompiledOperation(cv, (String)reconstruct.get(++j), (List)reconstruct.get(++j));
                }
                CompiledIteratorDef newDef = new CompiledIteratorDef(iterDef.getName(), null, cv);
                retValues[0] = v.evaluate(this.context);
                retValues[1] = newDef;
                return retValues;
            }
        }
        catch (Exception e) {
            throw new IndexInvalidException(e);
        }
        return retValues;
    }

    private CompiledValue getModifiedDependentCompiledValue(ExecutionContext context, int currItrID, CompiledValue cv, boolean isDependent) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        if (cv instanceof CompiledIteratorDef) {
            CompiledIteratorDef iterDef = (CompiledIteratorDef)cv;
            RuntimeIterator rItr = (RuntimeIterator)context.getCurrentIterators().get(currItrID);
            String canonFrmClause = rItr.getDefinition();
            isDependent = canonFrmClause.startsWith(this.canonicalizedIteratorNames[0]);
            return new CompiledIteratorDef(iterDef.getName(), rItr.getElementType(), this.getModifiedDependentCompiledValue(context, currItrID, iterDef.getCollectionExpr(), isDependent));
        }
        if (cv instanceof CompiledPath) {
            CompiledPath path = (CompiledPath)cv;
            return new CompiledPath(this.getModifiedDependentCompiledValue(context, currItrID, path.getReceiver(), isDependent), path.getTailID());
        }
        if (cv instanceof CompiledOperation) {
            CompiledOperation oper = (CompiledOperation)cv;
            List list = oper.getArguments();
            ArrayList<CompiledValue> newList = new ArrayList<CompiledValue>();
            for (Object aList : list) {
                CompiledValue cv1 = (CompiledValue)aList;
                StringBuilder sb = new StringBuilder();
                cv1.generateCanonicalizedExpression(sb, context);
                if (sb.toString().startsWith(this.canonicalizedIteratorNames[0])) {
                    newList.add(this.getModifiedDependentCompiledValue(context, currItrID, cv1, true));
                    continue;
                }
                newList.add(this.getModifiedDependentCompiledValue(context, currItrID, cv1, false));
            }
            CompiledValue rec = oper.getReceiver(context);
            if (rec == null) {
                if (isDependent) {
                    rec = this.missingLink;
                }
                return new CompiledOperation(rec, oper.getMethodName(), newList);
            }
            return new CompiledOperation(this.getModifiedDependentCompiledValue(context, currItrID, rec, isDependent), oper.getMethodName(), newList);
        }
        if (cv instanceof CompiledFunction) {
            CompiledFunction cf = (CompiledFunction)cv;
            CompiledValue[] cvArray = cf.getArguments();
            int function = cf.getFunction();
            int len = cvArray.length;
            CompiledValue[] newCvArray = new CompiledValue[len];
            for (int i = 0; i < len; ++i) {
                CompiledValue cv1 = cvArray[i];
                StringBuilder sb = new StringBuilder();
                cv1.generateCanonicalizedExpression(sb, context);
                newCvArray[i] = sb.toString().startsWith(this.canonicalizedIteratorNames[0]) ? this.getModifiedDependentCompiledValue(context, currItrID, cv1, true) : this.getModifiedDependentCompiledValue(context, currItrID, cv1, false);
            }
            return new CompiledFunction(newCvArray, function);
        }
        if (cv instanceof CompiledID) {
            CompiledID id = (CompiledID)cv;
            RuntimeIterator rItr0 = (RuntimeIterator)context.getCurrentIterators().get(0);
            if (isDependent) {
                String name = rItr0.getName();
                if (name != null && name.equals(id.getId())) {
                    return this.missingLink;
                }
                return new CompiledPath(this.missingLink, id.getId());
            }
            return cv;
        }
        if (cv instanceof CompiledIndexOperation) {
            CompiledIndexOperation co = (CompiledIndexOperation)cv;
            CompiledValue cv1 = co.getExpression();
            StringBuilder sb = new StringBuilder();
            cv1.generateCanonicalizedExpression(sb, context);
            cv1 = sb.toString().startsWith(this.canonicalizedIteratorNames[0]) ? this.getModifiedDependentCompiledValue(context, currItrID, cv1, true) : this.getModifiedDependentCompiledValue(context, currItrID, cv1, false);
            return new CompiledIndexOperation(this.getModifiedDependentCompiledValue(context, currItrID, co.getReceiver(), isDependent), cv1);
        }
        return cv;
    }

    private void remove(List list, int count, int index) {
        for (int j = 0; j < count; ++j) {
            list.remove(index);
        }
    }
}

