/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.Map;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.pdx.internal.EnumInfo;

public class GetPDXEnumsOp {
    public static Map<Integer, EnumInfo> execute(ExecutablePool pool) {
        GetPDXEnumsOpImpl op = new GetPDXEnumsOpImpl();
        return (Map)pool.execute(op);
    }

    private GetPDXEnumsOp() {
    }

    private static class GetPDXEnumsOpImpl
    extends AbstractOp {
        public GetPDXEnumsOpImpl() {
            super(102, 1);
            this.getMessage().addIntPart(0);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            if (msgType == 1) {
                return (Map)part.getObject();
            }
            if (msgType == 2) {
                String s = "While performing a remote getPdxEnums";
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return 0L;
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
        }

        @Override
        protected boolean participateInTransaction() {
            return false;
        }
    }
}

