/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal.spi;

import org.apache.geode.annotations.VisibleForTesting;

public class AlertingAction {
    private static final ThreadLocal<Boolean> ALERTING = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static void execute(Runnable action) {
        if (ALERTING.get().booleanValue()) {
            return;
        }
        ALERTING.set(true);
        try {
            action.run();
        }
        finally {
            ALERTING.remove();
        }
    }

    public static boolean isThreadAlerting() {
        return ALERTING.get();
    }

    @VisibleForTesting
    static void setThreadAlerting(boolean value) {
        ALERTING.set(value);
        if (!value) {
            ALERTING.remove();
        }
    }
}

