/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.parallel;

import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.pooling.ConnectionDestroyedException;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderEventDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderEventRemoteDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RemoteParallelGatewaySenderEventProcessor
extends ParallelGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();

    protected RemoteParallelGatewaySenderEventProcessor(AbstractGatewaySender sender, ThreadsMonitoring tMonitoring, boolean cleanQueues) {
        super(sender, tMonitoring, cleanQueues);
    }

    protected RemoteParallelGatewaySenderEventProcessor(AbstractGatewaySender sender, Set<Region> userRegions, int id, int nDispatcher, ThreadsMonitoring tMonitoring, boolean cleanQueues) {
        super(sender, userRegions, id, nDispatcher, tMonitoring, cleanQueues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rebalance() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        long startTime = statistics.startLoadBalance();
        try {
            GatewaySenderEventRemoteDispatcher remoteDispatcher;
            if (this.dispatcher.isRemoteDispatcher() && (remoteDispatcher = (GatewaySenderEventRemoteDispatcher)this.dispatcher).isConnectedToRemote()) {
                remoteDispatcher.stopAckReaderThread();
                remoteDispatcher.destroyConnection();
            }
        }
        finally {
            statistics.endLoadBalance(startTime);
        }
    }

    @Override
    public void initializeEventDispatcher() {
        if (logger.isDebugEnabled()) {
            logger.debug(" Creating the GatewayEventRemoteDispatcher");
        }
        if (this.sender.getRemoteDSId() != -1) {
            this.dispatcher = new GatewaySenderEventRemoteDispatcher(this);
        }
    }

    private boolean shouldSendVersionEvents(GatewaySenderEventDispatcher disp) throws GatewaySenderException {
        try {
            short remoteSiteVersion;
            GatewaySenderEventRemoteDispatcher remoteDispatcher = (GatewaySenderEventRemoteDispatcher)disp;
            Connection conn = remoteDispatcher.getConnection(false);
            if (conn != null && KnownVersion.GFE_701.compareTo(Versioning.getVersion(remoteSiteVersion = conn.getWanSiteVersion())) <= 0) {
                return true;
            }
        }
        catch (GatewaySenderException e) {
            block7: {
                Throwable cause = e.getCause();
                if (cause instanceof IOException || e instanceof GatewaySenderConfigurationException || cause instanceof ConnectionDestroyedException) {
                    try {
                        int sleepInterval = GatewaySender.CONNECTION_RETRY_INTERVAL;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sleeping for {} milliseconds", (Object)sleepInterval);
                        }
                        Thread.sleep(sleepInterval);
                    }
                    catch (InterruptedException ie) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug(ie.getMessage(), (Throwable)ie);
                    }
                }
            }
            throw e;
        }
        return false;
    }
}

