/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.statistics;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsClockFactory;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.redis.internal.RedisCommandType;
import org.apache.geode.redis.internal.statistics.GeodeRedisStats;

public class RedisStats {
    private final AtomicLong commandsProcessed = new AtomicLong();
    private final AtomicLong totalNetworkBytesRead = new AtomicLong();
    private final AtomicLong totalConnectionsReceived = new AtomicLong();
    private final AtomicLong currentlyConnectedClients = new AtomicLong();
    private final AtomicLong expirations = new AtomicLong();
    private final AtomicLong keyspaceHits = new AtomicLong();
    private final AtomicLong keyspaceMisses = new AtomicLong();
    private final ScheduledExecutorService perSecondExecutor;
    private volatile double networkKiloBytesReadOverLastSecond;
    private volatile long opsPerformedLastTick;
    private double opsPerformedOverLastSecond;
    private long previousNetworkBytesRead;
    private final StatisticsClock clock;
    private final GeodeRedisStats geodeRedisStats;
    private final long START_TIME_IN_NANOS;

    public RedisStats(StatisticsClock clock, GeodeRedisStats geodeRedisStats) {
        this.clock = clock;
        this.geodeRedisStats = geodeRedisStats;
        this.perSecondExecutor = this.startPerSecondUpdater();
        this.START_TIME_IN_NANOS = clock.getTime();
    }

    public void incCommandsProcessed() {
        this.commandsProcessed.incrementAndGet();
        this.geodeRedisStats.incrementCommandsProcessed();
    }

    public long getCommandsProcessed() {
        return this.commandsProcessed.get();
    }

    public void addClient() {
        this.totalConnectionsReceived.incrementAndGet();
        this.currentlyConnectedClients.incrementAndGet();
        this.geodeRedisStats.addClient();
    }

    public void removeClient() {
        this.currentlyConnectedClients.decrementAndGet();
        this.geodeRedisStats.removeClient();
    }

    public long getTotalConnectionsReceived() {
        return this.totalConnectionsReceived.get();
    }

    public long getConnectedClients() {
        return this.currentlyConnectedClients.get();
    }

    public double getNetworkKiloBytesReadOverLastSecond() {
        return this.networkKiloBytesReadOverLastSecond;
    }

    public double getOpsPerformedOverLastSecond() {
        return this.opsPerformedOverLastSecond;
    }

    public long startCommand() {
        return StatisticsClockFactory.getTime();
    }

    public void endCommand(RedisCommandType command, long start) {
        this.geodeRedisStats.endCommand(command, start);
    }

    public void incNetworkBytesRead(long bytesRead) {
        this.totalNetworkBytesRead.addAndGet(bytesRead);
        this.geodeRedisStats.incrementTotalNetworkBytesRead(bytesRead);
    }

    public long getTotalNetworkBytesRead() {
        return this.totalNetworkBytesRead.get();
    }

    private long getCurrentTimeNanos() {
        return this.clock.getTime();
    }

    public long getUptimeInMilliseconds() {
        long uptimeInNanos = this.getCurrentTimeNanos() - this.START_TIME_IN_NANOS;
        return TimeUnit.NANOSECONDS.toMillis(uptimeInNanos);
    }

    public long getUptimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.getUptimeInMilliseconds());
    }

    public long getUptimeInDays() {
        return TimeUnit.MILLISECONDS.toDays(this.getUptimeInMilliseconds());
    }

    public void incKeyspaceHits() {
        this.keyspaceHits.incrementAndGet();
        this.geodeRedisStats.incrementKeyspaceHits();
    }

    public long getKeyspaceHits() {
        return this.keyspaceHits.get();
    }

    public void incKeyspaceMisses() {
        this.keyspaceMisses.incrementAndGet();
        this.geodeRedisStats.incrementKeyspaceMisses();
    }

    public long getKeyspaceMisses() {
        return this.keyspaceMisses.get();
    }

    public long startPassiveExpirationCheck() {
        return this.getCurrentTimeNanos();
    }

    public void endPassiveExpirationCheck(long start, long expireCount) {
        this.geodeRedisStats.endPassiveExpirationCheck(start, expireCount);
    }

    public long startExpiration() {
        return this.getCurrentTimeNanos();
    }

    public void endExpiration(long start) {
        this.geodeRedisStats.endExpiration(start);
        this.expirations.incrementAndGet();
    }

    public void close() {
        this.geodeRedisStats.close();
        this.stopPerSecondUpdater();
    }

    private ScheduledExecutorService startPerSecondUpdater() {
        int INTERVAL = 1;
        ScheduledExecutorService perSecondExecutor = LoggingExecutors.newSingleThreadScheduledExecutor((String)"GemFireRedis-PerSecondUpdater-");
        perSecondExecutor.scheduleWithFixedDelay(() -> this.doPerSecondUpdates(), INTERVAL, INTERVAL, TimeUnit.SECONDS);
        return perSecondExecutor;
    }

    private void stopPerSecondUpdater() {
        this.perSecondExecutor.shutdownNow();
    }

    private void doPerSecondUpdates() {
        this.updateNetworkKilobytesReadLastSecond();
        this.updateOpsPerformedOverLastSecond();
    }

    private void updateNetworkKilobytesReadLastSecond() {
        long totalNetworkBytesRead = this.getTotalNetworkBytesRead();
        long deltaNetworkBytesRead = totalNetworkBytesRead - this.previousNetworkBytesRead;
        this.networkKiloBytesReadOverLastSecond = deltaNetworkBytesRead / 1000L;
        this.previousNetworkBytesRead = this.getTotalNetworkBytesRead();
    }

    private void updateOpsPerformedOverLastSecond() {
        long totalOpsPerformed = this.getCommandsProcessed();
        this.opsPerformedOverLastSecond = totalOpsPerformed - this.opsPerformedLastTick;
        this.opsPerformedLastTick = this.getCommandsProcessed();
    }
}

