/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class IncrByExecutor
extends StringExecutor {
    private static final String ERROR_INCREMENT_NOT_USABLE = "The increment on this key must be numeric";
    private static final int INCREMENT_INDEX = 2;

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        long increment;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey key = command.getKey();
        RedisStringCommands stringCommands = this.getRedisStringCommands(context);
        byte[] incrArray = commandElems.get(2);
        try {
            increment = Coder.bytesToLong(incrArray);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error(ERROR_INCREMENT_NOT_USABLE);
        }
        long value = stringCommands.incrby(key, increment);
        return RedisResponse.integer(value);
    }
}

